/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class IntArrayTag
implements CollectionTag {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<IntArrayTag> TYPE = new TagType.VariableSize<IntArrayTag>(){

        @Override
        public IntArrayTag load(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            return new IntArrayTag(1.readAccounted(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NbtAccounter nbtreadlimiter) throws IOException {
            return streamtagvisitor.visit(1.readAccounted(datainput, nbtreadlimiter));
        }

        private static int[] readAccounted(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            nbtreadlimiter.accountBytes(24L);
            int i = datainput.readInt();
            nbtreadlimiter.accountBytes(4L, i);
            int[] aint = new int[i];
            for (int j = 0; j < i; ++j) {
                aint[j] = datainput.readInt();
            }
            return aint;
        }

        @Override
        public void skip(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 4);
        }

        @Override
        public String getName() {
            return "INT[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int_Array";
        }
    };
    private int[] data;

    public IntArrayTag(int[] aint) {
        this.data = aint;
    }

    @Override
    public void write(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.data.length);
        for (int i : this.data) {
            dataoutput.writeInt(i);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 4 * this.data.length;
    }

    @Override
    public byte getId() {
        return 11;
    }

    public TagType<IntArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor stringtagvisitor = new StringTagVisitor();
        stringtagvisitor.visitIntArray(this);
        return stringtagvisitor.build();
    }

    @Override
    public IntArrayTag copy() {
        int[] aint = new int[this.data.length];
        System.arraycopy(this.data, 0, aint, 0, this.data.length);
        return new IntArrayTag(aint);
    }

    public boolean equals(Object object) {
        return this == object ? true : object instanceof IntArrayTag && Arrays.equals(this.data, ((IntArrayTag)object).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] getAsIntArray() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor tagvisitor) {
        tagvisitor.visitIntArray(this);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public IntTag get(int i) {
        return IntTag.valueOf(this.data[i]);
    }

    @Override
    public boolean setTag(int i, Tag nbtbase) {
        if (nbtbase instanceof NumericTag) {
            NumericTag nbtnumber = (NumericTag)nbtbase;
            this.data[i] = nbtnumber.intValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int i, Tag nbtbase) {
        if (nbtbase instanceof NumericTag) {
            NumericTag nbtnumber = (NumericTag)nbtbase;
            this.data = ArrayUtils.add((int[])this.data, (int)i, (int)nbtnumber.intValue());
            return true;
        }
        return false;
    }

    @Override
    public IntTag remove(int i) {
        int j = this.data[i];
        this.data = ArrayUtils.remove((int[])this.data, (int)i);
        return IntTag.valueOf(j);
    }

    @Override
    public void clear() {
        this.data = new int[0];
    }

    @Override
    public Optional<int[]> asIntArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.visit(this.data);
    }
}

