/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern UNQUOTED_KEY_MATCH = Pattern.compile("[A-Za-z._]+[A-Za-z0-9._+-]*");
    private final StringBuilder builder = new StringBuilder();

    public String build() {
        return this.builder.toString();
    }

    @Override
    public void visitString(StringTag var0) {
        this.builder.append(StringTag.quoteAndEscape(var0.value()));
    }

    @Override
    public void visitByte(ByteTag var0) {
        this.builder.append(var0.value()).append('b');
    }

    @Override
    public void visitShort(ShortTag var0) {
        this.builder.append(var0.value()).append('s');
    }

    @Override
    public void visitInt(IntTag var0) {
        this.builder.append(var0.value());
    }

    @Override
    public void visitLong(LongTag var0) {
        this.builder.append(var0.value()).append('L');
    }

    @Override
    public void visitFloat(FloatTag var0) {
        this.builder.append(var0.value()).append('f');
    }

    @Override
    public void visitDouble(DoubleTag var0) {
        this.builder.append(var0.value()).append('d');
    }

    @Override
    public void visitByteArray(ByteArrayTag var0) {
        this.builder.append("[B;");
        byte[] var1 = var0.getAsByteArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]).append('B');
        }
        this.builder.append(']');
    }

    @Override
    public void visitIntArray(IntArrayTag var0) {
        this.builder.append("[I;");
        int[] var1 = var0.getAsIntArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]);
        }
        this.builder.append(']');
    }

    @Override
    public void visitLongArray(LongArrayTag var0) {
        this.builder.append("[L;");
        long[] var1 = var0.getAsLongArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]).append('L');
        }
        this.builder.append(']');
    }

    @Override
    public void visitList(ListTag var0) {
        this.builder.append('[');
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            if (var1 != 0) {
                this.builder.append(',');
            }
            var0.get(var1).accept(this);
        }
        this.builder.append(']');
    }

    @Override
    public void visitCompound(CompoundTag var0) {
        this.builder.append('{');
        ArrayList<Map.Entry<String, Tag>> var1 = new ArrayList<Map.Entry<String, Tag>>(var0.entrySet());
        var1.sort(Map.Entry.comparingByKey());
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            Map.Entry var3 = (Map.Entry)var1.get(var2);
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.handleKeyEscape((String)var3.getKey());
            this.builder.append(':');
            ((Tag)var3.getValue()).accept(this);
        }
        this.builder.append('}');
    }

    private void handleKeyEscape(String var0) {
        if (!var0.equalsIgnoreCase("true") && !var0.equalsIgnoreCase("false") && UNQUOTED_KEY_MATCH.matcher(var0).matches()) {
            this.builder.append(var0);
        } else {
            StringTag.quoteAndEscape(var0, this.builder);
        }
    }

    @Override
    public void visitEnd(EndTag var0) {
        this.builder.append("END");
    }
}

