/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.SignedArgument;

public record SignableCommand<S>(List<Argument<S>> arguments) {
    public static <S> boolean hasSignableArguments(ParseResults<S> var0) {
        return !SignableCommand.of(var0).arguments().isEmpty();
    }

    public static <S> SignableCommand<S> of(ParseResults<S> var0) {
        CommandContextBuilder var5;
        CommandContextBuilder var2;
        String var1 = var0.getReader().getString();
        CommandContextBuilder var3 = var2 = var0.getContext();
        List<Argument<S>> var4 = SignableCommand.collectArguments(var1, var3);
        while ((var5 = var3.getChild()) != null && var5.getRootNode() != var2.getRootNode()) {
            var4.addAll(SignableCommand.collectArguments(var1, var5));
            var3 = var5;
        }
        return new SignableCommand<S>(var4);
    }

    private static <S> List<Argument<S>> collectArguments(String var0, CommandContextBuilder<S> var1) {
        ArrayList<Argument<S>> var2 = new ArrayList<Argument<S>>();
        for (ParsedCommandNode var4 : var1.getNodes()) {
            ParsedArgument var6;
            ArgumentCommandNode var5;
            CommandNode commandNode = var4.getNode();
            if (!(commandNode instanceof ArgumentCommandNode) || !((var5 = (ArgumentCommandNode)commandNode).getType() instanceof SignedArgument) || (var6 = (ParsedArgument)var1.getArguments().get(var5.getName())) == null) continue;
            String var7 = var6.getRange().get(var0);
            var2.add(new Argument(var5, var7));
        }
        return var2;
    }

    @Nullable
    public Argument<S> getArgument(String var0) {
        for (Argument<S> var2 : this.arguments) {
            if (!var0.equals(var2.name())) continue;
            return var2;
        }
        return null;
    }

    public record Argument<S>(ArgumentCommandNode<S, ?> node, String value) {
        public String name() {
            return this.node.getName();
        }
    }
}

