/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.network.chat.contents.data.DataSources;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NbtContents> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::getNbtPath), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::isInterpreting), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("separator").forGetter(NbtContents::getSeparator), (App)DataSources.CODEC.forGetter(NbtContents::getDataSource)).apply((Applicative)var0, NbtContents::new));
    private final boolean interpreting;
    private final Optional<Component> separator;
    private final String nbtPathPattern;
    private final DataSource dataSource;
    @Nullable
    protected final NbtPathArgument.NbtPath compiledNbtPath;

    public NbtContents(String var0, boolean var1, Optional<Component> var2, DataSource var3) {
        this(var0, NbtContents.compileNbtPath(var0), var1, var2, var3);
    }

    private NbtContents(String var0, @Nullable NbtPathArgument.NbtPath var1, boolean var2, Optional<Component> var3, DataSource var4) {
        this.nbtPathPattern = var0;
        this.compiledNbtPath = var1;
        this.interpreting = var2;
        this.separator = var3;
        this.dataSource = var4;
    }

    @Nullable
    private static NbtPathArgument.NbtPath compileNbtPath(String var0) {
        try {
            return new NbtPathArgument().parse(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    public String getNbtPath() {
        return this.nbtPathPattern;
    }

    public boolean isInterpreting() {
        return this.interpreting;
    }

    public Optional<Component> getSeparator() {
        return this.separator;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof NbtContents)) return false;
        NbtContents var1 = (NbtContents)var0;
        if (!this.dataSource.equals(var1.dataSource)) return false;
        if (!this.separator.equals(var1.separator)) return false;
        if (this.interpreting != var1.interpreting) return false;
        if (!this.nbtPathPattern.equals(var1.nbtPathPattern)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.interpreting ? 1 : 0;
        var0 = 31 * var0 + this.separator.hashCode();
        var0 = 31 * var0 + this.nbtPathPattern.hashCode();
        var0 = 31 * var0 + this.dataSource.hashCode();
        return var0;
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.dataSource) + ", interpreting=" + this.interpreting + ", separator=" + String.valueOf(this.separator) + "}";
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack var02, @Nullable Entity var13, int var22) throws CommandSyntaxException {
        if (var02 == null || this.compiledNbtPath == null) {
            return Component.empty();
        }
        Stream<String> var3 = this.dataSource.getData(var02).flatMap(var0 -> {
            try {
                return this.compiledNbtPath.get((Tag)var0).stream();
            }
            catch (CommandSyntaxException var1) {
                return Stream.empty();
            }
        });
        if (this.interpreting) {
            RegistryOps<Tag> var42 = var02.registryAccess().createSerializationContext(NbtOps.INSTANCE);
            Component var5 = (Component)DataFixUtils.orElse(ComponentUtils.updateForEntity(var02, this.separator, var13, var22), (Object)ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR);
            return var3.flatMap(var4 -> {
                try {
                    Component var5 = (Component)ComponentSerialization.CODEC.parse((DynamicOps)var42, var4).getOrThrow();
                    return Stream.of(ComponentUtils.updateForEntity(var02, var5, var13, var22));
                }
                catch (Exception var5) {
                    LOGGER.warn("Failed to parse component: {}", var4, (Object)var5);
                    return Stream.of(new MutableComponent[0]);
                }
            }).reduce((var1, var2) -> var1.append(var5).append((Component)var2)).orElseGet(Component::empty);
        }
        Stream<String> var43 = var3.map(NbtContents::asString);
        return ComponentUtils.updateForEntity(var02, this.separator, var13, var22).map(var12 -> var43.map(Component::literal).reduce((var1, var2) -> var1.append((Component)var12).append((Component)var2)).orElseGet(Component::empty)).orElseGet(() -> Component.literal(var43.collect(Collectors.joining(", "))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String asString(Tag var0) {
        if (!(var0 instanceof StringTag)) return var0.toString();
        StringTag stringTag = (StringTag)var0;
        try {
            String string = stringTag.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public MapCodec<NbtContents> codec() {
        return MAP_CODEC;
    }
}

