/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class IdDispatchCodec<B extends ByteBuf, V, T>
implements StreamCodec<B, V> {
    private static final int UNKNOWN_TYPE = -1;
    private final Function<V, ? extends T> typeGetter;
    private final List<Entry<B, V, T>> byId;
    private final Object2IntMap<T> toId;

    IdDispatchCodec(Function<V, ? extends T> var0, List<Entry<B, V, T>> var1, Object2IntMap<T> var2) {
        this.typeGetter = var0;
        this.byId = var1;
        this.toId = var2;
    }

    @Override
    public V decode(B var0) {
        int var1 = VarInt.read(var0);
        if (var1 < 0 || var1 >= this.byId.size()) {
            throw new DecoderException("Received unknown packet id " + var1);
        }
        Entry<B, V, T> var2 = this.byId.get(var1);
        try {
            return (V)var2.serializer.decode(var0);
        }
        catch (Exception var3) {
            if (var3 instanceof DontDecorateException) {
                throw var3;
            }
            throw new DecoderException("Failed to decode packet '" + String.valueOf(var2.type) + "'", (Throwable)var3);
        }
    }

    @Override
    public void encode(B var0, V var1) {
        T var2 = this.typeGetter.apply(var1);
        int var3 = this.toId.getOrDefault(var2, -1);
        if (var3 == -1) {
            throw new EncoderException("Sending unknown packet '" + String.valueOf(var2) + "'");
        }
        VarInt.write(var0, var3);
        Entry<B, V, T> var4 = this.byId.get(var3);
        try {
            StreamCodec var5 = var4.serializer;
            var5.encode(var0, var1);
        }
        catch (Exception var5) {
            if (var5 instanceof DontDecorateException) {
                throw var5;
            }
            throw new EncoderException("Failed to encode packet '" + String.valueOf(var2) + "'", (Throwable)var5);
        }
    }

    public static <B extends ByteBuf, V, T> Builder<B, V, T> builder(Function<V, ? extends T> var0) {
        return new Builder(var0);
    }

    @Override
    public /* synthetic */ void encode(Object object, Object object2) {
        this.encode((B)((ByteBuf)object), (V)object2);
    }

    @Override
    public /* synthetic */ Object decode(Object object) {
        return this.decode((B)((ByteBuf)object));
    }

    static final class Entry<B, V, T>
    extends Record {
        final StreamCodec<? super B, ? extends V> serializer;
        final T type;

        Entry(StreamCodec<? super B, ? extends V> var0, T var1) {
            this.serializer = var0;
            this.type = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "serializer;type", "serializer", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "serializer;type", "serializer", "type"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "serializer;type", "serializer", "type"}, this, var0);
        }

        public StreamCodec<? super B, ? extends V> serializer() {
            return this.serializer;
        }

        public T type() {
            return this.type;
        }
    }

    public static interface DontDecorateException {
    }

    public static class Builder<B extends ByteBuf, V, T> {
        private final List<Entry<B, V, T>> entries = new ArrayList<Entry<B, V, T>>();
        private final Function<V, ? extends T> typeGetter;

        Builder(Function<V, ? extends T> var0) {
            this.typeGetter = var0;
        }

        public Builder<B, V, T> add(T var0, StreamCodec<? super B, ? extends V> var1) {
            this.entries.add(new Entry<B, V, T>(var1, var0));
            return this;
        }

        public IdDispatchCodec<B, V, T> build() {
            Object2IntOpenHashMap var0 = new Object2IntOpenHashMap();
            var0.defaultReturnValue(-2);
            for (Entry<B, V, T> var2 : this.entries) {
                int var3 = var0.size();
                int var4 = var0.putIfAbsent(var2.type, var3);
                if (var4 == -2) continue;
                throw new IllegalStateException("Duplicate registration for type " + String.valueOf(var2.type));
            }
            return new IdDispatchCodec<B, V, T>(this.typeGetter, List.copyOf(this.entries), var0);
        }
    }
}

