/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.CodecModifier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;
import net.minecraft.network.protocol.SimpleUnboundProtocol;
import net.minecraft.network.protocol.UnboundProtocol;
import net.minecraft.util.Unit;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf, C> {
    final ConnectionProtocol protocol;
    final PacketFlow flow;
    private final List<CodecEntry<T, ?, B, C>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(ConnectionProtocol var0, PacketFlow var1) {
        this.protocol = var0;
        this.flow = var1;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B, C> addPacket(PacketType<P> var0, StreamCodec<? super B, P> var1) {
        this.codecs.add(new CodecEntry(var0, var1, null));
        return this;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B, C> addPacket(PacketType<P> var0, StreamCodec<? super B, P> var1, CodecModifier<B, P, C> var2) {
        this.codecs.add(new CodecEntry(var0, var1, var2));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B, C> withBundlePacket(PacketType<P> var0, Function<Iterable<Packet<? super T>>, P> var1, D var2) {
        StreamCodec var3 = StreamCodec.unit(var2);
        PacketType<BundleDelimiterPacket<? super T>> var4 = var2.type();
        this.codecs.add(new CodecEntry(var4, var3, null));
        this.bundlerInfo = BundlerInfo.createForPacket(var0, var1, var2);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> var0, List<CodecEntry<T, ?, B, C>> var1, C var2) {
        ProtocolCodecBuilder var3 = new ProtocolCodecBuilder(this.flow);
        for (CodecEntry codecEntry : var1) {
            codecEntry.addToBuilder(var3, var0, var2);
        }
        return var3.build();
    }

    private static ProtocolInfo.Details buildDetails(final ConnectionProtocol var0, final PacketFlow var1, final List<? extends CodecEntry<?, ?, ?, ?>> var2) {
        return new ProtocolInfo.Details(){

            @Override
            public ConnectionProtocol id() {
                return var0;
            }

            @Override
            public PacketFlow flow() {
                return var1;
            }

            @Override
            public void listPackets(ProtocolInfo.Details.PacketVisitor var02) {
                for (int var12 = 0; var12 < var2.size(); ++var12) {
                    CodecEntry var22 = (CodecEntry)var2.get(var12);
                    var02.accept(var22.type, var12);
                }
            }
        };
    }

    public SimpleUnboundProtocol<T, B> buildUnbound(final C var0) {
        final List<CodecEntry<T, ?, B, C>> var1 = List.copyOf(this.codecs);
        final BundlerInfo var2 = this.bundlerInfo;
        final ProtocolInfo.Details var3 = ProtocolInfoBuilder.buildDetails(this.protocol, this.flow, var1);
        return new SimpleUnboundProtocol<T, B>(){

            @Override
            public ProtocolInfo<T> bind(Function<ByteBuf, B> var02) {
                return new Implementation(ProtocolInfoBuilder.this.protocol, ProtocolInfoBuilder.this.flow, ProtocolInfoBuilder.this.buildPacketCodec(var02, var1, var0), var2);
            }

            @Override
            public ProtocolInfo.Details details() {
                return var3;
            }
        };
    }

    public UnboundProtocol<T, B, C> buildUnbound() {
        final List<CodecEntry<T, ?, B, C>> var0 = List.copyOf(this.codecs);
        final BundlerInfo var1 = this.bundlerInfo;
        final ProtocolInfo.Details var2 = ProtocolInfoBuilder.buildDetails(this.protocol, this.flow, var0);
        return new UnboundProtocol<T, B, C>(){

            @Override
            public ProtocolInfo<T> bind(Function<ByteBuf, B> var02, C var12) {
                return new Implementation(ProtocolInfoBuilder.this.protocol, ProtocolInfoBuilder.this.flow, ProtocolInfoBuilder.this.buildPacketCodec(var02, var0, var12), var1);
            }

            @Override
            public ProtocolInfo.Details details() {
                return var2;
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> SimpleUnboundProtocol<L, B> protocol(ConnectionProtocol var0, PacketFlow var1, Consumer<ProtocolInfoBuilder<L, B, Unit>> var2) {
        ProtocolInfoBuilder var3 = new ProtocolInfoBuilder(var0, var1);
        var2.accept(var3);
        return var3.buildUnbound(Unit.INSTANCE);
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> SimpleUnboundProtocol<T, B> serverboundProtocol(ConnectionProtocol var0, Consumer<ProtocolInfoBuilder<T, B, Unit>> var1) {
        return ProtocolInfoBuilder.protocol(var0, PacketFlow.SERVERBOUND, var1);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> SimpleUnboundProtocol<T, B> clientboundProtocol(ConnectionProtocol var0, Consumer<ProtocolInfoBuilder<T, B, Unit>> var1) {
        return ProtocolInfoBuilder.protocol(var0, PacketFlow.CLIENTBOUND, var1);
    }

    private static <L extends PacketListener, B extends ByteBuf, C> UnboundProtocol<L, B, C> contextProtocol(ConnectionProtocol var0, PacketFlow var1, Consumer<ProtocolInfoBuilder<L, B, C>> var2) {
        ProtocolInfoBuilder var3 = new ProtocolInfoBuilder(var0, var1);
        var2.accept(var3);
        return var3.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf, C> UnboundProtocol<T, B, C> contextServerboundProtocol(ConnectionProtocol var0, Consumer<ProtocolInfoBuilder<T, B, C>> var1) {
        return ProtocolInfoBuilder.contextProtocol(var0, PacketFlow.SERVERBOUND, var1);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf, C> UnboundProtocol<T, B, C> contextClientboundProtocol(ConnectionProtocol var0, Consumer<ProtocolInfoBuilder<T, B, C>> var1) {
        return ProtocolInfoBuilder.contextProtocol(var0, PacketFlow.CLIENTBOUND, var1);
    }

    static final class CodecEntry<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf, C>
    extends Record {
        final PacketType<P> type;
        private final StreamCodec<? super B, P> serializer;
        @Nullable
        private final CodecModifier<B, P, C> modifier;

        CodecEntry(PacketType<P> var0, StreamCodec<? super B, P> var1, @Nullable CodecModifier<B, P, C> var2) {
            this.type = var0;
            this.serializer = var1;
            this.modifier = var2;
        }

        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> var0, Function<ByteBuf, B> var1, C var2) {
            StreamCodec<Object, P> var3 = this.modifier != null ? this.modifier.apply(this.serializer, var2) : this.serializer;
            StreamCodec<ByteBuf, P> var4 = var3.mapStream(var1);
            var0.add(this.type, var4);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CodecEntry.class, "type;serializer;modifier", "type", "serializer", "modifier"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CodecEntry.class, "type;serializer;modifier", "type", "serializer", "modifier"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CodecEntry.class, "type;serializer;modifier", "type", "serializer", "modifier"}, this, var0);
        }

        public PacketType<P> type() {
            return this.type;
        }

        public StreamCodec<? super B, P> serializer() {
            return this.serializer;
        }

        @Nullable
        public CodecModifier<B, P, C> modifier() {
            return this.modifier;
        }
    }

    record Implementation<L extends PacketListener>(ConnectionProtocol id, PacketFlow flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

