/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;

public class ClientboundContainerSetDataPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundContainerSetDataPacket> STREAM_CODEC = Packet.codec(ClientboundContainerSetDataPacket::write, ClientboundContainerSetDataPacket::new);
    private final int containerId;
    private final int id;
    private final int value;

    public ClientboundContainerSetDataPacket(int var0, int var1, int var2) {
        this.containerId = var0;
        this.id = var1;
        this.value = var2;
    }

    private ClientboundContainerSetDataPacket(FriendlyByteBuf var0) {
        this.containerId = var0.readContainerId();
        this.id = var0.readShort();
        this.value = var0.readShort();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeContainerId(this.containerId);
        var0.writeShort(this.id);
        var0.writeShort(this.value);
    }

    @Override
    public PacketType<ClientboundContainerSetDataPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CONTAINER_SET_DATA;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleContainerSetData(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getId() {
        return this.id;
    }

    public int getValue() {
        return this.value;
    }
}

