/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record ClientboundLoginPacket(int playerId, boolean hardcore, Set<ResourceKey<Level>> levels, int maxPlayers, int chunkRadius, int simulationDistance, boolean reducedDebugInfo, boolean showDeathScreen, boolean doLimitedCrafting, CommonPlayerSpawnInfo commonPlayerSpawnInfo, boolean enforcesSecureChat) implements Packet<ClientGamePacketListener>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundLoginPacket> STREAM_CODEC = Packet.codec(ClientboundLoginPacket::write, ClientboundLoginPacket::new);

    private ClientboundLoginPacket(RegistryFriendlyByteBuf var02) {
        this(var02.readInt(), var02.readBoolean(), var02.readCollection(Sets::newHashSetWithExpectedSize, var0 -> var0.readResourceKey(Registries.DIMENSION)), var02.readVarInt(), var02.readVarInt(), var02.readVarInt(), var02.readBoolean(), var02.readBoolean(), var02.readBoolean(), new CommonPlayerSpawnInfo(var02), var02.readBoolean());
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeInt(this.playerId);
        var0.writeBoolean(this.hardcore);
        var0.writeCollection(this.levels, FriendlyByteBuf::writeResourceKey);
        var0.writeVarInt(this.maxPlayers);
        var0.writeVarInt(this.chunkRadius);
        var0.writeVarInt(this.simulationDistance);
        var0.writeBoolean(this.reducedDebugInfo);
        var0.writeBoolean(this.showDeathScreen);
        var0.writeBoolean(this.doLimitedCrafting);
        this.commonPlayerSpawnInfo.write(var0);
        var0.writeBoolean(this.enforcesSecureChat);
    }

    @Override
    public PacketType<ClientboundLoginPacket> type() {
        return GamePacketTypes.CLIENTBOUND_LOGIN;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleLogin(this);
    }
}

