/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.BlockHitResult;

public class ServerboundUseItemOnPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundUseItemOnPacket> STREAM_CODEC = Packet.codec(ServerboundUseItemOnPacket::write, ServerboundUseItemOnPacket::new);
    private final BlockHitResult blockHit;
    private final InteractionHand hand;
    private final int sequence;

    public ServerboundUseItemOnPacket(InteractionHand enumhand, BlockHitResult movingobjectpositionblock, int i) {
        this.hand = enumhand;
        this.blockHit = movingobjectpositionblock;
        this.sequence = i;
    }

    private ServerboundUseItemOnPacket(FriendlyByteBuf packetdataserializer) {
        this.hand = packetdataserializer.readEnum(InteractionHand.class);
        this.blockHit = packetdataserializer.readBlockHitResult();
        this.sequence = packetdataserializer.readVarInt();
    }

    private void write(FriendlyByteBuf packetdataserializer) {
        packetdataserializer.writeEnum(this.hand);
        packetdataserializer.writeBlockHitResult(this.blockHit);
        packetdataserializer.writeVarInt(this.sequence);
    }

    @Override
    public PacketType<ServerboundUseItemOnPacket> type() {
        return GamePacketTypes.SERVERBOUND_USE_ITEM_ON;
    }

    @Override
    public void handle(ServerGamePacketListener packetlistenerplayin) {
        packetlistenerplayin.handleUseItemOn(this);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public BlockHitResult getHitResult() {
        return this.blockHit;
    }

    public int getSequence() {
        return this.sequence;
    }
}

