/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.SecretKey;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;

public class ServerboundKeyPacket
implements Packet<ServerLoginPacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundKeyPacket> STREAM_CODEC = Packet.codec(ServerboundKeyPacket::write, ServerboundKeyPacket::new);
    private final byte[] keybytes;
    private final byte[] encryptedChallenge;

    public ServerboundKeyPacket(SecretKey var0, PublicKey var1, byte[] var2) throws CryptException {
        this.keybytes = Crypt.encryptUsingKey(var1, var0.getEncoded());
        this.encryptedChallenge = Crypt.encryptUsingKey(var1, var2);
    }

    private ServerboundKeyPacket(FriendlyByteBuf var0) {
        this.keybytes = var0.readByteArray();
        this.encryptedChallenge = var0.readByteArray();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeByteArray(this.keybytes);
        var0.writeByteArray(this.encryptedChallenge);
    }

    @Override
    public PacketType<ServerboundKeyPacket> type() {
        return LoginPacketTypes.SERVERBOUND_KEY;
    }

    @Override
    public void handle(ServerLoginPacketListener var0) {
        var0.handleKey(this);
    }

    public SecretKey getSecretKey(PrivateKey var0) throws CryptException {
        return Crypt.decryptByteToSecretKey(var0, this.keybytes);
    }

    public boolean isChallengeValid(byte[] var0, PrivateKey var1) {
        try {
            return Arrays.equals(var0, Crypt.decryptUsingKey(var1, this.encryptedChallenge));
        }
        catch (CryptException var2) {
            return false;
        }
    }
}

