/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.server.DebugLoggedPrintStream;
import net.minecraft.server.LoggedPrintStream;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.slf4j.Logger;

@SuppressForbidden(reason="System.out setup")
public class Bootstrap {
    public static final PrintStream STDOUT = System.out;
    private static volatile boolean isBootstrapped;
    private static final Logger LOGGER;
    public static final AtomicLong bootstrapDuration;

    public static void bootStrap() {
        if (!isBootstrapped) {
            String name;
            switch (name = Bootstrap.class.getSimpleName()) {
                case "DispenserRegistry": {
                    break;
                }
                case "Bootstrap": {
                    System.err.println("***************************************************************************");
                    System.err.println("*** WARNING: This server jar may only be used for development purposes. ***");
                    System.err.println("***************************************************************************");
                    break;
                }
                default: {
                    System.err.println("**********************************************************************");
                    System.err.println("*** WARNING: This server jar is unsupported, use at your own risk. ***");
                    System.err.println("**********************************************************************");
                }
            }
            isBootstrapped = true;
            Instant instant = Instant.now();
            if (BuiltInRegistries.REGISTRY.keySet().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            FireBlock.bootStrap();
            ComposterBlock.bootStrap();
            if (EntityType.getKey(EntityType.PLAYER) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            EntitySelectorOptions.bootStrap();
            DispenseItemBehavior.bootStrap();
            CauldronInteraction.bootStrap();
            BuiltInRegistries.bootStrap();
            CreativeModeTabs.validate();
            Bootstrap.wrapStreams();
            bootstrapDuration.set(Duration.between(instant, Instant.now()).toMillis());
            BlockStateData.register(1008, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "0")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "0")));
            BlockStateData.register(1009, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "1")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "1")));
            BlockStateData.register(1010, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "2")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "2")));
            BlockStateData.register(1011, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "3")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "3")));
            BlockStateData.register(1012, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "4")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "4")));
            BlockStateData.register(1013, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "5")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "5")));
            BlockStateData.register(1014, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "6")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "6")));
            BlockStateData.register(1015, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "7")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "7")));
            BlockStateData.register(1016, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "8")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "8")));
            BlockStateData.register(1017, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "9")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "9")));
            BlockStateData.register(1018, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "10")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "10")));
            BlockStateData.register(1019, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "11")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "11")));
            BlockStateData.register(1020, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "12")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "12")));
            BlockStateData.register(1021, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "13")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "13")));
            BlockStateData.register(1022, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "14")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "14")));
            BlockStateData.register(1023, BlockStateData.create("minecraft:oak_sign", Map.of("rotation", "15")), BlockStateData.create("minecraft:standing_sign", Map.of("rotation", "15")));
            ItemIdFix.ITEM_NAMES.put(323, (Object)"minecraft:oak_sign");
            BlockStateData.register(1440, BlockStateData.create("minecraft:portal", Map.of("axis", "x")), BlockStateData.create("minecraft:portal", Map.of("axis", "x")));
            ItemIdFix.ITEM_NAMES.put(409, (Object)"minecraft:prismarine_shard");
            ItemIdFix.ITEM_NAMES.put(410, (Object)"minecraft:prismarine_crystals");
            ItemIdFix.ITEM_NAMES.put(411, (Object)"minecraft:rabbit");
            ItemIdFix.ITEM_NAMES.put(412, (Object)"minecraft:cooked_rabbit");
            ItemIdFix.ITEM_NAMES.put(413, (Object)"minecraft:rabbit_stew");
            ItemIdFix.ITEM_NAMES.put(414, (Object)"minecraft:rabbit_foot");
            ItemIdFix.ITEM_NAMES.put(415, (Object)"minecraft:rabbit_hide");
            ItemIdFix.ITEM_NAMES.put(416, (Object)"minecraft:armor_stand");
            ItemIdFix.ITEM_NAMES.put(423, (Object)"minecraft:mutton");
            ItemIdFix.ITEM_NAMES.put(424, (Object)"minecraft:cooked_mutton");
            ItemIdFix.ITEM_NAMES.put(425, (Object)"minecraft:banner");
            ItemIdFix.ITEM_NAMES.put(426, (Object)"minecraft:end_crystal");
            ItemIdFix.ITEM_NAMES.put(427, (Object)"minecraft:spruce_door");
            ItemIdFix.ITEM_NAMES.put(428, (Object)"minecraft:birch_door");
            ItemIdFix.ITEM_NAMES.put(429, (Object)"minecraft:jungle_door");
            ItemIdFix.ITEM_NAMES.put(430, (Object)"minecraft:acacia_door");
            ItemIdFix.ITEM_NAMES.put(431, (Object)"minecraft:dark_oak_door");
            ItemIdFix.ITEM_NAMES.put(432, (Object)"minecraft:chorus_fruit");
            ItemIdFix.ITEM_NAMES.put(433, (Object)"minecraft:chorus_fruit_popped");
            ItemIdFix.ITEM_NAMES.put(434, (Object)"minecraft:beetroot");
            ItemIdFix.ITEM_NAMES.put(435, (Object)"minecraft:beetroot_seeds");
            ItemIdFix.ITEM_NAMES.put(436, (Object)"minecraft:beetroot_soup");
            ItemIdFix.ITEM_NAMES.put(437, (Object)"minecraft:dragon_breath");
            ItemIdFix.ITEM_NAMES.put(438, (Object)"minecraft:splash_potion");
            ItemIdFix.ITEM_NAMES.put(439, (Object)"minecraft:spectral_arrow");
            ItemIdFix.ITEM_NAMES.put(440, (Object)"minecraft:tipped_arrow");
            ItemIdFix.ITEM_NAMES.put(441, (Object)"minecraft:lingering_potion");
            ItemIdFix.ITEM_NAMES.put(442, (Object)"minecraft:shield");
            ItemIdFix.ITEM_NAMES.put(443, (Object)"minecraft:elytra");
            ItemIdFix.ITEM_NAMES.put(444, (Object)"minecraft:spruce_boat");
            ItemIdFix.ITEM_NAMES.put(445, (Object)"minecraft:birch_boat");
            ItemIdFix.ITEM_NAMES.put(446, (Object)"minecraft:jungle_boat");
            ItemIdFix.ITEM_NAMES.put(447, (Object)"minecraft:acacia_boat");
            ItemIdFix.ITEM_NAMES.put(448, (Object)"minecraft:dark_oak_boat");
            ItemIdFix.ITEM_NAMES.put(449, (Object)"minecraft:totem_of_undying");
            ItemIdFix.ITEM_NAMES.put(450, (Object)"minecraft:shulker_shell");
            ItemIdFix.ITEM_NAMES.put(452, (Object)"minecraft:iron_nugget");
            ItemIdFix.ITEM_NAMES.put(453, (Object)"minecraft:knowledge_book");
            ItemSpawnEggFix.ID_TO_ENTITY[23] = "Arrow";
        }
    }

    private static <T> void checkTranslations(Iterable<T> iterable, Function<T, String> function, Set<String> set) {
        Language localelanguage = Language.getInstance();
        iterable.forEach(object -> {
            String s = (String)function.apply(object);
            if (!localelanguage.has(s)) {
                set.add(s);
            }
        });
    }

    private static void checkGameruleTranslations(final Set<String> set) {
        final Language localelanguage = Language.getInstance();
        GameRules gamerules = new GameRules(FeatureFlags.REGISTRY.allFlags());
        gamerules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> gamerules_gamerulekey, GameRules.Type<T> gamerules_gameruledefinition) {
                if (!localelanguage.has(gamerules_gamerulekey.getDescriptionId())) {
                    set.add(gamerules_gamerulekey.getId());
                }
            }
        });
    }

    public static Set<String> getMissingTranslations() {
        TreeSet<String> set = new TreeSet<String>();
        Bootstrap.checkTranslations(BuiltInRegistries.ATTRIBUTE, Attribute::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.ENTITY_TYPE, EntityType::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.MOB_EFFECT, MobEffect::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.ITEM, Item::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.BLOCK, BlockBehaviour::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.CUSTOM_STAT, minecraftkey -> {
            String s = minecraftkey.toString();
            return "stat." + s.replace(':', '.');
        }, set);
        Bootstrap.checkGameruleTranslations(set);
        return set;
    }

    public static void checkBootstrapCalled(Supplier<String> supplier) {
        if (!isBootstrapped) {
            throw Bootstrap.createBootstrapException(supplier);
        }
    }

    private static RuntimeException createBootstrapException(Supplier<String> supplier) {
        try {
            String s = supplier.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException runtimeexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            runtimeexception.addSuppressed(exception);
            return runtimeexception;
        }
    }

    public static void validate() {
        Bootstrap.checkBootstrapCalled(() -> "validate");
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Bootstrap.getMissingTranslations().forEach(s -> LOGGER.error("Missing translations: {}", s));
            Commands.validate();
        }
        DefaultAttributes.validate();
    }

    private static void wrapStreams() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr(new DebugLoggedPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggedPrintStream("STDOUT", STDOUT));
        } else {
            System.setErr(new LoggedPrintStream("STDERR", System.err));
            System.setOut(new LoggedPrintStream("STDOUT", STDOUT));
        }
    }

    public static void realStdoutPrintln(String s) {
        STDOUT.println(s);
    }

    static {
        LOGGER = LogUtils.getLogger();
        bootstrapDuration = new AtomicLong(-1L);
    }
}

