/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.profiling.ProfileResults;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class DebugCommand {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_NOT_RUNNING = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_RUNNING = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.alreadyRunning"));
    static final SimpleCommandExceptionType NO_RECURSIVE_TRACES = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.function.noRecursion"));
    static final SimpleCommandExceptionType NO_RETURN_RUN = new SimpleCommandExceptionType((Message)Component.translatable("commands.debug.function.noReturnRun"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("debug").requires(Commands.hasPermission(3))).then(Commands.literal("start").executes(var0 -> DebugCommand.start((CommandSourceStack)var0.getSource())))).then(Commands.literal("stop").executes(var0 -> DebugCommand.stop((CommandSourceStack)var0.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("function").requires(Commands.hasPermission(3))).then(Commands.argument("name", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).executes((Command)new TraceCustomExecutor())))));
    }

    private static int start(CommandSourceStack var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (var1.isTimeProfilerRunning()) {
            throw ERROR_ALREADY_RUNNING.create();
        }
        var1.startTimeProfiler();
        var0.sendSuccess(() -> Component.translatable("commands.debug.started"), true);
        return 0;
    }

    private static int stop(CommandSourceStack var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (!var1.isTimeProfilerRunning()) {
            throw ERROR_NOT_RUNNING.create();
        }
        ProfileResults var2 = var1.stopTimeProfiler();
        double var3 = (double)var2.getNanoDuration() / (double)TimeUtil.NANOSECONDS_PER_SECOND;
        double var5 = (double)var2.getTickDuration() / var3;
        var0.sendSuccess(() -> Component.translatable("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", var3), var2.getTickDuration(), String.format(Locale.ROOT, "%.2f", var5)), true);
        return (int)var5;
    }

    static class TraceCustomExecutor
    extends CustomCommandExecutor.WithErrorHandling<CommandSourceStack>
    implements CustomCommandExecutor.CommandAdapter<CommandSourceStack> {
        TraceCustomExecutor() {
        }

        @Override
        public void runGuarded(CommandSourceStack var0, ContextChain<CommandSourceStack> var1, ChainModifiers var2, ExecutionControl<CommandSourceStack> var3) throws CommandSyntaxException {
            if (var2.isReturn()) {
                throw NO_RETURN_RUN.create();
            }
            if (var3.tracer() != null) {
                throw NO_RECURSIVE_TRACES.create();
            }
            CommandContext var42 = var1.getTopContext();
            Collection<CommandFunction<CommandSourceStack>> var52 = FunctionArgument.getFunctions((CommandContext<CommandSourceStack>)var42, "name");
            MinecraftServer var6 = var0.getServer();
            String var7 = "debug-trace-" + Util.getFilenameFormattedDateTime() + ".txt";
            CommandDispatcher<CommandSourceStack> var8 = var0.getServer().getFunctions().getDispatcher();
            int var9 = 0;
            try {
                Path var10 = var6.getFile("debug");
                Files.createDirectories(var10, new FileAttribute[0]);
                final PrintWriter var11 = new PrintWriter(Files.newBufferedWriter(var10.resolve(var7), StandardCharsets.UTF_8, new OpenOption[0]));
                Tracer var12 = new Tracer(var11);
                var3.tracer(var12);
                for (final CommandFunction<CommandSourceStack> var14 : var52) {
                    try {
                        CommandSourceStack var15 = var0.withSource(var12).withMaximumPermission(2);
                        InstantiatedFunction<CommandSourceStack> var16 = var14.instantiate(null, var8);
                        var3.queueNext(new CallFunction<CommandSourceStack>(this, var16, CommandResultCallback.EMPTY, false){

                            @Override
                            public void execute(CommandSourceStack var0, ExecutionContext<CommandSourceStack> var1, Frame var2) {
                                var11.println(var14.id());
                                super.execute(var0, var1, var2);
                            }

                            @Override
                            public /* synthetic */ void execute(Object object, ExecutionContext executionContext, Frame frame) {
                                this.execute((CommandSourceStack)object, (ExecutionContext<CommandSourceStack>)executionContext, frame);
                            }
                        }.bind(var15));
                        var9 += var16.entries().size();
                    }
                    catch (FunctionInstantiationException var15) {
                        var0.sendFailure(var15.messageComponent());
                    }
                }
            }
            catch (IOException | UncheckedIOException var10) {
                LOGGER.warn("Tracing failed", (Throwable)var10);
                var0.sendFailure(Component.translatable("commands.debug.function.traceFailed"));
            }
            int var10 = var9;
            var3.queueNext((var4, var5) -> {
                if (var52.size() == 1) {
                    var0.sendSuccess(() -> Component.translatable("commands.debug.function.success.single", var10, Component.translationArg(((CommandFunction)var52.iterator().next()).id()), var7), true);
                } else {
                    var0.sendSuccess(() -> Component.translatable("commands.debug.function.success.multiple", var10, var52.size(), var7), true);
                }
            });
        }

        @Override
        public /* synthetic */ void runGuarded(ExecutionCommandSource executionCommandSource, ContextChain contextChain, ChainModifiers chainModifiers, ExecutionControl executionControl) throws CommandSyntaxException {
            this.runGuarded((CommandSourceStack)executionCommandSource, (ContextChain<CommandSourceStack>)contextChain, chainModifiers, (ExecutionControl<CommandSourceStack>)executionControl);
        }
    }

    static class Tracer
    implements CommandSource,
    TraceCallbacks {
        public static final int INDENT_OFFSET = 1;
        private final PrintWriter output;
        private int lastIndent;
        private boolean waitingForResult;

        Tracer(PrintWriter var0) {
            this.output = var0;
        }

        private void indentAndSave(int var0) {
            this.printIndent(var0);
            this.lastIndent = var0;
        }

        private void printIndent(int var0) {
            for (int var1 = 0; var1 < var0 + 1; ++var1) {
                this.output.write("    ");
            }
        }

        private void newLine() {
            if (this.waitingForResult) {
                this.output.println();
                this.waitingForResult = false;
            }
        }

        @Override
        public void onCommand(int var0, String var1) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[C] ");
            this.output.print(var1);
            this.waitingForResult = true;
        }

        @Override
        public void onReturn(int var0, String var1, int var2) {
            if (this.waitingForResult) {
                this.output.print(" -> ");
                this.output.println(var2);
                this.waitingForResult = false;
            } else {
                this.indentAndSave(var0);
                this.output.print("[R = ");
                this.output.print(var2);
                this.output.print("] ");
                this.output.println(var1);
            }
        }

        @Override
        public void onCall(int var0, ResourceLocation var1, int var2) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[F] ");
            this.output.print(var1);
            this.output.print(" size=");
            this.output.println(var2);
        }

        @Override
        public void onError(String var0) {
            this.newLine();
            this.indentAndSave(this.lastIndent + 1);
            this.output.print("[E] ");
            this.output.print(var0);
        }

        @Override
        public void sendSystemMessage(Component var0) {
            this.newLine();
            this.printIndent(this.lastIndent + 1);
            this.output.print("[M] ");
            this.output.println(var0.getString());
        }

        @Override
        public boolean acceptsSuccess() {
            return true;
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }

        @Override
        public boolean alwaysAccepts() {
            return true;
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((Writer)this.output);
        }
    }
}

