/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ForceLoadCommand {
    private static final int MAX_CHUNK_LIMIT = 256;
    private static final Dynamic2CommandExceptionType ERROR_TOO_MANY_CHUNKS = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.forceload.toobig", var0, var1));
    private static final Dynamic2CommandExceptionType ERROR_NOT_TICKING = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.forceload.query.failure", var0, var1));
    private static final SimpleCommandExceptionType ERROR_ALL_ADDED = new SimpleCommandExceptionType((Message)Component.translatable("commands.forceload.added.failure"));
    private static final SimpleCommandExceptionType ERROR_NONE_REMOVED = new SimpleCommandExceptionType((Message)Component.translatable("commands.forceload.removed.failure"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("forceload").requires(Commands.hasPermission(2))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("from", ColumnPosArgument.columnPos()).executes(var0 -> ForceLoadCommand.changeForceLoad((CommandSourceStack)var0.getSource(), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), true))).then(Commands.argument("to", ColumnPosArgument.columnPos()).executes(var0 -> ForceLoadCommand.changeForceLoad((CommandSourceStack)var0.getSource(), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "to"), true)))))).then(((LiteralArgumentBuilder)Commands.literal("remove").then(((RequiredArgumentBuilder)Commands.argument("from", ColumnPosArgument.columnPos()).executes(var0 -> ForceLoadCommand.changeForceLoad((CommandSourceStack)var0.getSource(), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), false))).then(Commands.argument("to", ColumnPosArgument.columnPos()).executes(var0 -> ForceLoadCommand.changeForceLoad((CommandSourceStack)var0.getSource(), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "from"), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "to"), false))))).then(Commands.literal("all").executes(var0 -> ForceLoadCommand.removeAll((CommandSourceStack)var0.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal("query").executes(var0 -> ForceLoadCommand.listForceLoad((CommandSourceStack)var0.getSource()))).then(Commands.argument("pos", ColumnPosArgument.columnPos()).executes(var0 -> ForceLoadCommand.queryForceLoad((CommandSourceStack)var0.getSource(), ColumnPosArgument.getColumnPos((CommandContext<CommandSourceStack>)var0, "pos")))))));
    }

    private static int queryForceLoad(CommandSourceStack var0, ColumnPos var1) throws CommandSyntaxException {
        ChunkPos var2 = var1.toChunkPos();
        ServerLevel var3 = var0.getLevel();
        ResourceKey<Level> var4 = var3.dimension();
        boolean var5 = var3.getForceLoadedChunks().contains(var2.toLong());
        if (var5) {
            var0.sendSuccess(() -> Component.translatable("commands.forceload.query.success", Component.translationArg(var2), Component.translationArg(var4.location())), false);
            return 1;
        }
        throw ERROR_NOT_TICKING.create((Object)var2, (Object)var4.location());
    }

    private static int listForceLoad(CommandSourceStack var0) {
        ServerLevel var1 = var0.getLevel();
        ResourceKey<Level> var2 = var1.dimension();
        LongSet var3 = var1.getForceLoadedChunks();
        int var4 = var3.size();
        if (var4 > 0) {
            String var5 = Joiner.on((String)", ").join(var3.stream().sorted().map(ChunkPos::new).map(ChunkPos::toString).iterator());
            if (var4 == 1) {
                var0.sendSuccess(() -> Component.translatable("commands.forceload.list.single", Component.translationArg(var2.location()), var5), false);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.forceload.list.multiple", var4, Component.translationArg(var2.location()), var5), false);
            }
        } else {
            var0.sendFailure(Component.translatable("commands.forceload.added.none", Component.translationArg(var2.location())));
        }
        return var4;
    }

    private static int removeAll(CommandSourceStack var0) {
        ServerLevel var12 = var0.getLevel();
        ResourceKey<Level> var2 = var12.dimension();
        LongSet var3 = var12.getForceLoadedChunks();
        var3.forEach(var1 -> var12.setChunkForced(ChunkPos.getX(var1), ChunkPos.getZ(var1), false));
        var0.sendSuccess(() -> Component.translatable("commands.forceload.removed.all", Component.translationArg(var2.location())), true);
        return 0;
    }

    private static int changeForceLoad(CommandSourceStack var0, ColumnPos var1, ColumnPos var2, boolean var3) throws CommandSyntaxException {
        int var19;
        int var11;
        int var4 = Math.min(var1.x(), var2.x());
        int var5 = Math.min(var1.z(), var2.z());
        int var6 = Math.max(var1.x(), var2.x());
        int var7 = Math.max(var1.z(), var2.z());
        if (var4 < -30000000 || var5 < -30000000 || var6 >= 30000000 || var7 >= 30000000) {
            throw BlockPosArgument.ERROR_OUT_OF_WORLD.create();
        }
        int var8 = SectionPos.blockToSectionCoord(var4);
        int var9 = SectionPos.blockToSectionCoord(var5);
        int var10 = SectionPos.blockToSectionCoord(var6);
        long var12 = ((long)(var10 - var8) + 1L) * ((long)((var11 = SectionPos.blockToSectionCoord(var7)) - var9) + 1L);
        if (var12 > 256L) {
            throw ERROR_TOO_MANY_CHUNKS.create((Object)256, (Object)var12);
        }
        ServerLevel var14 = var0.getLevel();
        ResourceKey<Level> var15 = var14.dimension();
        ChunkPos var16 = null;
        int var17 = 0;
        for (int var18 = var8; var18 <= var10; ++var18) {
            for (var19 = var9; var19 <= var11; ++var19) {
                boolean var20 = var14.setChunkForced(var18, var19, var3);
                if (!var20) continue;
                ++var17;
                if (var16 != null) continue;
                var16 = new ChunkPos(var18, var19);
            }
        }
        ChunkPos var18 = var16;
        var19 = var17;
        if (var19 == 0) {
            throw (var3 ? ERROR_ALL_ADDED : ERROR_NONE_REMOVED).create();
        }
        if (var19 == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.forceload." + (var3 ? "added" : "removed") + ".single", Component.translationArg(var18), Component.translationArg(var15.location())), true);
        } else {
            ChunkPos var20 = new ChunkPos(var8, var9);
            ChunkPos var21 = new ChunkPos(var10, var11);
            var0.sendSuccess(() -> Component.translatable("commands.forceload." + (var3 ? "added" : "removed") + ".multiple", var19, Component.translationArg(var15.location()), Component.translationArg(var20), Component.translationArg(var21)), true);
        }
        return var19;
    }
}

