/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PlaySoundCommand {
    private static final SimpleCommandExceptionType ERROR_TOO_FAR = new SimpleCommandExceptionType((Message)Component.translatable("commands.playsound.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        RequiredArgumentBuilder var1 = (RequiredArgumentBuilder)Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.cast(SuggestionProviders.AVAILABLE_SOUNDS)).executes(var0 -> PlaySoundCommand.playSound((CommandSourceStack)var0.getSource(), PlaySoundCommand.getCallingPlayerAsCollection(((CommandSourceStack)var0.getSource()).getPlayer()), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "sound"), SoundSource.MASTER, ((CommandSourceStack)var0.getSource()).getPosition(), 1.0f, 1.0f, 0.0f));
        for (SoundSource var5 : SoundSource.values()) {
            var1.then(PlaySoundCommand.source(var5));
        }
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("playsound").requires(Commands.hasPermission(2))).then((ArgumentBuilder)var1)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> source(SoundSource var0) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal(var0.getName()).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), PlaySoundCommand.getCallingPlayerAsCollection(((CommandSourceStack)var1.getSource()).getPlayer()), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, ((CommandSourceStack)var1.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var1, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, ((CommandSourceStack)var1.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var1, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var1, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("volume", FloatArgumentType.floatArg((float)0.0f)).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var1, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var1, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(Commands.argument("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(var1 -> PlaySoundCommand.playSound((CommandSourceStack)var1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var1, "targets"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sound"), var0, Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), ((Float)var1.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static Collection<ServerPlayer> getCallingPlayerAsCollection(@Nullable ServerPlayer var0) {
        return var0 != null ? List.of(var0) : List.of();
    }

    private static int playSound(CommandSourceStack var0, Collection<ServerPlayer> var1, ResourceLocation var2, SoundSource var3, Vec3 var4, float var5, float var6, float var7) throws CommandSyntaxException {
        Holder<SoundEvent> var8 = Holder.direct(SoundEvent.createVariableRangeEvent(var2));
        double var9 = Mth.square(var8.value().getRange(var5));
        ServerLevel var11 = var0.getLevel();
        long var12 = var11.getRandom().nextLong();
        ArrayList<ServerPlayer> var14 = new ArrayList<ServerPlayer>();
        for (ServerPlayer var16 : var1) {
            if (var16.level() != var11) continue;
            double var17 = var4.x - var16.getX();
            double var19 = var4.y - var16.getY();
            double var21 = var4.z - var16.getZ();
            double var23 = var17 * var17 + var19 * var19 + var21 * var21;
            Vec3 var25 = var4;
            float var26 = var5;
            if (var23 > var9) {
                if (var7 <= 0.0f) continue;
                double var27 = Math.sqrt(var23);
                var25 = new Vec3(var16.getX() + var17 / var27 * 2.0, var16.getY() + var19 / var27 * 2.0, var16.getZ() + var21 / var27 * 2.0);
                var26 = var7;
            }
            var16.connection.send(new ClientboundSoundPacket(var8, var3, var25.x(), var25.y(), var25.z(), var26, var6, var12));
            var14.add(var16);
        }
        int var15 = var14.size();
        if (var15 == 0) {
            throw ERROR_TOO_FAR.create();
        }
        if (var15 == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.playsound.success.single", Component.translationArg(var2), ((ServerPlayer)var14.getFirst()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.playsound.success.multiple", Component.translationArg(var2), var15), true);
        }
        return var15;
    }
}

