/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftOperatorListService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpListEntry;

public class MinecraftOperatorListServiceImpl
implements MinecraftOperatorListService {
    private final MinecraftServer minecraftServer;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftOperatorListServiceImpl(MinecraftServer var0, JsonRpcLogger var1) {
        this.minecraftServer = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public Collection<ServerOpListEntry> getEntries() {
        return this.minecraftServer.getPlayerList().getOps().getEntries();
    }

    @Override
    public void op(NameAndId var0, Optional<Integer> var1, Optional<Boolean> var2, ClientInfo var3) {
        this.jsonrpcLogger.log(var3, "Op '{}'", var0);
        this.minecraftServer.getPlayerList().op(var0, var1, var2);
    }

    @Override
    public void op(NameAndId var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Op '{}'", var0);
        this.minecraftServer.getPlayerList().op(var0);
    }

    @Override
    public void deop(NameAndId var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Deop '{}'", var0);
        this.minecraftServer.getPlayerList().deop(var0);
    }

    @Override
    public void clear(ClientInfo var0) {
        this.jsonrpcLogger.log(var0, "Clear operator list", new Object[0]);
        this.minecraftServer.getPlayerList().getOps().clear();
    }
}

