/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftPlayerListService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;

public class MinecraftPlayerListServiceImpl
implements MinecraftPlayerListService {
    private final JsonRpcLogger jsonRpcLogger;
    private final DedicatedServer server;

    public MinecraftPlayerListServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.jsonRpcLogger = var1;
        this.server = var0;
    }

    @Override
    public List<ServerPlayer> getPlayers() {
        return this.server.getPlayerList().getPlayers();
    }

    @Override
    @Nullable
    public ServerPlayer getPlayer(UUID var0) {
        return this.server.getPlayerList().getPlayer(var0);
    }

    @Override
    public Optional<NameAndId> fetchUserByName(String var0) {
        return this.server.services().nameToIdCache().get(var0);
    }

    @Override
    public Optional<NameAndId> fetchUserById(UUID var02) {
        return Optional.ofNullable(this.server.services().sessionService().fetchProfile(var02, true)).map(var0 -> new NameAndId(var0.profile()));
    }

    @Override
    public Optional<NameAndId> getCachedUserById(UUID var0) {
        return this.server.services().nameToIdCache().get(var0);
    }

    @Override
    public Optional<ServerPlayer> getPlayer(Optional<UUID> var0, Optional<String> var1) {
        if (var0.isPresent()) {
            return Optional.ofNullable(this.server.getPlayerList().getPlayer(var0.get()));
        }
        if (var1.isPresent()) {
            return Optional.ofNullable(this.server.getPlayerList().getPlayerByName(var1.get()));
        }
        return Optional.empty();
    }

    @Override
    public List<ServerPlayer> getPlayersWithAddress(String var0) {
        return this.server.getPlayerList().getPlayersWithAddress(var0);
    }

    @Override
    public void remove(ServerPlayer var0, ClientInfo var1) {
        this.server.getPlayerList().remove(var0);
        this.jsonRpcLogger.log(var1, "Remove player '{}'", var0.getPlainTextName());
    }

    @Override
    @Nullable
    public ServerPlayer getPlayerByName(String var0) {
        return this.server.getPlayerList().getPlayerByName(var0);
    }
}

