/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PlayerSpawnFinder {
    private static final EntityDimensions PLAYER_DIMENSIONS = EntityType.PLAYER.getDimensions();
    private static final int ABSOLUTE_MAX_ATTEMPTS = 1024;
    private final ServerLevel level;
    private final BlockPos spawnSuggestion;
    private final int radius;
    private final int candidateCount;
    private final int coprime;
    private final int offset;
    private int nextCandidateIndex;
    private final CompletableFuture<Vec3> finishedFuture = new CompletableFuture();

    private PlayerSpawnFinder(ServerLevel worldserver, BlockPos blockposition, int i) {
        this.level = worldserver;
        this.spawnSuggestion = blockposition;
        this.radius = i;
        long j = (long)i * 2L + 1L;
        this.candidateCount = (int)Math.min(1024L, j * j);
        this.coprime = PlayerSpawnFinder.getCoprime(this.candidateCount);
        this.offset = RandomSource.create().nextInt(this.candidateCount);
    }

    public static CompletableFuture<Vec3> findSpawn(ServerLevel worldserver, BlockPos blockposition) {
        if (worldserver.dimensionType().hasSkyLight() && worldserver.J.getGameType() != GameType.ADVENTURE) {
            int i = Math.max(0, worldserver.getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS));
            int j = Mth.floor(worldserver.getWorldBorder().getDistanceToBorder(blockposition.getX(), blockposition.getZ()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            PlayerSpawnFinder playerspawnfinder = new PlayerSpawnFinder(worldserver, blockposition, i);
            playerspawnfinder.scheduleNext();
            return playerspawnfinder.finishedFuture;
        }
        return CompletableFuture.completedFuture(PlayerSpawnFinder.fixupSpawnHeight(worldserver, blockposition));
    }

    private void scheduleNext() {
        int i;
        if ((i = this.nextCandidateIndex++) < this.candidateCount) {
            int j = (this.offset + this.coprime * i) % this.candidateCount;
            int k = j % (this.radius * 2 + 1);
            int l = j / (this.radius * 2 + 1);
            int i1 = this.spawnSuggestion.getX() + k - this.radius;
            int j1 = this.spawnSuggestion.getZ() + l - this.radius;
            this.scheduleCandidate(i1, j1, i, () -> {
                BlockPos blockposition = PlayerSpawnFinder.getOverworldRespawnPos(this.level, i1, j1);
                return blockposition != null && PlayerSpawnFinder.noCollisionNoLiquid(this.level, blockposition) ? Optional.of(Vec3.atBottomCenterOf(blockposition)) : Optional.empty();
            });
        } else {
            this.scheduleCandidate(this.spawnSuggestion.getX(), this.spawnSuggestion.getZ(), i, () -> Optional.of(PlayerSpawnFinder.fixupSpawnHeight(this.level, this.spawnSuggestion)));
        }
    }

    private static Vec3 fixupSpawnHeight(CollisionGetter icollisionaccess, BlockPos blockposition) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        while (!PlayerSpawnFinder.noCollisionNoLiquid(icollisionaccess, blockposition_mutableblockposition) && blockposition_mutableblockposition.getY() < icollisionaccess.getMaxY()) {
            blockposition_mutableblockposition.move(Direction.UP);
        }
        blockposition_mutableblockposition.move(Direction.DOWN);
        while (PlayerSpawnFinder.noCollisionNoLiquid(icollisionaccess, blockposition_mutableblockposition) && blockposition_mutableblockposition.getY() > icollisionaccess.getMinY()) {
            blockposition_mutableblockposition.move(Direction.DOWN);
        }
        blockposition_mutableblockposition.move(Direction.UP);
        return Vec3.atBottomCenterOf(blockposition_mutableblockposition);
    }

    private static boolean noCollisionNoLiquid(CollisionGetter icollisionaccess, BlockPos blockposition) {
        return icollisionaccess.noCollision(null, PLAYER_DIMENSIONS.makeBoundingBox(blockposition.getBottomCenter()), true);
    }

    private static int getCoprime(int i) {
        return i <= 16 ? i - 1 : 17;
    }

    private void scheduleCandidate(int i, int j, int k, Supplier<Optional<Vec3>> supplier) {
        if (!this.finishedFuture.isDone()) {
            int l = SectionPos.blockToSectionCoord(i);
            int i1 = SectionPos.blockToSectionCoord(j);
            this.level.getChunkSource().addTicketAndLoadWithRadius(TicketType.SPAWN_SEARCH, new ChunkPos(l, i1), 0).whenCompleteAsync((object, throwable) -> {
                if (throwable == null) {
                    try {
                        Optional optional = (Optional)supplier.get();
                        if (optional.isPresent()) {
                            this.finishedFuture.complete((Vec3)optional.get());
                        } else {
                            this.scheduleNext();
                        }
                    }
                    catch (Exception exception) {
                        throwable = exception;
                    }
                }
                if (throwable != null) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Searching for spawn");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Spawn Lookup");
                    BlockPos blockposition = this.spawnSuggestion;
                    Objects.requireNonNull(this.spawnSuggestion);
                    crashreportsystemdetails.setDetail("Origin", blockposition::toString);
                    crashreportsystemdetails.setDetail("Radius", () -> Integer.toString(this.radius));
                    crashreportsystemdetails.setDetail("Candidate", () -> "[" + i + "," + j + "]");
                    crashreportsystemdetails.setDetail("Progress", () -> k + " out of " + this.candidateCount);
                    this.finishedFuture.completeExceptionally(new ReportedException(crashreport));
                }
            }, (Executor)this.level.getServer());
        }
    }

    @Nullable
    protected static BlockPos getOverworldRespawnPos(ServerLevel worldserver, int i, int j) {
        int k;
        boolean flag = worldserver.dimensionType().hasCeiling();
        LevelChunk chunk = worldserver.getChunk(SectionPos.blockToSectionCoord(i), SectionPos.blockToSectionCoord(j));
        int n = k = flag ? worldserver.getChunkSource().getGenerator().getSpawnHeight(worldserver) : chunk.getHeight(Heightmap.Types.MOTION_BLOCKING, i & 0xF, j & 0xF);
        if (k < worldserver.getMinY()) {
            return null;
        }
        int l = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, i & 0xF, j & 0xF);
        if (l <= k && l > chunk.getHeight(Heightmap.Types.OCEAN_FLOOR, i & 0xF, j & 0xF)) {
            return null;
        }
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (int i1 = k + 1; i1 >= worldserver.getMinY(); --i1) {
            blockposition_mutableblockposition.set(i, i1, j);
            BlockState iblockdata = worldserver.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata.getFluidState().isEmpty()) break;
            if (!Block.isFaceFull(iblockdata.getCollisionShape(worldserver, blockposition_mutableblockposition), Direction.UP)) continue;
            return ((BlockPos)blockposition_mutableblockposition.above()).immutable();
        }
        return null;
    }

    @Nullable
    public static BlockPos getSpawnPosInChunk(ServerLevel worldserver, ChunkPos chunkcoordintpair) {
        if (SharedConstants.debugVoidTerrain(chunkcoordintpair)) {
            return null;
        }
        for (int i = chunkcoordintpair.getMinBlockX(); i <= chunkcoordintpair.getMaxBlockX(); ++i) {
            for (int j = chunkcoordintpair.getMinBlockZ(); j <= chunkcoordintpair.getMaxBlockZ(); ++j) {
                BlockPos blockposition = PlayerSpawnFinder.getOverworldRespawnPos(worldserver, i, j);
                if (blockposition == null) continue;
                return blockposition;
            }
        }
        return null;
    }
}

