/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.HashOps;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ServerItemCooldowns;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

public class ServerPlayer
extends Player {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public static final double BLOCK_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 1.0;
    public static final double ENTITY_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 3.0;
    public static final int ENDER_PEARL_TICKET_RADIUS = 2;
    public static final String ENDER_PEARLS_TAG = "ender_pearls";
    public static final String ENDER_PEARL_DIMENSION_TAG = "ender_pearl_dimension";
    public static final String TAG_DIMENSION = "Dimension";
    private static final AttributeModifier CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_block_range"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    private static final Component SPAWN_SET_MESSAGE = Component.translatable("block.minecraft.set_spawn");
    private static final AttributeModifier WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final boolean DEFAULT_SEEN_CREDITS = false;
    private static final boolean DEFAULT_SPAWN_EXTRA_PARTICLES_ON_FALL = false;
    public ServerGamePacketListenerImpl connection;
    public final MinecraftServer server;
    public final ServerPlayerGameMode gameMode;
    private final PlayerAdvancements advancements;
    private final ServerStatsCounter stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    public int lastSentExp = -99999999;
    private ChatVisiblity chatVisibility = ChatVisiblity.FULL;
    private ParticleStatus particleStatus = ParticleStatus.ALL;
    private boolean canChatColor = true;
    private long lastActionTime = Util.getMillis();
    @Nullable
    private Entity camera;
    public boolean isChangingDimension;
    public boolean seenCredits = false;
    private final ServerRecipeBook recipeBook;
    @Nullable
    private Vec3 levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    public String language = "en_us";
    @Nullable
    private Vec3 startingToFallPosition;
    @Nullable
    private Vec3 enteredNetherPosition;
    @Nullable
    private Vec3 enteredLavaOnVehiclePosition;
    private SectionPos lastSectionPos = SectionPos.of(0, 0, 0);
    private ChunkTrackingView chunkTrackingView = ChunkTrackingView.EMPTY;
    @Nullable
    private RespawnConfig respawnConfig;
    private final TextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private boolean spawnExtraParticlesOnFall = false;
    private WardenSpawnTracker wardenSpawnTracker = new WardenSpawnTracker();
    @Nullable
    private BlockPos raidOmenPosition;
    private Vec3 lastKnownClientMovement = Vec3.ZERO;
    private Input lastClientInput = Input.EMPTY;
    private final Set<ThrownEnderpearl> enderPearls = new HashSet<ThrownEnderpearl>();
    private long timeEntitySatOnShoulder;
    private CompoundTag shoulderEntityLeft = new CompoundTag();
    private CompoundTag shoulderEntityRight = new CompoundTag();
    private final ContainerSynchronizer containerSynchronizer = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> cache = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> registryHashOps;
            {
                this.registryHashOps = ServerPlayer.this.registryAccess().createSerializationContext(HashOps.CRC32C_INSTANCE);
            }

            public Integer load(TypedDataComponent<?> typeddatacomponent) {
                return ((HashCode)typeddatacomponent.encodeValue(this.registryHashOps).getOrThrow(s -> {
                    String s1 = String.valueOf(typeddatacomponent);
                    return new IllegalArgumentException("Failed to hash " + s1 + ": " + s);
                })).asInt();
            }
        });

        @Override
        public void sendInitialData(AbstractContainerMenu container, List<ItemStack> list, ItemStack itemstack, int[] aint) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetContentPacket(container.containerId, container.incrementStateId(), list, itemstack));
            for (int i = 0; i < aint.length; ++i) {
                this.broadcastDataValue(container, i, aint[i]);
            }
        }

        @Override
        public void sendSlotChange(AbstractContainerMenu container, int i, ItemStack itemstack) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(container.containerId, container.incrementStateId(), i, itemstack));
        }

        @Override
        public void sendCarriedChange(AbstractContainerMenu container, ItemStack itemstack) {
            ServerPlayer.this.connection.send(new ClientboundSetCursorItemPacket(itemstack));
        }

        @Override
        public void sendDataChange(AbstractContainerMenu container, int i, int j) {
            this.broadcastDataValue(container, i, j);
        }

        private void broadcastDataValue(AbstractContainerMenu container, int i, int j) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetDataPacket(container.containerId, i, j));
        }

        @Override
        public RemoteSlot createSlot() {
            LoadingCache<TypedDataComponent<?>, Integer> loadingcache = this.cache;
            Objects.requireNonNull(this.cache);
            return new RemoteSlot.Synchronized(arg_0 -> loadingcache.getUnchecked(arg_0));
        }
    };
    private final ContainerListener containerListener = new ContainerListener(){

        @Override
        public void slotChanged(AbstractContainerMenu container, int i, ItemStack itemstack) {
            Slot slot = container.getSlot(i);
            if (!(slot instanceof ResultSlot) && slot.container == ServerPlayer.this.getInventory()) {
                CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), itemstack);
            }
        }

        @Override
        public void dataChanged(AbstractContainerMenu container, int i, int j) {
        }
    };
    @Nullable
    private RemoteChatSession chatSession;
    @Nullable
    public final Object object;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public boolean acceptsSuccess() {
            return ServerPlayer.this.level().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return true;
        }

        @Override
        public void sendSystemMessage(Component ichatbasecomponent) {
            ServerPlayer.this.sendSystemMessage(ichatbasecomponent);
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return ServerPlayer.this.getBukkitEntity();
        }
    };
    private Set<DebugSubscription<?>> requestedDebugSubscriptions = Set.of();
    private int containerCounter;
    public boolean wonGame;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public ServerPlayer(MinecraftServer minecraftserver, ServerLevel worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, gameprofile);
        this.server = minecraftserver;
        this.textFilter = minecraftserver.createTextFilterForPlayer(this);
        this.gameMode = minecraftserver.createGameModeForPlayer(this);
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(null), null);
        this.recipeBook = new ServerRecipeBook((resourcekey, consumer) -> minecraftserver.getRecipeManager().listDisplaysForRecipe(resourcekey, consumer));
        this.stats = minecraftserver.getPlayerList().getPlayerStats(this);
        this.advancements = minecraftserver.getPlayerList().getPlayerAdvancements(this);
        this.updateOptions(clientinformation);
        this.object = null;
        this.displayName = this.getScoreboardName();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.getMaxHealth();
    }

    public void resendItemInHands() {
        this.containerMenu.findSlot(this.getInventory(), this.getInventory().getSelectedSlot()).ifPresent(s -> this.containerSynchronizer.sendSlotChange(this.containerMenu, s, this.getMainHandItem()));
        this.containerSynchronizer.sendSlotChange(this.inventoryMenu, 45, this.getOffhandItem());
    }

    @Override
    public BlockPos adjustSpawnLocation(ServerLevel worldserver, BlockPos blockposition) {
        CompletableFuture<Vec3> completablefuture = PlayerSpawnFinder.findSpawn(worldserver, blockposition);
        MinecraftServer minecraftserver = this.server;
        Objects.requireNonNull(completablefuture);
        minecraftserver.managedBlock(completablefuture::isDone);
        return BlockPos.containing(completablefuture.join());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.wardenSpawnTracker = valueinput.read("warden_spawn_tracker", WardenSpawnTracker.CODEC).orElseGet(WardenSpawnTracker::new);
        this.enteredNetherPosition = valueinput.read("entered_nether_pos", Vec3.CODEC).orElse(null);
        this.seenCredits = valueinput.getBooleanOr("seenCredits", false);
        valueinput.read("recipeBook", ServerRecipeBook.Packed.CODEC).ifPresent(recipebookserver_b -> this.recipeBook.loadUntrusted((ServerRecipeBook.Packed)recipebookserver_b, resourcekey -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)resourcekey).isPresent()));
        this.getBukkitEntity().readExtraData(valueinput);
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.respawnConfig = valueinput.read("respawn", RespawnConfig.CODEC).orElse(null);
        String spawnWorld = valueinput.getStringOr("SpawnWorld", "");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld((String)spawnWorld);
        if (oldWorld != null) {
            RespawnConfig respawnConfig = this.respawnConfig;
            LevelData.RespawnData respawnData = respawnConfig.respawnData();
            this.respawnConfig = new RespawnConfig(LevelData.RespawnData.of(oldWorld.getHandle().dimension(), respawnData.pos(), respawnData.yaw(), respawnData.pitch()), respawnConfig.forced());
        }
        this.spawnExtraParticlesOnFall = valueinput.getBooleanOr("spawn_extra_particles_on_fall", false);
        this.raidOmenPosition = valueinput.read("raid_omen_position", BlockPos.CODEC).orElse(null);
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(ServerPlayer.readPlayerMode(valueinput, "playerGameType")), ServerPlayer.readPlayerMode(valueinput, "previousPlayerGameType"));
        this.setShoulderEntityLeft(valueinput.read("ShoulderEntityLeft", CompoundTag.CODEC).orElseGet(CompoundTag::new));
        this.setShoulderEntityRight(valueinput.read("ShoulderEntityRight", CompoundTag.CODEC).orElseGet(CompoundTag::new));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.store("warden_spawn_tracker", WardenSpawnTracker.CODEC, this.wardenSpawnTracker);
        this.storeGameTypes(valueoutput);
        valueoutput.putBoolean("seenCredits", this.seenCredits);
        valueoutput.storeNullable("entered_nether_pos", Vec3.CODEC, this.enteredNetherPosition);
        this.saveParentVehicle(valueoutput);
        valueoutput.store("recipeBook", ServerRecipeBook.Packed.CODEC, this.recipeBook.pack());
        valueoutput.putString(TAG_DIMENSION, this.level().dimension().location().toString());
        valueoutput.storeNullable("respawn", RespawnConfig.CODEC, this.respawnConfig);
        this.getBukkitEntity().setExtraData(valueoutput);
        valueoutput.putBoolean("spawn_extra_particles_on_fall", this.spawnExtraParticlesOnFall);
        valueoutput.storeNullable("raid_omen_position", BlockPos.CODEC, this.raidOmenPosition);
        this.saveEnderPearls(valueoutput);
        if (!this.getShoulderEntityLeft().isEmpty()) {
            valueoutput.store("ShoulderEntityLeft", CompoundTag.CODEC, this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            valueoutput.store("ShoulderEntityRight", CompoundTag.CODEC, this.getShoulderEntityRight());
        }
    }

    private void saveParentVehicle(ValueOutput valueoutput) {
        Entity entity = this.getRootVehicle();
        Entity entity1 = this.getVehicle();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.getVehicle()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.hasExactlyOnePlayerPassenger()) {
            ValueOutput valueoutput1 = valueoutput.child("RootVehicle");
            valueoutput1.store("Attach", UUIDUtil.CODEC, entity1.getUUID());
            entity.save(valueoutput1.child("Entity"));
        }
    }

    public void loadAndSpawnParentVehicle(ValueInput valueinput) {
        Optional<ValueInput> optional = valueinput.child("RootVehicle");
        if (!optional.isEmpty()) {
            ServerLevel worldserver = this.level();
            Entity entity = EntityType.loadEntityRecursive(optional.get().childOrEmpty("Entity"), (Level)worldserver, EntitySpawnReason.LOAD, entity1 -> !worldserver.addWithUUID((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = optional.get().read("Attach", UUIDUtil.CODEC).orElse(null);
                if (entity.getUUID().equals(uuid)) {
                    this.startRiding(entity, true, false);
                } else {
                    for (Entity entity12 : entity.getIndirectPassengers()) {
                        if (!entity12.getUUID().equals(uuid)) continue;
                        this.startRiding(entity12, true, false);
                        break;
                    }
                }
                if (!this.isPassenger()) {
                    LOGGER.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity2 : entity.getIndirectPassengers()) {
                        entity2.discard(null);
                    }
                }
            }
        }
    }

    private void saveEnderPearls(ValueOutput valueoutput) {
        if (!this.enderPearls.isEmpty()) {
            ValueOutput.ValueOutputList valueoutput_b = valueoutput.childrenList(ENDER_PEARLS_TAG);
            for (ThrownEnderpearl entityenderpearl : this.enderPearls) {
                if (entityenderpearl.isRemoved()) {
                    LOGGER.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueoutput1 = valueoutput_b.addChild();
                entityenderpearl.save(valueoutput1);
                valueoutput1.store(ENDER_PEARL_DIMENSION_TAG, Level.RESOURCE_KEY_CODEC, entityenderpearl.level().dimension());
            }
        }
    }

    public void loadAndSpawnEnderPearls(ValueInput valueinput) {
        valueinput.childrenListOrEmpty(ENDER_PEARLS_TAG).forEach(this::loadAndSpawnEnderPearl);
    }

    private void loadAndSpawnEnderPearl(ValueInput valueinput) {
        Optional<ResourceKey<Level>> optional = valueinput.read(ENDER_PEARL_DIMENSION_TAG, Level.RESOURCE_KEY_CODEC);
        if (!optional.isEmpty()) {
            ServerLevel worldserver = this.level().getServer().getLevel(optional.get());
            if (worldserver != null) {
                Entity entity = EntityType.loadEntityRecursive(valueinput, (Level)worldserver, EntitySpawnReason.LOAD, entity1 -> !worldserver.addWithUUID((Entity)entity1) ? null : entity1);
                if (entity != null) {
                    ServerPlayer.placeEnderPearlTicket(worldserver, entity.chunkPosition());
                } else {
                    LOGGER.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                LOGGER.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(Level world, boolean flag) {
        this.setLevel(world);
        if (world == null) {
            this.unsetRemoved();
            TeleportTransition teleporttransition = this.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.DO_NOTHING, null);
            this.setLevel(teleporttransition.newLevel());
            this.setPos(teleporttransition.position());
        }
        this.gameMode.setLevel((ServerLevel)world);
    }

    public void setExperiencePoints(int i) {
        float f = this.getXpNeededForNextLevel();
        float f1 = (f - 1.0f) / f;
        this.experienceProgress = Mth.clamp((float)i / f, 0.0f, f1);
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int i) {
        this.experienceLevel = i;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int i) {
        super.giveExperienceLevels(i);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack itemstack, int i) {
        super.onEnchantmentPerformed(itemstack, i);
        this.lastSentExp = -1;
    }

    public void initMenu(AbstractContainerMenu container) {
        container.addSlotListener(this.containerListener);
        container.setSynchronizer(this.containerSynchronizer);
        container.startOpen();
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(ClientboundPlayerCombatEnterPacket.INSTANCE);
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    public void onInsideBlock(BlockState iblockdata) {
        CriteriaTriggers.ENTER_BLOCK.trigger(this, iblockdata);
    }

    @Override
    protected ItemCooldowns createItemCooldowns() {
        return new ServerItemCooldowns(this);
    }

    @Override
    public void tick() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.tickClientLoadTimeout();
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.containerMenu.broadcastChanges();
        if (!this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        if ((entity = this.getCamera()) != this) {
            if (entity.isAlive()) {
                this.absSnapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                this.level().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriteriaTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriteriaTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.updatePlayerAttributes();
        this.advancements.flushDirty(this, true);
    }

    private void updatePlayerAttributes() {
        AttributeInstance attributemodifiable2;
        AttributeInstance attributemodifiable1;
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attributemodifiable != null) {
            if (this.isCreative()) {
                attributemodifiable.addOrUpdateTransientModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            } else {
                attributemodifiable.removeModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((attributemodifiable1 = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)) != null) {
            if (this.isCreative()) {
                attributemodifiable1.addOrUpdateTransientModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            } else {
                attributemodifiable1.removeModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((attributemodifiable2 = this.getAttribute(Attributes.WAYPOINT_TRANSMIT_RANGE)) != null) {
            if (this.isCrouching()) {
                attributemodifiable2.addOrUpdateTransientModifier(WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER);
            } else {
                attributemodifiable2.removeModifier(WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER);
            }
        }
    }

    public void doTick() {
        try {
            if (!this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
                if (!this.containerMenu.stillValid(this)) {
                    this.closeContainer();
                    this.containerMenu = this.inventoryMenu;
                }
                this.foodData.tick(this);
                this.awardStat(Stats.PLAY_TIME);
                this.awardStat(Stats.TOTAL_WORLD_TIME);
                if (this.isAlive()) {
                    this.awardStat(Stats.TIME_SINCE_DEATH);
                }
                if (this.isDiscrete()) {
                    this.awardStat(Stats.CROUCH_TIME);
                }
                if (!this.isSleeping()) {
                    this.awardStat(Stats.TIME_SINCE_REST);
                }
            }
            for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
                ItemStack itemstack = this.getInventory().getItem(i);
                if (itemstack.isEmpty()) continue;
                this.synchronizeSpecialItemUpdates(itemstack);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new ClientboundSetHealthPacket(this.getBukkitEntity().getScaledHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(ObjectiveCriteria.HEALTH, Mth.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(ObjectiveCriteria.FOOD, Mth.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(ObjectiveCriteria.AIR, Mth.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(ObjectiveCriteria.ARMOR, Mth.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(ObjectiveCriteria.EXPERIENCE, Mth.ceil(this.lastRecordedExperience));
            }
            if (this.maxHealthCache != (double)this.getMaxHealth()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(ObjectiveCriteria.LEVEL, Mth.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new ClientboundSetExperiencePacket(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriteriaTriggers.LOCATION.trigger(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.experienceLevel;
            }
            if (this.oldLevel != this.experienceLevel) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.experienceLevel);
                this.oldLevel = this.experienceLevel;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().tick();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking player");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Player being ticked");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void synchronizeSpecialItemUpdates(ItemStack itemstack) {
        Packet<?> packet;
        MapId mapid = itemstack.get(DataComponents.MAP_ID);
        MapItemSavedData worldmap = MapItem.getSavedData(mapid, (Level)this.level());
        if (worldmap != null && (packet = worldmap.getUpdatePacket(mapid, this)) != null) {
            this.connection.send(packet);
        }
    }

    @Override
    protected void tickRegeneration() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.tickCount % 20 == 0) {
                float f;
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f = this.foodData.getSaturationLevel()) < 20.0f) {
                    this.foodData.setSaturation(f + 1.0f);
                }
            }
            if (this.tickCount % 10 == 0 && this.foodData.needsFood()) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
    }

    @Override
    public void handleShoulderEntities() {
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (this.fallDistance > 0.5 || this.isInWater() || this.getAbilities().flying || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    private void playShoulderEntityAmbientSound(CompoundTag nbttagcompound) {
        EntityType entitytypes;
        if (!(nbttagcompound.isEmpty() || nbttagcompound.getBooleanOr("Silent", false) || this.random.nextInt(200) != 0 || (entitytypes = (EntityType)nbttagcompound.read("id", EntityType.CODEC).orElse(null)) != EntityType.PARROT || Parrot.imitateNearbyMobs(this.level(), this))) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), Parrot.getAmbient(this.level(), this.random), this.getSoundSource(), 1.0f, Parrot.getPitch(this.random));
        }
    }

    public boolean setEntityOnShoulder(CompoundTag nbttagcompound) {
        if (!this.isPassenger() && this.onGround() && !this.isInWater() && !this.isInPowderSnow) {
            if (this.getShoulderEntityLeft().isEmpty()) {
                this.setShoulderEntityLeft(nbttagcompound);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            if (this.getShoulderEntityRight().isEmpty()) {
                this.setShoulderEntityRight(nbttagcompound);
                this.timeEntitySatOnShoulder = this.level().getGameTime();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            if (this.respawnEntityOnShoulder(this.getShoulderEntityLeft())) {
                this.setShoulderEntityLeft(new CompoundTag());
            }
            if (this.respawnEntityOnShoulder(this.getShoulderEntityRight())) {
                this.setShoulderEntityRight(new CompoundTag());
            }
        }
    }

    public Entity getEntityOnShoulder(CompoundTag nbttagcompound) {
        ServerLevel worldserver = this.level();
        if (worldserver instanceof ServerLevel) {
            ServerLevel worldserver1 = worldserver;
            if (!nbttagcompound.isEmpty()) {
                try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
                    Entity entity2 = EntityType.create(TagValueInput.create(problemreporter_j.forChild(() -> ".shoulder"), (HolderLookup.Provider)worldserver1.registryAccess(), nbttagcompound), worldserver1, EntitySpawnReason.LOAD).map(entity -> {
                        if (entity instanceof TamableAnimal) {
                            TamableAnimal entitytameableanimal = (TamableAnimal)entity;
                            entitytameableanimal.setOwner(this);
                        }
                        entity.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                        return entity;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    private boolean respawnEntityOnShoulder(CompoundTag nbttagcompound) {
        Entity entity = this.getEntityOnShoulder(nbttagcompound);
        if (entity != null) {
            return this.level().addWithUUID(entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }
        return true;
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriteriaTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0 && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
            if (this.currentImpulseImpactPos != null && this.currentImpulseImpactPos.y <= this.startingToFallPosition.y) {
                CriteriaTriggers.FALL_AFTER_EXPLOSION.trigger(this, this.currentImpulseImpactPos, this.currentExplosionCause);
            }
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriteriaTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(ObjectiveCriteria iscoreboardcriteria, int i) {
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.set(i));
    }

    @Override
    public void die(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        this.gameEvent(GameEvent.ENTITY_DIE);
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
        if (this.isRemoved()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.getInventory().getContainerSize());
        boolean bl = keepInventory = this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || this.isSpectator();
        if (!keepInventory) {
            for (ItemStack item : this.getInventory()) {
                if (item.isEmpty() || EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.dropFromLootTable(this.level(), damagesource, this.lastHurtByPlayerMemoryTime > 0);
        this.dropCustomDeathLoot(this.level(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        Component defaultMessage = this.getCombatTracker().getDeathMessage();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            Component ichatbasecomponent = deathMessage.equals(deathmessage) ? this.getCombatTracker().getDeathMessage() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), ichatbasecomponent), PacketSendListener.exceptionallySend(() -> {
                int i = 256;
                String s = ichatbasecomponent.getString(256);
                MutableComponent ichatbasecomponent1 = Component.translatable("death.attack.message_too_long", Component.literal(s).withStyle(ChatFormatting.YELLOW));
                MutableComponent ichatbasecomponent2 = Component.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent.ShowText(ichatbasecomponent1)));
                return new ClientboundPlayerCombatKillPacket(this.getId(), ichatbasecomponent2);
            }));
            PlayerTeam scoreboardteambase = this.getTeam();
            if (scoreboardteambase != null && ((Team)scoreboardteambase).getDeathMessageVisibility() != Team.Visibility.ALWAYS) {
                if (((Team)scoreboardteambase).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    this.server.getPlayerList().broadcastSystemToTeam(this, ichatbasecomponent);
                } else if (((Team)scoreboardteambase).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, ichatbasecomponent);
                }
            } else {
                this.server.getPlayerList().broadcastSystemMessage(ichatbasecomponent, false);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        this.dropExperience(this.level(), damagesource.getEntity());
        if (!event.getKeepInventory()) {
            this.getInventory().clearContent();
        }
        this.setCamera(this);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        LivingEntity entityliving = this.getKillCredit();
        if (entityliving != null) {
            this.awardStat(Stats.ENTITY_KILLED_BY.get(entityliving.getType()));
            entityliving.awardKillScore(this, damagesource);
            this.createWitherRose(entityliving);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
        this.setClientLoaded(false);
    }

    private void tellNeutralMobsThatIDied() {
        AABB axisalignedbb = new AABB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(Mob.class, axisalignedbb, EntitySelector.NO_SPECTATORS).stream().filter(entityinsentient -> entityinsentient instanceof NeutralMob).forEach(entityinsentient -> ((NeutralMob)((Object)entityinsentient)).playerDied(this.level(), this));
    }

    @Override
    public void awardKillScore(Entity entity, DamageSource damagesource) {
        if (entity != this) {
            super.awardKillScore(entity, damagesource);
            CraftScoreboardManager scoreboard = this.level().getCraftServer().getScoreboardManager();
            scoreboard.forAllObjectives(ObjectiveCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
            if (entity instanceof Player) {
                this.awardStat(Stats.PLAYER_KILLS);
                scoreboard.forAllObjectives(ObjectiveCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
            } else {
                this.awardStat(Stats.MOB_KILLS);
            }
            this.handleTeamKill(this, entity, ObjectiveCriteria.TEAM_KILL);
            this.handleTeamKill(entity, this, ObjectiveCriteria.KILLED_BY_TEAM);
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(this, entity, damagesource);
        }
    }

    private void handleTeamKill(ScoreHolder scoreholder, ScoreHolder scoreholder1, ObjectiveCriteria[] aiscoreboardcriteria) {
        int i;
        ServerScoreboard scoreboard = this.level().getScoreboard();
        PlayerTeam scoreboardteam = scoreboard.getPlayersTeam(scoreholder1.getScoreboardName());
        if (scoreboardteam != null && (i = scoreboardteam.getColor().getId()) >= 0 && i < aiscoreboardcriteria.length) {
            this.level().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i], scoreholder, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        Player entityhuman1;
        AbstractArrow entityarrow;
        Entity entity1;
        Player entityhuman;
        if (this.isInvulnerableTo(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.getEntity();
        if (entity instanceof Player && !this.canHarmPlayer(entityhuman = (Player)entity)) {
            return false;
        }
        if (entity instanceof AbstractArrow && (entity1 = (entityarrow = (AbstractArrow)entity).getOwner()) instanceof Player && !this.canHarmPlayer(entityhuman1 = (Player)entity1)) {
            return false;
        }
        return super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    public boolean canHarmPlayer(Player entityhuman) {
        return !this.isPvpAllowed() ? false : super.canHarmPlayer(entityhuman);
    }

    private boolean isPvpAllowed() {
        return this.level().getWorld().getPVP();
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.PostTeleportTransition teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig entityplayer_respawnconfig = this.getRespawnConfig();
        ServerLevel worldserver = this.server.getLevel(RespawnConfig.getDimensionOrDefault(entityplayer_respawnconfig));
        if (worldserver != null && entityplayer_respawnconfig != null) {
            Optional<RespawnPosAngle> optional = ServerPlayer.findRespawnAndUseSpawnBlock(worldserver, entityplayer_respawnconfig, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.position(), Vec3.ZERO, entityplayer_respawnposangle.yaw(), entityplayer_respawnposangle.pitch(), teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.missingRespawnBlock(this, teleporttransition_a);
            }
        } else {
            teleportTransition = TeleportTransition.createDefault(this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.position(), (World)teleportTransition.newLevel().getWorld(), teleportTransition.yRot(), teleportTransition.xRot());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((org.bukkit.entity.Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.level().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.deltaMovement(), location.getYaw(), location.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), teleportTransition.relatives(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
    }

    public boolean isReceivingWaypoints() {
        return this.getAttributeValue(Attributes.WAYPOINT_RECEIVE_RANGE) > 0.0;
    }

    @Override
    protected void onAttributeUpdated(Holder<Attribute> holder) {
        if (holder.is(Attributes.WAYPOINT_RECEIVE_RANGE)) {
            ServerWaypointManager serverwaypointmanager = this.level().getWaypointManager();
            if (this.getAttributes().getValue(holder) > 0.0) {
                serverwaypointmanager.addPlayer(this);
            } else {
                serverwaypointmanager.removePlayer(this);
            }
        }
        super.onAttributeUpdated(holder);
    }

    public static Optional<RespawnPosAngle> findRespawnAndUseSpawnBlock(ServerLevel worldserver, RespawnConfig entityplayer_respawnconfig, boolean flag) {
        LevelData.RespawnData worlddata_a = entityplayer_respawnconfig.respawnData;
        BlockPos blockposition = worlddata_a.pos();
        float f = worlddata_a.yaw();
        float f1 = worlddata_a.pitch();
        boolean flag1 = entityplayer_respawnconfig.forced;
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof RespawnAnchorBlock && (flag1 || iblockdata.getValue(RespawnAnchorBlock.CHARGE) > 0) && RespawnAnchorBlock.canSetSpawn(worldserver)) {
            Optional<Vec3> optional = RespawnAnchorBlock.findStandUpPosition(EntityType.PLAYER, worldserver, blockposition);
            if (!flag1 && flag && optional.isPresent()) {
                worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(RespawnAnchorBlock.CHARGE, iblockdata.getValue(RespawnAnchorBlock.CHARGE) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, false, true));
        }
        if (block instanceof BedBlock && BedBlock.canSetSpawn(worldserver)) {
            return BedBlock.findStandUpPosition(EntityType.PLAYER, worldserver, blockposition, (Direction)iblockdata.getValue(BedBlock.FACING), f).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, true, false));
        }
        if (!flag1) {
            return Optional.empty();
        }
        boolean flag2 = block.isPossibleToRespawnInThis(iblockdata);
        BlockState iblockdata1 = worldserver.getBlockState(blockposition.above());
        boolean flag3 = iblockdata1.getBlock().isPossibleToRespawnInThis(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.1, (double)blockposition.getZ() + 0.5), f, f1, false, false)) : Optional.empty();
    }

    public void showEndCredits() {
        this.unRide();
        this.level().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        if (!this.wonGame) {
            this.wonGame = true;
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
            this.seenCredits = true;
        }
    }

    @Override
    @Nullable
    public ServerPlayer teleport(TeleportTransition teleporttransition) {
        if (this.isSleeping()) {
            return null;
        }
        if (this.isRemoved()) {
            return null;
        }
        if (teleporttransition.missingRespawnBlock()) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        ServerLevel worldserver = teleporttransition.newLevel();
        ServerLevel worldserver1 = this.level();
        ResourceKey<LevelStem> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this), PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(absolutePosition.position(), (World)worldserver.getWorld(), absolutePosition.yRot(), absolutePosition.xRot());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, teleporttransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleporttransition = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3.ZERO, newExit.getYaw(), newExit.getPitch(), teleporttransition.missingRespawnBlock(), teleporttransition.asPassenger(), Set.of(), teleporttransition.postTeleportTransition(), teleporttransition.cause());
        }
        if (!teleporttransition.asPassenger()) {
            this.removeVehicle();
        }
        if (worldserver != null && worldserver.dimension() == worldserver1.dimension()) {
            this.connection.internalTeleport(PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
            this.connection.resetPosition();
            teleporttransition.postTeleportTransition().onTransition(this);
            return this;
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("moving");
        if (worldserver != null && resourcekey == LevelStem.OVERWORLD && worldserver.getTypeKey() == LevelStem.NETHER) {
            this.enteredNetherPosition = this.position();
        }
        gameprofilerfiller.pop();
        gameprofilerfiller.push("placing");
        this.isChangingDimension = true;
        LevelData worlddata = worldserver.getLevelData();
        this.connection.send(new ClientboundRespawnPacket(this.createCommonSpawnInfo(worldserver), 3));
        this.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        PlayerList playerlist = this.server.getPlayerList();
        playerlist.sendPlayerPermissionLevel(this);
        worldserver1.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        this.setServerLevel(worldserver);
        this.connection.internalTeleport(PositionMoveRotation.of(teleporttransition), teleporttransition.relatives());
        this.connection.resetPosition();
        worldserver.addDuringTeleport(this);
        gameprofilerfiller.pop();
        this.triggerDimensionChangeTriggers(worldserver1);
        this.stopUsingItem();
        this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
        playerlist.sendLevelInfo(this, worldserver);
        playerlist.sendAllPlayerInfo(this);
        playerlist.sendActivePlayerEffects(this);
        teleporttransition.postTeleportTransition().onTransition(this);
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.level().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        this.teleportSpectators(teleporttransition, worldserver1);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void forceSetRotation(float f, boolean flag, float f1, boolean flag1) {
        super.forceSetRotation(f, flag, f1, flag1);
        this.connection.send(new ClientboundPlayerRotationPacket(f, flag, f1, flag1));
    }

    public void triggerDimensionChangeTriggers(ServerLevel worldserver) {
        ResourceKey<Level> resourcekey = worldserver.dimension();
        ResourceKey<Level> resourcekey1 = this.level().dimension();
        ResourceKey<Level> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<Level> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.level());
        CriteriaTriggers.CHANGED_DIMENSION.trigger(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriteriaTriggers.CHANGED_DIMENSION.trigger(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == Level.NETHER && maindimensionkey1 == Level.OVERWORLD && this.enteredNetherPosition != null) {
            CriteriaTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if (maindimensionkey1 != Level.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(ServerPlayer entityplayer) {
        return entityplayer.isSpectator() ? this.getCamera() == this : (this.isSpectator() ? false : super.broadcastToPlayer(entityplayer));
    }

    @Override
    public void take(Entity entity, int i) {
        super.take(entity, i);
        this.containerMenu.broadcastChanges();
    }

    private Either<Player.BedSleepingProblem, Unit> getBedResult(BlockPos blockposition, Direction enumdirection) {
        if (!this.isSleeping() && this.isAlive()) {
            if (!this.level().dimensionType().natural() || !this.level().dimensionType().bedWorks()) {
                return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE));
            }
            if (!this.bedInRange(blockposition, enumdirection)) {
                return Either.left((Object)((Object)Player.BedSleepingProblem.TOO_FAR_AWAY));
            }
            if (this.bedBlocked(blockposition, enumdirection)) {
                return Either.left((Object)((Object)Player.BedSleepingProblem.OBSTRUCTED));
            }
            this.setRespawnPosition(new RespawnConfig(LevelData.RespawnData.of(this.level().dimension(), blockposition, this.getYRot(), this.getXRot()), false), true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.level().isBrightOutside()) {
                return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW));
            }
            if (!this.isCreative()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vec3d = Vec3.atBottomCenterOf(blockposition);
                List<Monster> list = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3d.x() - 8.0, vec3d.y() - 5.0, vec3d.z() - 8.0, vec3d.x() + 8.0, vec3d.y() + 5.0, vec3d.z() + 8.0), entitymonster -> entitymonster.isPreventingPlayerRest(this.level(), this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_SAFE));
                }
            }
            return Either.right((Object)((Object)Unit.INSTANCE));
        }
        return Either.left((Object)((Object)Player.BedSleepingProblem.OTHER_PROBLEM));
    }

    @Override
    public Either<Player.BedSleepingProblem, Unit> startSleepInBed(BlockPos blockposition, boolean force) {
        Direction enumdirection = this.level().getBlockState(blockposition).getValue(HorizontalDirectionalBlock.FACING);
        Either<Player.BedSleepingProblem, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == Player.BedSleepingProblem.OTHER_PROBLEM) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.INSTANCE));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.awardStat(Stats.SLEEP_IN_BED);
            CriteriaTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.level().canSleepThroughNights()) {
            this.displayClientMessage(Component.translatable("sleep.not_possible"), true);
        }
        this.level().updateSleepingPlayerList();
        return either;
    }

    @Override
    public void startSleeping(BlockPos blockposition) {
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        super.startSleeping(blockposition);
    }

    private boolean bedInRange(BlockPos blockposition, Direction enumdirection) {
        return this.isReachableBedBlock(blockposition) || this.isReachableBedBlock(blockposition.relative(enumdirection.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPos blockposition) {
        Vec3 vec3d = Vec3.atBottomCenterOf(blockposition);
        return Math.abs(this.getX() - vec3d.x()) <= 3.0 && Math.abs(this.getY() - vec3d.y()) <= 2.0 && Math.abs(this.getZ() - vec3d.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPos blockposition, Direction enumdirection) {
        BlockPos blockposition1 = blockposition.above();
        return !this.freeAt(blockposition1) || !this.freeAt(blockposition1.relative(enumdirection.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean flag, boolean flag1) {
        if (!this.isSleeping()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPos bedPosition = this.getSleepingPos().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.level().getWorld().getBlockAt(bedPosition.getX(), bedPosition.getY(), bedPosition.getZ()) : this.level().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((org.bukkit.entity.Player)player, bed, true);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.isSleeping()) {
            this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new ClientboundAnimatePacket(this, 2));
        }
        super.stopSleepInBed(flag, flag1);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel worldserver, DamageSource damagesource) {
        return super.isInvulnerableTo(worldserver, damagesource) || this.isChangingDimension() && !damagesource.is(DamageTypes.ENDER_PEARL) || !this.hasClientLoaded();
    }

    @Override
    protected void onChangedBlock(ServerLevel worldserver, BlockPos blockposition) {
        if (!this.isSpectator()) {
            super.onChangedBlock(worldserver, blockposition);
        }
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        if (this.spawnExtraParticlesOnFall && flag && this.fallDistance > 0.0) {
            Vec3 vec3d = blockposition.getCenter().add(0.0, 0.5, 0.0);
            int i = (int)Mth.clamp(50.0 * this.fallDistance, 0.0, 200.0);
            this.level().sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), vec3d.x, vec3d.y, vec3d.z, i, 0.3f, 0.3f, 0.3f, 0.15f);
            this.spawnExtraParticlesOnFall = false;
        }
        super.checkFallDamage(d0, flag, iblockdata, blockposition);
    }

    @Override
    public void onExplosionHit(@Nullable Entity entity) {
        super.onExplosionHit(entity);
        this.currentImpulseImpactPos = this.position();
        this.currentExplosionCause = entity;
        this.setIgnoreFallDamageFromCurrentImpulse(entity != null && entity.getType() == EntityType.WIND_CHARGE);
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(SignBlockEntity tileentitysign, boolean flag) {
        this.connection.send(new ClientboundBlockUpdatePacket(this.level(), tileentitysign.getBlockPos()));
        this.connection.send(new ClientboundOpenSignEditorPacket(tileentitysign.getBlockPos(), flag));
    }

    @Override
    public void openDialog(Holder<Dialog> holder) {
        this.connection.send(new ClientboundShowDialogPacket(holder));
    }

    public int nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
        return this.containerCounter;
    }

    @Override
    public OptionalInt openMenu(@Nullable MenuProvider itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        AbstractContainerMenu container = itileinventory.createMenu(this.containerCounter, this.getInventory(), this);
        if (container != null) {
            container.setTitle(itileinventory.getDisplayName());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof Container) {
                    ((Container)((Object)itileinventory)).stopOpen(this);
                } else if (itileinventory instanceof ChestBlock.DoubleInventory) {
                    ((ChestBlock.DoubleInventory)itileinventory).inventorylargechest.stopOpen(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(Component.translatable("container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.containerMenu = container;
        this.connection.send(new ClientboundOpenScreenPacket(container.containerId, container.getType(), container.getTitle()));
        this.initMenu(container);
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int i, MerchantOffers merchantrecipelist, int j, int k, boolean flag, boolean flag1) {
        this.connection.send(new ClientboundMerchantOffersPacket(i, merchantrecipelist, j, k, flag, flag1));
    }

    @Override
    public void openHorseInventory(AbstractHorse entityhorseabstract, Container iinventory) {
        this.nextContainerCounter();
        AbstractContainerMenu container = new HorseInventoryMenu(this.containerCounter, this.getInventory(), iinventory, entityhorseabstract, entityhorseabstract.getInventoryColumns());
        container.setTitle(entityhorseabstract.getDisplayName());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.stopOpen(this);
            return;
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        int i = entityhorseabstract.getInventoryColumns();
        this.connection.send(new ClientboundHorseScreenOpenPacket(this.containerCounter, i, entityhorseabstract.getId()));
        this.containerMenu = container;
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack itemstack, InteractionHand enumhand) {
        if (itemstack.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            if (WrittenBookContent.resolveForItem(itemstack, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new ClientboundOpenBookPacket(enumhand));
        }
    }

    @Override
    public void openCommandBlock(CommandBlockEntity tileentitycommand) {
        this.connection.send(ClientboundBlockEntityDataPacket.create(tileentitycommand, BlockEntity::saveCustomOnly));
    }

    @Override
    public void closeContainer() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void rideTick() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - d0, this.getY() - d1, this.getZ() - d2);
    }

    public void checkMovementStatistics(double d0, double d1, double d2) {
        if (!this.isPassenger() && !ServerPlayer.didNotMove(d0, d1, d2)) {
            if (this.isSwimming()) {
                int i = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i > 0) {
                    this.awardStat(Stats.SWIM_ONE_CM, i);
                    this.causeFoodExhaustion(0.01f * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (this.isEyeInFluid(FluidTags.WATER)) {
                int j = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (j > 0) {
                    this.awardStat(Stats.WALK_UNDER_WATER_ONE_CM, j);
                    this.causeFoodExhaustion(0.01f * (float)j * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.isInWater()) {
                int k = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (k > 0) {
                    this.awardStat(Stats.WALK_ON_WATER_ONE_CM, k);
                    this.causeFoodExhaustion(0.01f * (float)k * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.onClimbable()) {
                if (d1 > 0.0) {
                    this.awardStat(Stats.CLIMB_ONE_CM, (int)Math.round(d1 * 100.0));
                }
            } else if (this.onGround()) {
                int l = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (l > 0) {
                    if (this.isSprinting()) {
                        this.awardStat(Stats.SPRINT_ONE_CM, l);
                        this.causeFoodExhaustion(0.1f * (float)l * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.isCrouching()) {
                        this.awardStat(Stats.CROUCH_ONE_CM, l);
                        this.causeFoodExhaustion(0.0f * (float)l * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.awardStat(Stats.WALK_ONE_CM, l);
                        this.causeFoodExhaustion(0.0f * (float)l * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.isFallFlying()) {
                int i1 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.awardStat(Stats.AVIATE_ONE_CM, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (j1 > 25) {
                    this.awardStat(Stats.FLY_ONE_CM, j1);
                }
            }
        }
    }

    private void checkRidingStatistics(double d0, double d1, double d2) {
        if (this.isPassenger() && !ServerPlayer.didNotMove(d0, d1, d2)) {
            int i = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.getVehicle();
            if (entity instanceof AbstractMinecart) {
                this.awardStat(Stats.MINECART_ONE_CM, i);
            } else if (entity instanceof AbstractBoat) {
                this.awardStat(Stats.BOAT_ONE_CM, i);
            } else if (entity instanceof Pig) {
                this.awardStat(Stats.PIG_ONE_CM, i);
            } else if (entity instanceof AbstractHorse) {
                this.awardStat(Stats.HORSE_ONE_CM, i);
            } else if (entity instanceof Strider) {
                this.awardStat(Stats.STRIDER_ONE_CM, i);
            } else if (entity instanceof HappyGhast) {
                this.awardStat(Stats.HAPPY_GHAST_ONE_CM, i);
            }
        }
    }

    private static boolean didNotMove(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void awardStat(Stat<?> statistic, int i) {
        this.stats.increment(this, statistic, i);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.add(i));
    }

    @Override
    public void resetStat(Stat<?> statistic) {
        this.stats.setValue(this, statistic, 0);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> collection) {
        return this.recipeBook.addRecipes(collection, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriteriaTriggers.RECIPE_CRAFTED.trigger(this, recipeholder.id(), list);
    }

    @Override
    public void awardRecipesByKey(List<ResourceKey<Recipe<?>>> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(resourcekey -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.awardRecipes(list1);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> collection) {
        return this.recipeBook.removeRecipes(collection, this);
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(Stats.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(0.2f, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(0.05f, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void giveExperiencePoints(int i) {
        super.giveExperiencePoints(i);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
        this.lastSentExp = -1;
    }

    @Override
    public void displayClientMessage(Component ichatbasecomponent, boolean flag) {
        this.sendSystemMessage(ichatbasecomponent, flag);
    }

    @Override
    protected void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new ClientboundEntityEventPacket(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor argumentanchor_anchor, Vec3 vec3d) {
        super.lookAt(argumentanchor_anchor, vec3d);
        this.connection.send(new ClientboundPlayerLookAtPacket(argumentanchor_anchor, vec3d.x, vec3d.y, vec3d.z));
    }

    public void lookAt(EntityAnchorArgument.Anchor argumentanchor_anchor, Entity entity, EntityAnchorArgument.Anchor argumentanchor_anchor1) {
        Vec3 vec3d = argumentanchor_anchor1.apply(entity);
        super.lookAt(argumentanchor_anchor, vec3d);
        this.connection.send(new ClientboundPlayerLookAtPacket(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void restoreFrom(ServerPlayer entityplayer, boolean flag) {
        this.wardenSpawnTracker = entityplayer.wardenSpawnTracker;
        this.chatSession = entityplayer.chatSession;
        this.gameMode.setGameModeForPlayer(entityplayer.gameMode.getGameModeForPlayer(), entityplayer.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        if (flag) {
            this.getAttributes().assignBaseValues(entityplayer.getAttributes());
            this.setHealth(entityplayer.getHealth());
            this.foodData = entityplayer.foodData;
            for (MobEffectInstance mobEffectInstance : entityplayer.getActiveEffects()) {
            }
            this.getInventory().replaceWith(entityplayer.getInventory());
            this.experienceLevel = entityplayer.experienceLevel;
            this.totalExperience = entityplayer.totalExperience;
            this.experienceProgress = entityplayer.experienceProgress;
            this.setScore(entityplayer.getScore());
            this.portalProcess = entityplayer.portalProcess;
        } else {
            this.getAttributes().assignBaseValues(entityplayer.getAttributes());
            if (this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || entityplayer.isSpectator()) {
                this.getInventory().replaceWith(entityplayer.getInventory());
                this.experienceLevel = entityplayer.experienceLevel;
                this.totalExperience = entityplayer.totalExperience;
                this.experienceProgress = entityplayer.experienceProgress;
                this.setScore(entityplayer.getScore());
            }
        }
        this.enchantmentSeed = entityplayer.enchantmentSeed;
        this.enderChestInventory = entityplayer.enderChestInventory;
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Byte)entityplayer.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.seenCredits = entityplayer.seenCredits;
        this.enteredNetherPosition = entityplayer.enteredNetherPosition;
        this.chunkTrackingView = entityplayer.chunkTrackingView;
        this.requestedDebugSubscriptions = entityplayer.requestedDebugSubscriptions;
        this.setShoulderEntityLeft(entityplayer.getShoulderEntityLeft());
        this.setShoulderEntityRight(entityplayer.getShoulderEntityRight());
        this.setLastDeathLocation(entityplayer.getLastDeathLocation());
    }

    @Override
    protected void onEffectAdded(MobEffectInstance mobeffect, @Nullable Entity entity) {
        super.onEffectAdded(mobeffect, entity);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), mobeffect, true));
        if (mobeffect.is(MobEffects.LEVITATION)) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, entity);
    }

    @Override
    protected void onEffectUpdated(MobEffectInstance mobeffect, boolean flag, @Nullable Entity entity) {
        super.onEffectUpdated(mobeffect, flag, entity);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), mobeffect, false));
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, entity);
    }

    @Override
    protected void onEffectsRemoved(Collection<MobEffectInstance> collection) {
        super.onEffectsRemoved(collection);
        for (MobEffectInstance mobeffect : collection) {
            this.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), mobeffect.getEffect()));
            if (!mobeffect.is(MobEffects.LEVITATION)) continue;
            this.levitationStartPos = null;
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, (Entity)null);
    }

    @Override
    public void teleportTo(double d0, double d1, double d2) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(d0, d1, d2), Vec3.ZERO, 0.0f, 0.0f), Relative.union(Relative.DELTA, Relative.ROTATION));
    }

    @Override
    public void teleportRelative(double d0, double d1, double d2) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(d0, d1, d2), Vec3.ZERO, 0.0f, 0.0f), Relative.ALL);
    }

    @Override
    public boolean teleportTo(ServerLevel worldserver, double d0, double d1, double d2, Set<Relative> set, float f, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (flag) {
            this.setCamera(this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f, f1, flag, cause)) {
            this.setYHeadRot(set.contains((Object)Relative.Y_ROT) ? this.getYHeadRot() + f : f);
        }
        return flag1;
    }

    @Override
    public void snapTo(double d0, double d1, double d2) {
        super.snapTo(d0, d1, d2);
        this.connection.resetPosition();
    }

    @Override
    public void crit(Entity entity) {
        this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new ClientboundAnimatePacket(entity, 4));
    }

    @Override
    public void magicCrit(Entity entity) {
        this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new ClientboundAnimatePacket(entity, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection != null) {
            this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
            this.updateInvisibilityStatus();
        }
    }

    @Override
    public ServerLevel level() {
        return (ServerLevel)super.level();
    }

    public boolean setGameMode(GameType enumgamemode) {
        boolean flag = this.isSpectator();
        if (!this.gameMode.changeGameModeForPlayer(enumgamemode)) {
            return false;
        }
        this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.CHANGE_GAME_MODE, enumgamemode.getId()));
        if (enumgamemode == GameType.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
            EnchantmentHelper.stopLocationBasedEffects(this);
        } else {
            this.setCamera(this);
            if (flag) {
                EnchantmentHelper.runLocationChangedEffects(this.level(), this);
            }
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return true;
    }

    @Override
    @Nonnull
    public GameType gameMode() {
        return this.gameMode.getGameModeForPlayer();
    }

    public CommandSource commandSource() {
        return this.commandSource;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this.commandSource(), this.position(), this.getRotationVector(), this.level(), this.getPermissionLevel(), this.getPlainTextName(), this.getDisplayName(), this.server, this);
    }

    public void sendSystemMessage(Component ichatbasecomponent) {
        this.sendSystemMessage(ichatbasecomponent, false);
    }

    public void sendSystemMessage(Component ichatbasecomponent, boolean flag) {
        if (this.acceptsSystemMessages(flag)) {
            this.connection.send(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.exceptionallySend(() -> {
                if (this.acceptsSystemMessages(false)) {
                    int i = 256;
                    String s = ichatbasecomponent.getString(256);
                    MutableComponent ichatbasecomponent1 = Component.literal(s).withStyle(ChatFormatting.YELLOW);
                    return new ClientboundSystemChatPacket(Component.translatable("multiplayer.message_not_delivered", ichatbasecomponent1).withStyle(ChatFormatting.RED), false);
                }
                return null;
            }));
        }
    }

    public void sendChatMessage(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatType.Bound chatmessagetype_a) {
        if (this.acceptsChatMessages()) {
            outgoingchatmessage.sendToPlayer(this, flag, chatmessagetype_a);
        }
    }

    public String getIpAddress() {
        SocketAddress socketaddress = this.connection.getRemoteAddress();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void updateOptions(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.getMainArm() != clientinformation.mainHand()) {
            event = new PlayerChangedMainHandEvent((org.bukkit.entity.Player)this.getBukkitEntity(), this.getMainArm() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.language.equals(clientinformation.language())) {
            event = new PlayerLocaleChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), clientinformation.language());
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        this.language = clientinformation.language();
        this.requestedViewDistance = clientinformation.viewDistance();
        this.chatVisibility = clientinformation.chatVisibility();
        this.canChatColor = clientinformation.chatColors();
        this.textFilteringEnabled = clientinformation.textFilteringEnabled();
        this.allowsListing = clientinformation.allowsListing();
        this.particleStatus = clientinformation.particleStatus();
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (byte)clientinformation.modelCustomisation());
        this.getEntityData().set(DATA_PLAYER_MAIN_HAND, (byte)clientinformation.mainHand().getId());
    }

    public ClientInformation clientInformation() {
        byte i = (Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        HumanoidArm enummainhand = HumanoidArm.BY_ID.apply(((Byte)this.getEntityData().get(DATA_PLAYER_MAIN_HAND)).byteValue());
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, i, enummainhand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public ChatVisiblity getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean flag) {
        return this.chatVisibility == ChatVisiblity.HIDDEN ? flag : true;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == ChatVisiblity.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerStatus serverping) {
        this.connection.send(new ClientboundServerDataPacket(serverping.description(), serverping.favicon().map(ServerStatus.Favicon::iconBytes)));
    }

    @Override
    public int getPermissionLevel() {
        return this.server.getProfilePermissions(this.nameAndId());
    }

    public void resetLastActionTime() {
        this.lastActionTime = Util.getMillis();
    }

    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public ServerRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable Entity entity) {
        Entity entity1 = this.getCamera();
        Entity entity2 = this.camera = entity == null ? this : entity;
        if (entity1 != this.camera) {
            ServerLevel worldserver;
            boolean result;
            Level world = this.camera.level();
            if (world instanceof ServerLevel && !(result = this.teleportTo(worldserver = (ServerLevel)world, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot(), false, PlayerTeleportEvent.TeleportCause.SPECTATE))) {
                this.camera = entity1;
                return;
            }
            if (entity != null) {
                this.level().getChunkSource().move(this);
            }
            this.connection.send(new ClientboundSetCameraPacket(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(Entity entity) {
        if (this.isSpectator()) {
            this.setCamera(entity);
        } else {
            super.attack(entity);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Nullable
    public Component getTabListDisplayName() {
        return this.listName;
    }

    public int getTabListOrder() {
        return this.listOrder;
    }

    @Override
    public void swing(InteractionHand enumhand) {
        super.swing(enumhand);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public PlayerAdvancements getAdvancements() {
        return this.advancements;
    }

    @Nullable
    public RespawnConfig getRespawnConfig() {
        return this.respawnConfig;
    }

    public void copyRespawnPosition(ServerPlayer entityplayer) {
        this.setRespawnPosition(entityplayer.respawnConfig, false);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag) {
        this.setRespawnPosition(entityplayer_respawnconfig, flag, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag, PlayerSpawnChangeEvent.Cause cause) {
        Location newSpawn = null;
        boolean forced = false;
        if (entityplayer_respawnconfig != null) {
            LevelData.RespawnData respawnData = entityplayer_respawnconfig.respawnData();
            ServerLevel newWorld = this.server.getLevel(respawnData.dimension());
            newSpawn = CraftLocation.toBukkit(respawnData.pos(), (World)newWorld.getWorld(), respawnData.yaw(), respawnData.pitch());
            forced = entityplayer_respawnconfig.forced();
        }
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), newSpawn, forced, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        entityplayer_respawnconfig = newSpawn != null ? new RespawnConfig(LevelData.RespawnData.of(((CraftWorld)newSpawn.getWorld()).getHandle().dimension(), BlockPos.containing(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ()), newSpawn.getYaw(), newSpawn.getPitch()), event.isForced()) : null;
        if (flag && entityplayer_respawnconfig != null && !entityplayer_respawnconfig.isSamePosition(this.respawnConfig)) {
            this.sendSystemMessage(SPAWN_SET_MESSAGE);
        }
        this.respawnConfig = entityplayer_respawnconfig;
    }

    public SectionPos getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPos sectionposition) {
        this.lastSectionPos = sectionposition;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView chunktrackingview) {
        this.chunkTrackingView = chunktrackingview;
    }

    @Override
    public void playNotifySound(SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
        this.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundeffect), soundcategory, this.getX(), this.getY(), this.getZ(), f, f1, this.random.nextLong()));
    }

    @Override
    public ItemEntity drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        ItemEntity entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (flag1) {
            ItemStack itemstack1;
            ItemStack itemStack = itemstack1 = entityitem != null ? entityitem.getItem() : ItemStack.EMPTY;
            if (!itemstack1.isEmpty()) {
                this.awardStat(Stats.ITEM_DROPPED.get(itemstack1.getItem()), itemstack.getCount());
                this.awardStat(Stats.DROP);
            }
        }
        return entityitem;
    }

    public TextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(ServerLevel worldserver) {
        this.setLevel(worldserver);
        this.gameMode.setLevel(worldserver);
    }

    @Nullable
    private static GameType readPlayerMode(ValueInput valueinput, String s) {
        return valueinput.read(s, GameType.LEGACY_ID_CODEC).orElse(null);
    }

    private GameType calculateGameModeForNewPlayer(@Nullable GameType enumgamemode) {
        GameType enumgamemode1 = this.server.getForcedGameType();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.server.getDefaultGameType());
    }

    private void storeGameTypes(ValueOutput valueoutput) {
        valueoutput.store("playerGameType", GameType.LEGACY_ID_CODEC, this.gameMode.getGameModeForPlayer());
        GameType enumgamemode = this.gameMode.getPreviousGameModeForPlayer();
        valueoutput.storeNullable("previousPlayerGameType", GameType.LEGACY_ID_CODEC, enumgamemode);
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(ServerPlayer entityplayer) {
        return entityplayer == this ? false : this.textFilteringEnabled || entityplayer.textFilteringEnabled;
    }

    @Override
    public boolean mayInteract(ServerLevel worldserver, BlockPos blockposition) {
        return super.mayInteract(worldserver, blockposition) && worldserver.mayInteract(this, blockposition);
    }

    @Override
    protected void updateUsingItem(ItemStack itemstack) {
        CriteriaTriggers.USING_ITEM.trigger(this, itemstack);
        super.updateUsingItem(itemstack);
    }

    public boolean drop(boolean flag) {
        Inventory playerinventory = this.getInventory();
        ItemStack itemstack = playerinventory.removeFromSelected(flag);
        this.containerMenu.findSlot(playerinventory, playerinventory.getSelectedSlot()).ifPresent(i -> this.containerMenu.setRemoteSlot(i, playerinventory.getSelectedItem()));
        return this.drop(itemstack, false, true) != null;
    }

    @Override
    public void handleExtraItemsCreatedOnUse(ItemStack itemstack) {
        if (!this.getInventory().add(itemstack)) {
            this.drop(itemstack, false);
        }
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    public void setSpawnExtraParticlesOnFall(boolean flag) {
        this.spawnExtraParticlesOnFall = flag;
    }

    @Override
    public void onItemPickup(ItemEntity entityitem) {
        super.onItemPickup(entityitem);
        Entity entity = entityitem.getOwner();
        if (entity != null) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, entityitem.getItem(), entity);
        }
    }

    public void setChatSession(RemoteChatSession remotechatsession) {
        this.chatSession = remotechatsession;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        return this.chatSession != null && this.chatSession.hasExpired() ? null : this.chatSession;
    }

    @Override
    public void indicateDamage(double d0, double d1) {
        this.hurtDir = (float)(Mth.atan2(d1, d0) * 57.2957763671875 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(Entity entity, boolean flag, boolean flag1) {
        if (super.startRiding(entity, flag, flag1)) {
            entity.positionRider(this);
            this.connection.teleport(new PositionMoveRotation(this.position(), Vec3.ZERO, 0.0f, 0.0f), Relative.ROTATION);
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                this.server.getPlayerList().sendActiveEffects(entityliving, this.connection);
            }
            this.connection.send(new ClientboundSetPassengersPacket(entity));
            return true;
        }
        return false;
    }

    @Override
    public void removeVehicle() {
        Entity entity = this.getVehicle();
        super.removeVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            for (MobEffectInstance mobeffect : entityliving.getActiveEffects()) {
                this.connection.send(new ClientboundRemoveMobEffectPacket(entity.getId(), mobeffect.getEffect()));
            }
        }
        if (entity != null) {
            this.connection.send(new ClientboundSetPassengersPacket(entity));
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(ServerLevel worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.dimensionTypeRegistration(), worldserver.dimension(), BiomeManager.obfuscateSeed(worldserver.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), worldserver.isDebug(), worldserver.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown(), worldserver.getSeaLevel());
    }

    public void setRaidOmenPosition(BlockPos blockposition) {
        this.raidOmenPosition = blockposition;
    }

    public void clearRaidOmenPosition() {
        this.raidOmenPosition = null;
    }

    @Nullable
    public BlockPos getRaidOmenPosition() {
        return this.raidOmenPosition;
    }

    @Override
    public Vec3 getKnownMovement() {
        Entity entity = this.getVehicle();
        return entity != null && entity.getControllingPassenger() != this ? entity.getKnownMovement() : this.lastKnownClientMovement;
    }

    public void setKnownMovement(Vec3 vec3d) {
        this.lastKnownClientMovement = vec3d;
    }

    @Override
    protected float getEnchantedDamage(Entity entity, float f, DamageSource damagesource) {
        return EnchantmentHelper.modifyDamage(this.level(), this.getWeaponItem(), entity, damagesource, f);
    }

    @Override
    public void onEquippedItemBroken(Item item, EquipmentSlot enumitemslot) {
        super.onEquippedItemBroken(item, enumitemslot);
        this.awardStat(Stats.ITEM_BROKEN.get(item));
    }

    public Input getLastClientInput() {
        return this.lastClientInput;
    }

    public void setLastClientInput(Input input) {
        this.lastClientInput = input;
    }

    public Vec3 getLastClientMoveIntent() {
        float f;
        float f2 = this.lastClientInput.left() == this.lastClientInput.right() ? 0.0f : (f = this.lastClientInput.left() ? 1.0f : -1.0f);
        float f1 = this.lastClientInput.forward() == this.lastClientInput.backward() ? 0.0f : (this.lastClientInput.forward() ? 1.0f : -1.0f);
        return ServerPlayer.getInputVector(new Vec3(f, 0.0, f1), 1.0f, this.getYRot());
    }

    public void registerEnderPearl(ThrownEnderpearl entityenderpearl) {
        this.enderPearls.add(entityenderpearl);
    }

    public void deregisterEnderPearl(ThrownEnderpearl entityenderpearl) {
        this.enderPearls.remove(entityenderpearl);
    }

    public Set<ThrownEnderpearl> getEnderPearls() {
        return this.enderPearls;
    }

    public CompoundTag getShoulderEntityLeft() {
        return this.shoulderEntityLeft;
    }

    public void setShoulderEntityLeft(CompoundTag nbttagcompound) {
        this.shoulderEntityLeft = nbttagcompound;
        this.setShoulderParrotLeft(ServerPlayer.extractParrotVariant(nbttagcompound));
    }

    public CompoundTag getShoulderEntityRight() {
        return this.shoulderEntityRight;
    }

    public void setShoulderEntityRight(CompoundTag nbttagcompound) {
        this.shoulderEntityRight = nbttagcompound;
        this.setShoulderParrotRight(ServerPlayer.extractParrotVariant(nbttagcompound));
    }

    public long registerAndUpdateEnderPearlTicket(ThrownEnderpearl entityenderpearl) {
        Level world = entityenderpearl.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ChunkPos chunkcoordintpair = entityenderpearl.chunkPosition();
            this.registerEnderPearl(entityenderpearl);
            worldserver.resetEmptyTime();
            return ServerPlayer.placeEnderPearlTicket(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long placeEnderPearlTicket(ServerLevel worldserver, ChunkPos chunkcoordintpair) {
        worldserver.getChunkSource().addTicketWithRadius(TicketType.ENDER_PEARL, chunkcoordintpair, 2);
        return TicketType.ENDER_PEARL.timeout();
    }

    public void requestDebugSubscriptions(Set<DebugSubscription<?>> set) {
        this.requestedDebugSubscriptions = Set.copyOf(set);
    }

    public Set<DebugSubscription<?>> debugSubscriptions() {
        return !this.server.debugSubscribers().hasRequiredPermissions(this) ? Set.of() : this.requestedDebugSubscriptions;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.level().getDayTime() + this.timeOffset;
        }
        return this.level().getDayTime() - this.level().getDayTime() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f));
        } else {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, newThunder));
            } else {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = Mth.clamp(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.level().getLevelData().isRaining() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getScoreboardName() + " at " + this.getX() + "," + this.getY() + "," + this.getZ() + ")";
    }

    public void forceSetPositionRotation(double x, double y, double z, float yaw, float pitch) {
        this.snapTo(x, y, z, yaw, pitch);
        this.connection.resetPosition();
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() || !this.getBukkitEntity().isOnline();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.experienceProgress;
            this.newTotalExp = this.totalExperience;
            this.newLevel = this.experienceLevel;
        }
        this.setHealth(this.getMaxHealth());
        this.stopUsingItem();
        this.setRemainingFireTicks(0);
        this.fallDistance = 0.0;
        this.foodData = new FoodData();
        this.experienceLevel = this.newLevel;
        this.totalExperience = this.newTotalExp;
        this.experienceProgress = 0.0f;
        this.deathTime = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.effectsDirty = true;
        this.containerMenu = this.inventoryMenu;
        this.lastHurtByPlayer = null;
        this.lastHurtByMob = null;
        this.combatTracker = new CombatTracker(this);
        this.lastSentExp = -1;
        if (this.keepLevel) {
            this.experienceProgress = exp;
        } else {
            this.giveExperiencePoints(this.newExp);
        }
        this.keepLevel = false;
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.skipDropExperience = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnConfig(LevelData.RespawnData respawnData, boolean forced) {
        public static final Codec<RespawnConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelData.RespawnData.MAP_CODEC.forGetter(RespawnConfig::respawnData), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::forced)).apply((Applicative)instance, RespawnConfig::new));

        static ResourceKey<Level> getDimensionOrDefault(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null ? entityplayer_respawnconfig.respawnData().dimension() : Level.OVERWORLD;
        }

        public boolean isSamePosition(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null && this.respawnData.globalPos().equals(entityplayer_respawnconfig.respawnData.globalPos());
        }
    }

    public record RespawnPosAngle(Vec3 position, float yaw, float pitch, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3 vec3d, BlockPos blockposition, float f, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.calculateLookAtYaw(vec3d, blockposition), f, isBedSpawn, isAnchorSpawn);
        }

        private static float calculateLookAtYaw(Vec3 vec3d, BlockPos blockposition) {
            Vec3 vec3d1 = Vec3.atBottomCenterOf(blockposition).subtract(vec3d).normalize();
            return (float)Mth.wrapDegrees(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
        }
    }

    public record SavedPosition(Optional<ResourceKey<Level>> dimension, Optional<Vec3> position, Optional<Vec2> rotation) {
        public static final MapCodec<SavedPosition> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Level.RESOURCE_KEY_CODEC.optionalFieldOf(ServerPlayer.TAG_DIMENSION).forGetter(SavedPosition::dimension), (App)Vec3.CODEC.optionalFieldOf("Pos").forGetter(SavedPosition::position), (App)Vec2.CODEC.optionalFieldOf("Rotation").forGetter(SavedPosition::rotation)).apply((Applicative)instance, SavedPosition::new));
        public static final SavedPosition EMPTY = new SavedPosition(Optional.empty(), Optional.empty(), Optional.empty());
    }
}

