/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetHeldSlotPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.FutureChain;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.StringUtil;
import net.minecraft.util.TickThrottler;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Input;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftInput;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_21_R6.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class ServerGamePacketListenerImpl
extends ServerCommonPacketListenerImpl
implements GameProtocols.Context,
ServerGamePacketListener,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final Component CHAT_VALIDATION_FAILED = Component.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final Component INVALID_COMMAND_SIGNATURE = Component.translatable("chat.disabled.invalid_command_signature").withStyle(ChatFormatting.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public ServerPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private final TickThrottler chatSpamThrottler = new TickThrottler(20, 200);
    private final TickThrottler dropSpamThrottler = new TickThrottler(20, 1480);
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private net.minecraft.world.entity.Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3 awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    private boolean receivedMovementThisTick;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageChain.Decoder signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private int nextChatIndex;
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;

    public ServerGamePacketListenerImpl(MinecraftServer minecraftserver, Connection networkmanager, ServerPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        super(minecraftserver, networkmanager, commonlistenercookie, entityplayer);
        this.chunkSender = new PlayerChunkSender(networkmanager.isMemoryConnection());
        this.player = entityplayer;
        entityplayer.connection = this;
        entityplayer.getTextFilter().join();
        UUID uuid = entityplayer.getUUID();
        Objects.requireNonNull(minecraftserver);
        this.signedMessageDecoder = SignedMessageChain.Decoder.unsigned(uuid, minecraftserver::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(minecraftserver.chatExecutor);
    }

    @Override
    public void tick() {
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        if (this.server.isPaused() || !this.tickPlayer()) {
            this.keepConnectionAlive();
            this.chatSpamThrottler.tick();
            this.dropSpamThrottler.tick();
            if (this.player.getLastActionTime() > 0L && this.server.playerIdleTimeout() > 0 && Util.getMillis() - this.player.getLastActionTime() > TimeUnit.MINUTES.toMillis(this.server.playerIdleTimeout()) && !this.player.wonGame) {
                this.player.resetLastActionTime();
                this.disconnect(Component.translatable("multiplayer.disconnect.idling"));
            }
        }
    }

    private boolean tickPlayer() {
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absSnapTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getPlainTextName());
                this.disconnect(Component.translatable("multiplayer.disconnect.flying"));
                return true;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle != this.player && this.lastVehicle.getControllingPassenger() == this.player) {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getPlainTextName());
                    this.disconnect(Component.translatable("multiplayer.disconnect.flying"));
                    return true;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        } else {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        }
        return false;
    }

    private int getMaximumFlyingTicks(net.minecraft.world.entity.Entity entity) {
        double d0 = entity.getGravity();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return Mth.ceil(80.0 * Math.max(d1, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> packet) {
        return super.shouldHandleMessage(packet) ? true : this.waitingForSwitchToConfig && this.connection.isConnected() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T t0, BiFunction<TextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.player.getTextFilter(), (TextFilter)t0).thenApply(object -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String s) {
        return this.filterTextPacket(s, TextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> list) {
        return this.filterTextPacket(list, TextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(ServerboundPlayerInputPacket packetplayinsteervehicle) {
        PacketUtils.ensureRunningOnSameThread(packetplayinsteervehicle, this, this.player.level());
        if (!packetplayinsteervehicle.input().equals(this.player.getLastClientInput())) {
            PlayerInputEvent event = new PlayerInputEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), (Input)new CraftInput(packetplayinsteervehicle.input()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        this.player.setLastClientInput(packetplayinsteervehicle.input());
        if (this.player.hasClientLoaded()) {
            this.player.resetLastActionTime();
            boolean shift = packetplayinsteervehicle.input().shift();
            if (this.player.isShiftKeyDown() != shift) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((org.bukkit.entity.Player)this.getCraftPlayer(), shift);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.player.setShiftKeyDown(shift);
                }
            }
        }
    }

    private static boolean containsInvalidValues(double d0, double d1, double d2, float f, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f);
    }

    private static double clampHorizontal(double d0) {
        return Mth.clamp(d0, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double d0) {
        return Mth.clamp(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(ServerboundMoveVehiclePacket packetplayinvehiclemove) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.ensureRunningOnSameThread(packetplayinvehiclemove, this, this.player.level());
        if (ServerGamePacketListenerImpl.containsInvalidValues(packetplayinvehiclemove.position().x(), packetplayinvehiclemove.position().y(), packetplayinvehiclemove.position().z(), packetplayinvehiclemove.yRot(), packetplayinvehiclemove.xRot())) {
            this.disconnect(Component.translatable("multiplayer.disconnect.invalid_vehicle_movement"));
        } else if (!this.updateAwaitingTeleport() && this.player.hasClientLoaded() && (entity = this.player.getRootVehicle()) != this.player && entity.getControllingPassenger() == this.player && entity == this.lastVehicle) {
            LivingEntity entityliving;
            ServerLevel worldserver = this.player.level();
            double prevX = this.player.getX();
            double prevY = this.player.getY();
            double prevZ = this.player.getZ();
            float prevYaw = this.player.getYRot();
            float prevPitch = this.player.getXRot();
            double d0 = entity.getX();
            double d1 = entity.getY();
            double d2 = entity.getZ();
            double d3 = ServerGamePacketListenerImpl.clampHorizontal(packetplayinvehiclemove.position().x());
            double d4 = ServerGamePacketListenerImpl.clampVertical(packetplayinvehiclemove.position().y());
            double d5 = ServerGamePacketListenerImpl.clampHorizontal(packetplayinvehiclemove.position().z());
            float f = Mth.wrapDegrees(packetplayinvehiclemove.yRot());
            float f1 = Mth.wrapDegrees(packetplayinvehiclemove.xRot());
            double d6 = d3 - this.vehicleFirstGoodX;
            double d7 = d4 - this.vehicleFirstGoodY;
            double d8 = d5 - this.vehicleFirstGoodZ;
            double d9 = entity.getDeltaMovement().lengthSqr();
            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
            this.lastTick = (int)(System.currentTimeMillis() / 50L);
            ++this.receivedMovePacketCount;
            int i = this.receivedMovePacketCount - this.knownMovePacketCount;
            if (i > Math.max(this.allowedPlayerTicks, 5)) {
                LOGGER.debug(this.player.getScoreboardName() + " is sending move packets too frequently (" + i + " packets since last tick)");
                i = 1;
            }
            this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
            double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
            speed *= 2.0;
            if (d10 - d9 > Math.max(100.0, Math.pow((double)(10.0f * (float)i) * speed, 2.0)) && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.getPlainTextName(), this.player.getPlainTextName(), d6, d7, d8});
                this.send(ClientboundMoveVehiclePacket.fromEntity(entity));
                return;
            }
            AABB axisalignedbb = entity.getBoundingBox();
            d6 = d3 - this.vehicleLastGoodX;
            d7 = d4 - this.vehicleLastGoodY;
            d8 = d5 - this.vehicleLastGoodZ;
            boolean flag = entity.verticalCollisionBelow;
            if (entity instanceof LivingEntity && (entityliving = (LivingEntity)entity).onClimbable()) {
                entityliving.resetFallDistance();
            }
            entity.move(MoverType.PLAYER, new Vec3(d6, d7, d8));
            double d11 = d7;
            d6 = d3 - entity.getX();
            d7 = d4 - entity.getY();
            if (d7 > -0.5 || d7 < 0.5) {
                d7 = 0.0;
            }
            d8 = d5 - entity.getZ();
            d10 = d6 * d6 + d7 * d7 + d8 * d8;
            boolean flag1 = false;
            if (d10 > 0.0625) {
                flag1 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.getPlainTextName(), this.player.getPlainTextName(), Math.sqrt(d10)});
            }
            if (flag1 && worldserver.noCollision(entity, axisalignedbb) || this.isEntityCollidingWithAnythingNew(worldserver, entity, axisalignedbb, d3, d4, d5)) {
                entity.absSnapTo(d0, d1, d2, f, f1);
                this.player.absSnapTo(d0, d1, d2, this.player.getYRot(), this.player.getXRot());
                this.send(ClientboundMoveVehiclePacket.fromEntity(entity));
                entity.removeLatestMovementRecording();
                return;
            }
            entity.absSnapTo(d3, d4, d5, f, f1);
            this.player.absSnapTo(d3, d4, d5, this.player.getYRot(), this.player.getXRot());
            CraftPlayer player = this.getCraftPlayer();
            if (!this.hasMoved) {
                this.lastPosX = prevX;
                this.lastPosY = prevY;
                this.lastPosZ = prevZ;
                this.lastYaw = prevYaw;
                this.lastPitch = prevPitch;
                this.hasMoved = true;
            }
            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
            Location to = CraftLocation.toBukkit(packetplayinvehiclemove.position(), player.getWorld(), packetplayinvehiclemove.yRot(), packetplayinvehiclemove.xRot());
            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                this.lastPosX = to.getX();
                this.lastPosY = to.getY();
                this.lastPosZ = to.getZ();
                this.lastYaw = to.getYaw();
                this.lastPitch = to.getPitch();
                Location oldTo = to.clone();
                PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.teleport(from);
                    return;
                }
                if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                    this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return;
                }
                if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                    this.justTeleported = false;
                    return;
                }
            }
            this.player.level().getChunkSource().move(this.player);
            Vec3 vec3d = new Vec3(entity.getX() - d0, entity.getY() - d1, entity.getZ() - d2);
            this.handlePlayerKnownMovement(vec3d);
            entity.setOnGroundWithMovement(packetplayinvehiclemove.onGround(), vec3d);
            entity.doCheckFallDamage(vec3d.x, vec3d.y, vec3d.z, packetplayinvehiclemove.onGround());
            this.player.checkMovementStatistics(vec3d.x, vec3d.y, vec3d.z);
            this.clientVehicleIsFloating = d11 >= -0.03125 && !flag && !this.server.allowFlight() && !entity.isFlyingVehicle() && !entity.isNoGravity() && this.noBlocksAround(entity);
            this.vehicleLastGoodX = entity.getX();
            this.vehicleLastGoodY = entity.getY();
            this.vehicleLastGoodZ = entity.getZ();
        }
    }

    private boolean noBlocksAround(net.minecraft.world.entity.Entity entity) {
        return entity.level().getBlockStates(entity.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBehaviour.BlockStateBase::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packetplayinteleportaccept) {
        PacketUtils.ensureRunningOnSameThread(packetplayinteleportaccept, this, this.player.level());
        if (packetplayinteleportaccept.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(Component.translatable("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.player.absSnapTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            this.player.hasChangedDimension();
            this.awaitingPositionFromClient = null;
            this.player.level().getChunkSource().move(this.player);
        }
    }

    @Override
    public void handleAcceptPlayerLoad(ServerboundPlayerLoadedPacket serverboundplayerloadedpacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundplayerloadedpacket, this, this.player.level());
        this.player.setClientLoaded(true);
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket packetplayinrecipedisplayed) {
        PacketUtils.ensureRunningOnSameThread(packetplayinrecipedisplayed, this, this.player.level());
        RecipeManager.ServerDisplayInfo craftingmanager_d = this.server.getRecipeManager().getRecipeFromDisplay(packetplayinrecipedisplayed.recipe());
        if (craftingmanager_d != null) {
            this.player.getRecipeBook().removeHighlight(craftingmanager_d.parent().id());
        }
    }

    @Override
    public void handleBundleItemSelectedPacket(ServerboundSelectBundleItemPacket serverboundselectbundleitempacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundselectbundleitempacket, this, this.player.level());
        this.player.containerMenu.setSelectedBundleItemIndex(serverboundselectbundleitempacket.slotId(), serverboundselectbundleitempacket.selectedItemIndex());
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket packetplayinrecipesettings) {
        PacketUtils.ensureRunningOnSameThread(packetplayinrecipesettings, this, this.player.level());
        CraftEventFactory.callRecipeBookSettingsEvent(this.player, packetplayinrecipesettings.getBookType(), packetplayinrecipesettings.isOpen(), packetplayinrecipesettings.isFiltering());
        this.player.getRecipeBook().setBookSetting(packetplayinrecipesettings.getBookType(), packetplayinrecipesettings.isOpen(), packetplayinrecipesettings.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket packetplayinadvancements) {
        PacketUtils.ensureRunningOnSameThread(packetplayinadvancements, this, this.player.level());
        if (packetplayinadvancements.getAction() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation minecraftkey = Objects.requireNonNull(packetplayinadvancements.getTab());
            AdvancementHolder advancementholder = this.server.getAdvancements().get(minecraftkey);
            if (advancementholder != null) {
                this.player.getAdvancements().setSelectedTab(advancementholder);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket packetplayintabcomplete) {
        PacketUtils.ensureRunningOnSameThread(packetplayintabcomplete, this, this.player.level());
        if (!(this.chatSpamThrottler.isIncrementAndUnderThreshold(1, 500) || this.server.getPlayerList().isOp(this.player.nameAndId()) || this.server.isSingleplayerOwner(this.player.nameAndId()))) {
            this.disconnect(Component.translatable("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.getCommand());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandSourceStack> parseresults = this.server.getCommands().getDispatcher().parse(stringreader, this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            Suggestions suggestions1 = suggestions.getList().size() <= 1000 ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, 1000));
            this.send(new ClientboundCommandSuggestionsPacket(packetplayintabcomplete.getId(), suggestions1));
        });
    }

    @Override
    public void handleSetCommandBlock(ServerboundSetCommandBlockPacket packetplayinsetcommandblock) {
        PacketUtils.ensureRunningOnSameThread(packetplayinsetcommandblock, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock commandblocklistenerabstract = null;
            CommandBlockEntity tileentitycommand = null;
            BlockPos blockposition = packetplayinsetcommandblock.getPos();
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof CommandBlockEntity) {
                tileentitycommand = (CommandBlockEntity)tileentity;
                commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            }
            String s = packetplayinsetcommandblock.getCommand();
            boolean flag = packetplayinsetcommandblock.isTrackOutput();
            if (commandblocklistenerabstract != null) {
                CommandBlockEntity.Mode tileentitycommand_type = tileentitycommand.getMode();
                BlockState iblockdata = this.player.level().getBlockState(blockposition);
                Direction enumdirection = iblockdata.getValue(CommandBlock.FACING);
                BlockState iblockdata2 = switch (packetplayinsetcommandblock.getMode()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                    default -> Blocks.COMMAND_BLOCK.defaultBlockState();
                };
                BlockState iblockdata3 = (BlockState)((BlockState)iblockdata2.setValue(CommandBlock.FACING, enumdirection)).setValue(CommandBlock.CONDITIONAL, packetplayinsetcommandblock.isConditional());
                if (iblockdata3 != iblockdata) {
                    this.player.level().setBlock(blockposition, iblockdata3, 2);
                    tileentity.setBlockState(iblockdata3);
                    this.player.level().getChunkAt(blockposition).setBlockEntity(tileentity);
                }
                commandblocklistenerabstract.setCommand(s);
                commandblocklistenerabstract.setTrackOutput(flag);
                if (!flag) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                tileentitycommand.setAutomatic(packetplayinsetcommandblock.isAutomatic());
                if (tileentitycommand_type != packetplayinsetcommandblock.getMode()) {
                    tileentitycommand.onModeSwitch();
                }
                commandblocklistenerabstract.onUpdated();
                if (!StringUtil.isNullOrEmpty(s)) {
                    this.player.sendSystemMessage(Component.translatable("advMode.setCommand.success", s));
                }
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket packetplayinsetcommandminecart) {
        PacketUtils.ensureRunningOnSameThread(packetplayinsetcommandminecart, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock commandblocklistenerabstract = packetplayinsetcommandminecart.getCommandBlock(this.player.level());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.setCommand(packetplayinsetcommandminecart.getCommand());
                commandblocklistenerabstract.setTrackOutput(packetplayinsetcommandminecart.isTrackOutput());
                if (!packetplayinsetcommandminecart.isTrackOutput()) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                commandblocklistenerabstract.onUpdated();
                this.player.sendSystemMessage(Component.translatable("advMode.setCommand.success", packetplayinsetcommandminecart.getCommand()));
            }
        }
    }

    @Override
    public void handlePickItemFromBlock(ServerboundPickItemFromBlockPacket serverboundpickitemfromblockpacket) {
        boolean flag;
        BlockState iblockdata;
        ItemStack itemstack;
        ServerLevel worldserver = this.player.level();
        PacketUtils.ensureRunningOnSameThread(serverboundpickitemfromblockpacket, this, worldserver);
        BlockPos blockposition = serverboundpickitemfromblockpacket.pos();
        if (this.player.canInteractWithBlock(blockposition, 1.0) && worldserver.isLoaded(blockposition) && !(itemstack = (iblockdata = worldserver.getBlockState(blockposition)).getCloneItemStack(worldserver, blockposition, flag = this.player.hasInfiniteMaterials() && serverboundpickitemfromblockpacket.includeData())).isEmpty()) {
            if (flag) {
                ServerGamePacketListenerImpl.addBlockDataToItem(iblockdata, worldserver, blockposition, itemstack);
            }
            this.tryPickItem(itemstack);
        }
    }

    private static void addBlockDataToItem(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack) {
        BlockEntity tileentity;
        BlockEntity blockEntity = tileentity = iblockdata.hasBlockEntity() ? worldserver.getBlockEntity(blockposition) : null;
        if (tileentity != null) {
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(tileentity.problemPath(), LOGGER);){
                TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, worldserver.registryAccess());
                tileentity.saveCustomOnly(tagvalueoutput);
                tileentity.removeComponentsFromTag(tagvalueoutput);
                BlockItem.setBlockEntityData(itemstack, tileentity.getType(), tagvalueoutput);
                itemstack.applyComponents(tileentity.collectComponents());
            }
        }
    }

    @Override
    public void handlePickItemFromEntity(ServerboundPickItemFromEntityPacket serverboundpickitemfromentitypacket) {
        ItemStack itemstack;
        ServerLevel worldserver = this.player.level();
        PacketUtils.ensureRunningOnSameThread(serverboundpickitemfromentitypacket, this, worldserver);
        net.minecraft.world.entity.Entity entity = worldserver.getEntityOrPart(serverboundpickitemfromentitypacket.id());
        if (entity != null && this.player.canInteractWithEntity(entity, 3.0) && (itemstack = entity.getPickResult()) != null && !itemstack.isEmpty()) {
            this.tryPickItem(itemstack);
        }
    }

    private void tryPickItem(ItemStack itemstack) {
        if (itemstack.isItemEnabled(this.player.level().enabledFeatures())) {
            net.minecraft.world.entity.player.Inventory playerinventory = this.player.getInventory();
            int i = playerinventory.findSlotMatchingItem(itemstack);
            if (i != -1) {
                if (net.minecraft.world.entity.player.Inventory.isHotbarSlot(i)) {
                    playerinventory.setSelectedSlot(i);
                } else {
                    playerinventory.pickSlot(i);
                }
            } else if (this.player.hasInfiniteMaterials()) {
                playerinventory.addAndPickItem(itemstack);
            }
            this.send(new ClientboundSetHeldSlotPacket(playerinventory.getSelectedSlot()));
            this.player.inventoryMenu.broadcastChanges();
        }
    }

    @Override
    public void handleRenameItem(ServerboundRenameItemPacket packetplayinitemname) {
        PacketUtils.ensureRunningOnSameThread(packetplayinitemname, this, this.player.level());
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof AnvilMenu) {
            AnvilMenu containeranvil = (AnvilMenu)container;
            if (!containeranvil.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containeranvil);
                return;
            }
            containeranvil.setItemName(packetplayinitemname.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(ServerboundSetBeaconPacket packetplayinbeacon) {
        PacketUtils.ensureRunningOnSameThread(packetplayinbeacon, this, this.player.level());
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof BeaconMenu) {
            BeaconMenu containerbeacon = (BeaconMenu)container;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            containerbeacon.updateEffects(packetplayinbeacon.primary(), packetplayinbeacon.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(ServerboundSetStructureBlockPacket packetplayinstruct) {
        PacketUtils.ensureRunningOnSameThread(packetplayinstruct, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packetplayinstruct.getPos();
            BlockState iblockdata = this.player.level().getBlockState(blockposition);
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof StructureBlockEntity) {
                StructureBlockEntity tileentitystructure = (StructureBlockEntity)tileentity;
                tileentitystructure.setMode(packetplayinstruct.getMode());
                tileentitystructure.setStructureName(packetplayinstruct.getName());
                tileentitystructure.setStructurePos(packetplayinstruct.getOffset());
                tileentitystructure.setStructureSize(packetplayinstruct.getSize());
                tileentitystructure.setMirror(packetplayinstruct.getMirror());
                tileentitystructure.setRotation(packetplayinstruct.getRotation());
                tileentitystructure.setMetaData(packetplayinstruct.getData());
                tileentitystructure.setIgnoreEntities(packetplayinstruct.isIgnoreEntities());
                tileentitystructure.setStrict(packetplayinstruct.isStrict());
                tileentitystructure.setShowAir(packetplayinstruct.isShowAir());
                tileentitystructure.setShowBoundingBox(packetplayinstruct.isShowBoundingBox());
                tileentitystructure.setIntegrity(packetplayinstruct.getIntegrity());
                tileentitystructure.setSeed(packetplayinstruct.getSeed());
                if (tileentitystructure.hasStructureName()) {
                    String s = tileentitystructure.getStructureName();
                    if (packetplayinstruct.getUpdateType() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (tileentitystructure.saveStructure()) {
                            this.player.displayClientMessage(Component.translatable("structure_block.save_success", s), false);
                        } else {
                            this.player.displayClientMessage(Component.translatable("structure_block.save_failure", s), false);
                        }
                    } else if (packetplayinstruct.getUpdateType() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!tileentitystructure.isStructureLoadable()) {
                            this.player.displayClientMessage(Component.translatable("structure_block.load_not_found", s), false);
                        } else if (tileentitystructure.placeStructureIfSameSize(this.player.level())) {
                            this.player.displayClientMessage(Component.translatable("structure_block.load_success", s), false);
                        } else {
                            this.player.displayClientMessage(Component.translatable("structure_block.load_prepare", s), false);
                        }
                    } else if (packetplayinstruct.getUpdateType() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (tileentitystructure.detectSize()) {
                            this.player.displayClientMessage(Component.translatable("structure_block.size_success", s), false);
                        } else {
                            this.player.displayClientMessage(Component.translatable("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.displayClientMessage(Component.translatable("structure_block.invalid_structure_name", packetplayinstruct.getName()), false);
                }
                tileentitystructure.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleSetTestBlock(ServerboundSetTestBlockPacket serverboundsettestblockpacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundsettestblockpacket, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = serverboundsettestblockpacket.position();
            BlockState iblockdata = this.player.level().getBlockState(blockposition);
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof TestBlockEntity) {
                TestBlockEntity testblockentity = (TestBlockEntity)tileentity;
                testblockentity.setMode(serverboundsettestblockpacket.mode());
                testblockentity.setMessage(serverboundsettestblockpacket.message());
                testblockentity.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, testblockentity.getBlockState(), 3);
            }
        }
    }

    @Override
    public void handleTestInstanceBlockAction(ServerboundTestInstanceBlockActionPacket serverboundtestinstanceblockactionpacket) {
        BlockEntity tileentity;
        PacketUtils.ensureRunningOnSameThread(serverboundtestinstanceblockactionpacket, this, this.player.level());
        BlockPos blockposition = serverboundtestinstanceblockactionpacket.pos();
        if (this.player.canUseGameMasterBlocks() && (tileentity = this.player.level().getBlockEntity(blockposition)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)tileentity;
            if (serverboundtestinstanceblockactionpacket.action() != ServerboundTestInstanceBlockActionPacket.Action.QUERY && serverboundtestinstanceblockactionpacket.action() != ServerboundTestInstanceBlockActionPacket.Action.INIT) {
                testinstanceblockentity.set(serverboundtestinstanceblockactionpacket.data());
                if (serverboundtestinstanceblockactionpacket.action() == ServerboundTestInstanceBlockActionPacket.Action.RESET) {
                    ServerPlayer entityplayer = this.player;
                    Objects.requireNonNull(this.player);
                    testinstanceblockentity.resetTest(entityplayer::sendSystemMessage);
                } else if (serverboundtestinstanceblockactionpacket.action() == ServerboundTestInstanceBlockActionPacket.Action.SAVE) {
                    ServerPlayer entityplayer1 = this.player;
                    Objects.requireNonNull(this.player);
                    testinstanceblockentity.saveTest(entityplayer1::sendSystemMessage);
                } else if (serverboundtestinstanceblockactionpacket.action() == ServerboundTestInstanceBlockActionPacket.Action.EXPORT) {
                    ServerPlayer entityplayer2 = this.player;
                    Objects.requireNonNull(this.player);
                    testinstanceblockentity.exportTest(entityplayer2::sendSystemMessage);
                } else if (serverboundtestinstanceblockactionpacket.action() == ServerboundTestInstanceBlockActionPacket.Action.RUN) {
                    ServerPlayer entityplayer3 = this.player;
                    Objects.requireNonNull(this.player);
                    testinstanceblockentity.runTest(entityplayer3::sendSystemMessage);
                }
                BlockState iblockdata = this.player.level().getBlockState(blockposition);
                this.player.level().sendBlockUpdated(blockposition, Blocks.AIR.defaultBlockState(), iblockdata, 3);
            } else {
                HolderLookup.RegistryLookup iregistry = this.player.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE);
                Optional<ResourceKey<GameTestInstance>> optional = serverboundtestinstanceblockactionpacket.data().test();
                Objects.requireNonNull(iregistry);
                Optional optional1 = optional.flatMap(((Registry)iregistry)::get);
                Component ichatbasecomponent = optional1.isPresent() ? ((GameTestInstance)((Holder.Reference)optional1.get()).value()).describe() : Component.translatable("test_instance.description.no_test").withStyle(ChatFormatting.RED);
                Optional<Object> optional2 = serverboundtestinstanceblockactionpacket.action() == ServerboundTestInstanceBlockActionPacket.Action.QUERY ? serverboundtestinstanceblockactionpacket.data().test().flatMap(resourcekey -> TestInstanceBlockEntity.getStructureSize(this.player.level(), resourcekey)) : Optional.empty();
                this.connection.send(new ClientboundTestInstanceBlockStatus(ichatbasecomponent, optional2));
            }
            return;
        }
    }

    @Override
    public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket packetplayinsetjigsaw) {
        PacketUtils.ensureRunningOnSameThread(packetplayinsetjigsaw, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packetplayinsetjigsaw.getPos();
            BlockState iblockdata = this.player.level().getBlockState(blockposition);
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity tileentityjigsaw = (JigsawBlockEntity)tileentity;
                tileentityjigsaw.setName(packetplayinsetjigsaw.getName());
                tileentityjigsaw.setTarget(packetplayinsetjigsaw.getTarget());
                tileentityjigsaw.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, packetplayinsetjigsaw.getPool()));
                tileentityjigsaw.setFinalState(packetplayinsetjigsaw.getFinalState());
                tileentityjigsaw.setJoint(packetplayinsetjigsaw.getJoint());
                tileentityjigsaw.setPlacementPriority(packetplayinsetjigsaw.getPlacementPriority());
                tileentityjigsaw.setSelectionPriority(packetplayinsetjigsaw.getSelectionPriority());
                tileentityjigsaw.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleJigsawGenerate(ServerboundJigsawGeneratePacket packetplayinjigsawgenerate) {
        PacketUtils.ensureRunningOnSameThread(packetplayinjigsawgenerate, this, this.player.level());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packetplayinjigsawgenerate.getPos();
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity tileentityjigsaw = (JigsawBlockEntity)tileentity;
                tileentityjigsaw.generate(this.player.level(), packetplayinjigsawgenerate.levels(), packetplayinjigsawgenerate.keepJigsaws());
            }
        }
    }

    @Override
    public void handleSelectTrade(ServerboundSelectTradePacket packetplayintrsel) {
        PacketUtils.ensureRunningOnSameThread(packetplayintrsel, this, this.player.level());
        int i = packetplayintrsel.getItem();
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof MerchantMenu) {
            MerchantMenu containermerchant = (MerchantMenu)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.player, i, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.player.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containermerchant);
                return;
            }
            containermerchant.setSelectionHint(i);
            containermerchant.tryMoveItems(i);
        }
    }

    @Override
    public void handleEditBook(ServerboundEditBookPacket packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect(Component.literal("Book edited too quickly!"));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i = packetplayinbedit.slot();
        if (net.minecraft.world.entity.player.Inventory.isHotbarSlot(i) || i == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.title();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            list.addAll(packetplayinbedit.pages());
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.signBook((FilteredText)list1.get(0), list1.subList(1, list1.size()), i) : list1 -> this.updateBookContents((List<FilteredText>)list1, i);
            this.filterTextPacket(list).thenAcceptAsync(consumer, (Executor)this.server);
        }
    }

    private void updateBookContents(List<FilteredText> list, int i) {
        ItemStack handItem = this.player.getInventory().getItem(i);
        ItemStack itemstack = handItem.copy();
        if (itemstack.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            List<Filterable<String>> list1 = list.stream().map(this::filterableFromOutgoing).toList();
            itemstack.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(list1));
            CraftEventFactory.handleEditBookEvent(this.player, i, handItem, itemstack);
        }
    }

    private void signBook(FilteredText filteredtext, List<FilteredText> list, int i) {
        ItemStack itemstack = this.player.getInventory().getItem(i);
        if (itemstack.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            ItemStack itemstack1 = itemstack.transmuteCopy(Items.WRITTEN_BOOK);
            itemstack1.remove(DataComponents.WRITABLE_BOOK_CONTENT);
            List<Filterable<Component>> list1 = list.stream().map(filteredtext1 -> this.filterableFromOutgoing((FilteredText)filteredtext1).map(Component::literal)).toList();
            itemstack1.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(filteredtext), this.player.getPlainTextName(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.player, i, itemstack, itemstack1);
            this.player.getInventory().setItem(i, itemstack);
        }
    }

    private Filterable<String> filterableFromOutgoing(FilteredText filteredtext) {
        return this.player.isTextFilteringEnabled() ? Filterable.passThrough(filteredtext.filteredOrEmpty()) : Filterable.from(filteredtext);
    }

    @Override
    public void handleEntityTagQuery(ServerboundEntityTagQueryPacket packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.ensureRunningOnSameThread(packetplayinentitynbtquery, this, this.player.level());
        if (this.player.hasPermissions(2) && (entity = this.player.level().getEntity(packetplayinentitynbtquery.getEntityId())) != null) {
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
                TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, entity.registryAccess());
                entity.saveWithoutId(tagvalueoutput);
                CompoundTag nbttagcompound = tagvalueoutput.buildResult();
                this.send(new ClientboundTagQueryPacket(packetplayinentitynbtquery.getTransactionId(), nbttagcompound));
            }
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket serverboundcontainerslotstatechangedpacket) {
        CrafterMenu craftermenu;
        Container iinventory;
        AbstractContainerMenu container;
        PacketUtils.ensureRunningOnSameThread(serverboundcontainerslotstatechangedpacket, this, this.player.level());
        if (!this.player.isSpectator() && serverboundcontainerslotstatechangedpacket.containerId() == this.player.containerMenu.containerId && (container = this.player.containerMenu) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.setSlotState(serverboundcontainerslotstatechangedpacket.slotId(), serverboundcontainerslotstatechangedpacket.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket packetplayintilenbtquery) {
        PacketUtils.ensureRunningOnSameThread(packetplayintilenbtquery, this, this.player.level());
        if (this.player.hasPermissions(2)) {
            BlockEntity tileentity = this.player.level().getBlockEntity(packetplayintilenbtquery.getPos());
            CompoundTag nbttagcompound = tileentity != null ? tileentity.saveWithoutMetadata(this.player.registryAccess()) : null;
            this.send(new ClientboundTagQueryPacket(packetplayintilenbtquery.getTransactionId(), nbttagcompound));
        }
    }

    @Override
    public void handleMovePlayer(ServerboundMovePlayerPacket packetplayinflying) {
        PacketUtils.ensureRunningOnSameThread(packetplayinflying, this, this.player.level());
        if (ServerGamePacketListenerImpl.containsInvalidValues(packetplayinflying.getX(0.0), packetplayinflying.getY(0.0), packetplayinflying.getZ(0.0), packetplayinflying.getYRot(0.0f), packetplayinflying.getXRot(0.0f))) {
            this.disconnect(Component.translatable("multiplayer.disconnect.invalid_player_movement"));
        } else {
            ServerLevel worldserver = this.player.level();
            if (!this.player.wonGame && !this.player.isImmobile()) {
                if (this.tickCount == 0) {
                    this.resetPosition();
                }
                if (this.player.hasClientLoaded()) {
                    float f = Mth.wrapDegrees(packetplayinflying.getYRot(this.player.getYRot()));
                    float f1 = Mth.wrapDegrees(packetplayinflying.getXRot(this.player.getXRot()));
                    if (this.updateAwaitingTeleport()) {
                        this.player.absSnapRotationTo(f, f1);
                    } else {
                        double d0 = ServerGamePacketListenerImpl.clampHorizontal(packetplayinflying.getX(this.player.getX()));
                        double d1 = ServerGamePacketListenerImpl.clampVertical(packetplayinflying.getY(this.player.getY()));
                        double d2 = ServerGamePacketListenerImpl.clampHorizontal(packetplayinflying.getZ(this.player.getZ()));
                        if (this.player.isPassenger()) {
                            this.player.absSnapTo(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                            this.player.level().getChunkSource().move(this.player);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.player.getX();
                            double prevY = this.player.getY();
                            double prevZ = this.player.getZ();
                            float prevYaw = this.player.getYRot();
                            float prevPitch = this.player.getXRot();
                            double d3 = this.player.getX();
                            double d4 = this.player.getY();
                            double d5 = this.player.getZ();
                            double d6 = d0 - this.firstGoodX;
                            double d7 = d1 - this.firstGoodY;
                            double d8 = d2 - this.firstGoodZ;
                            double d9 = this.player.getDeltaMovement().lengthSqr();
                            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            if (this.player.isSleeping()) {
                                if (d10 > 1.0) {
                                    this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                                }
                            } else {
                                boolean flag1;
                                boolean flag = this.player.isFallFlying();
                                if (worldserver.tickRateManager().runsNormally()) {
                                    ++this.receivedMovePacketCount;
                                    int i = this.receivedMovePacketCount - this.knownMovePacketCount;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                        LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getPlainTextName(), (Object)i);
                                        i = 1;
                                    }
                                    this.allowedPlayerTicks = packetplayinflying.hasRot || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                                    if (this.shouldCheckPlayerMovement(flag)) {
                                        float f2;
                                        float f3 = f2 = flag ? 300.0f : 100.0f;
                                        if (d10 - d9 > Math.max((double)f2, Math.pow((double)(10.0f * (float)i) * speed, 2.0))) {
                                            LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getPlainTextName(), d6, d7, d8});
                                            this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                                            return;
                                        }
                                    }
                                }
                                AABB axisalignedbb = this.player.getBoundingBox();
                                d6 = d0 - this.lastGoodX;
                                d7 = d1 - this.lastGoodY;
                                d8 = d2 - this.lastGoodZ;
                                boolean bl = flag1 = d7 > 0.0;
                                if (this.player.onGround() && !packetplayinflying.isOnGround() && flag1) {
                                    this.player.jumpFromGround();
                                }
                                boolean flag2 = this.player.verticalCollisionBelow;
                                this.player.move(MoverType.PLAYER, new Vec3(d6, d7, d8));
                                this.player.onGround = packetplayinflying.isOnGround();
                                double d11 = d7;
                                d6 = d0 - this.player.getX();
                                d7 = d1 - this.player.getY();
                                if (d7 > -0.5 || d7 < 0.5) {
                                    d7 = 0.0;
                                }
                                d8 = d2 - this.player.getZ();
                                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                                boolean flag3 = false;
                                if (!(this.player.isChangingDimension() || !(d10 > 0.0625) || this.player.isSleeping() || this.player.isCreative() || this.player.isSpectator())) {
                                    flag3 = true;
                                    LOGGER.warn("{} moved wrongly!", (Object)this.player.getPlainTextName());
                                }
                                if (this.player.noPhysics || this.player.isSleeping() || (!flag3 || !worldserver.noCollision(this.player, axisalignedbb)) && !this.isEntityCollidingWithAnythingNew(worldserver, this.player, axisalignedbb, d0, d1, d2)) {
                                    this.player.absSnapTo(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packetplayinflying.hasPos) {
                                        to.setX(packetplayinflying.x);
                                        to.setY(packetplayinflying.y);
                                        to.setZ(packetplayinflying.z);
                                    }
                                    if (packetplayinflying.hasRot) {
                                        to.setYaw(packetplayinflying.yRot);
                                        to.setPitch(packetplayinflying.xRot);
                                    }
                                    double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.player.absSnapTo(d0, d1, d2, f, f1);
                                    boolean flag4 = this.player.isAutoSpinAttack();
                                    this.clientIsFloating = d11 >= -0.03125 && !flag2 && !this.player.isSpectator() && !this.server.allowFlight() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !flag && !flag4 && this.noBlocksAround(this.player);
                                    this.player.level().getChunkSource().move(this.player);
                                    Vec3 vec3d = new Vec3(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5);
                                    this.player.setOnGroundWithMovement(packetplayinflying.isOnGround(), packetplayinflying.horizontalCollision(), vec3d);
                                    this.player.doCheckFallDamage(vec3d.x, vec3d.y, vec3d.z, packetplayinflying.isOnGround());
                                    this.handlePlayerKnownMovement(vec3d);
                                    if (flag1) {
                                        this.player.resetFallDistance();
                                    }
                                    if (packetplayinflying.isOnGround() || this.player.hasLandedInLiquid() || this.player.onClimbable() || this.player.isSpectator() || flag || flag4) {
                                        this.player.tryResetCurrentImpulseContext();
                                    }
                                    this.player.checkMovementStatistics(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5);
                                    this.lastGoodX = this.player.getX();
                                    this.lastGoodY = this.player.getY();
                                    this.lastGoodZ = this.player.getZ();
                                } else {
                                    this.internalTeleport(d3, d4, d5, f, f1);
                                    this.player.doCheckFallDamage(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5, packetplayinflying.isOnGround());
                                    this.player.removeLatestMovementRecording();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean shouldCheckPlayerMovement(boolean flag) {
        if (this.isSingleplayerOwner()) {
            return false;
        }
        if (this.player.isChangingDimension()) {
            return false;
        }
        GameRules gamerules = this.player.level().getGameRules();
        return gamerules.getBoolean(GameRules.RULE_DISABLE_PLAYER_MOVEMENT_CHECK) ? false : !flag || !gamerules.getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK);
    }

    private boolean updateAwaitingTeleport() {
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.awaitingTeleportTime = this.tickCount;
        return false;
    }

    private boolean isEntityCollidingWithAnythingNew(LevelReader iworldreader, net.minecraft.world.entity.Entity entity, AABB axisalignedbb, double d0, double d1, double d2) {
        AABB axisalignedbb1 = entity.getBoundingBox().move(d0 - entity.getX(), d1 - entity.getY(), d2 - entity.getZ());
        Iterable<VoxelShape> iterable = iworldreader.getPreMoveCollisions(entity, axisalignedbb1.deflate(1.0E-5f), axisalignedbb.getBottomCenter());
        VoxelShape voxelshape = Shapes.create(axisalignedbb.deflate(1.0E-5f));
        for (VoxelShape voxelshape1 : iterable) {
            if (Shapes.joinIsNotEmpty(voxelshape1, voxelshape, BooleanOp.AND)) continue;
            return true;
        }
        return false;
    }

    public void teleport(double d0, double d1, double d2, float f, float f1) {
        this.teleport(d0, d1, d2, f, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3(d0, d1, d2), Vec3.ZERO, f, f1), Collections.emptySet(), cause);
    }

    public void teleport(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        this.teleport(positionmoverotation, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation positionmoverotation, Set<Relative> set, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this.player), positionmoverotation, set)).position(), this.getCraftPlayer().getWorld(), absolutePosition.yRot(), absolutePosition.xRot())))) {
            this.internalTeleport(positionmoverotation, set);
            return true;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set = Collections.emptySet();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            positionmoverotation = new PositionMoveRotation(CraftLocation.toVec3D(to), Vec3.ZERO, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(positionmoverotation, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    private void internalTeleport(double d0, double d1, double d2, float f, float f1) {
        this.internalTeleport(new PositionMoveRotation(new Vec3(d0, d1, d2), Vec3.ZERO, f, f1), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        if (Float.isNaN(positionmoverotation.yRot())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.position(), positionmoverotation.deltaMovement(), 0.0f, positionmoverotation.xRot());
        }
        if (Float.isNaN(positionmoverotation.xRot())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.position(), positionmoverotation.deltaMovement(), positionmoverotation.yRot(), 0.0f);
        }
        this.justTeleported = true;
        this.awaitingTeleportTime = this.tickCount;
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.player.teleportSetPosition(positionmoverotation, set);
        this.awaitingPositionFromClient = this.player.position();
        this.lastPosX = this.awaitingPositionFromClient.x;
        this.lastPosY = this.awaitingPositionFromClient.y;
        this.lastPosZ = this.awaitingPositionFromClient.z;
        this.lastYaw = this.player.getYRot();
        this.lastPitch = this.player.getXRot();
        this.send(ClientboundPlayerPositionPacket.of(this.awaitingTeleport, positionmoverotation, set));
    }

    @Override
    public void handlePlayerAction(ServerboundPlayerActionPacket packetplayinblockdig) {
        PacketUtils.ensureRunningOnSameThread(packetplayinblockdig, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            BlockPos blockposition = packetplayinblockdig.getPos();
            this.player.resetLastActionTime();
            ServerboundPlayerActionPacket.Action packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.getAction();
            switch (packetplayinblockdig_enumplayerdigtype) {
                case SWAP_ITEM_WITH_OFFHAND: {
                    if (!this.player.isSpectator()) {
                        ItemStack itemstack = this.player.getItemInHand(InteractionHand.OFF_HAND);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.player.getItemInHand(InteractionHand.MAIN_HAND));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.player.setItemInHand(InteractionHand.OFF_HAND, this.player.getItemInHand(InteractionHand.MAIN_HAND));
                        } else {
                            this.player.setItemInHand(InteractionHand.OFF_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.player.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
                        } else {
                            this.player.setItemInHand(InteractionHand.MAIN_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.player.stopUsingItem();
                    }
                    return;
                }
                case DROP_ITEM: {
                    if (!this.player.isSpectator()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                LOGGER.warn(this.player.getScoreboardName() + " dropped their items too quickly!");
                                this.disconnect(Component.literal("You dropped your items too quickly (Hacking?)"));
                                return;
                            }
                        }
                        this.player.drop(false);
                    }
                    return;
                }
                case DROP_ALL_ITEMS: {
                    if (!this.player.isSpectator()) {
                        this.player.drop(true);
                    }
                    return;
                }
                case RELEASE_USE_ITEM: {
                    this.player.releaseUsingItem();
                    return;
                }
                case START_DESTROY_BLOCK: 
                case ABORT_DESTROY_BLOCK: 
                case STOP_DESTROY_BLOCK: {
                    this.player.gameMode.handleBlockBreakAction(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.getDirection(), this.player.level().getMaxY(), packetplayinblockdig.getSequence());
                    this.ackBlockChangesUpTo(packetplayinblockdig.getSequence());
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer entityplayer, ItemStack itemstack) {
        BucketItem itembucket;
        if (itemstack.isEmpty()) {
            return false;
        }
        Item item = itemstack.getItem();
        if ((item instanceof BlockItem || item instanceof BucketItem && (itembucket = (BucketItem)item).getContent() != Fluids.EMPTY) && !entityplayer.getCooldowns().isOnCooldown(itemstack)) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    @Override
    public void handleUseItemOn(ServerboundUseItemOnPacket packetplayinuseitem) {
        PacketUtils.ensureRunningOnSameThread(packetplayinuseitem, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            this.ackBlockChangesUpTo(packetplayinuseitem.getSequence());
            ServerLevel worldserver = this.player.level();
            InteractionHand enumhand = packetplayinuseitem.getHand();
            ItemStack itemstack = this.player.getItemInHand(enumhand);
            if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                BlockHitResult movingobjectpositionblock = packetplayinuseitem.getHitResult();
                Vec3 vec3d = movingobjectpositionblock.getLocation();
                BlockPos blockposition = movingobjectpositionblock.getBlockPos();
                if (this.player.canInteractWithBlock(blockposition, 1.0)) {
                    Vec3 vec3d1 = vec3d.subtract(Vec3.atCenterOf(blockposition));
                    double d0 = 1.0000001;
                    if (Math.abs(vec3d1.x()) < 1.0000001 && Math.abs(vec3d1.y()) < 1.0000001 && Math.abs(vec3d1.z()) < 1.0000001) {
                        Direction enumdirection = movingobjectpositionblock.getDirection();
                        this.player.resetLastActionTime();
                        int i = this.player.level().getMaxY();
                        if (blockposition.getY() <= i) {
                            if (this.awaitingPositionFromClient == null && worldserver.mayInteract(this.player, blockposition)) {
                                InteractionResult.Success enuminteractionresult_d;
                                this.player.stopUsingItem();
                                InteractionResult enuminteractionresult = this.player.gameMode.useItemOn(this.player, worldserver, itemstack, enumhand, movingobjectpositionblock);
                                if (enuminteractionresult.consumesAction()) {
                                    CriteriaTriggers.ANY_BLOCK_USE.trigger(this.player, movingobjectpositionblock.getBlockPos(), itemstack.copy());
                                }
                                if (enumdirection == Direction.UP && !enuminteractionresult.consumesAction() && blockposition.getY() >= i && ServerGamePacketListenerImpl.wasBlockPlacementAttempt(this.player, itemstack)) {
                                    MutableComponent ichatbasecomponent = Component.translatable("build.tooHigh", i).withStyle(ChatFormatting.RED);
                                    this.player.sendSystemMessage(ichatbasecomponent, true);
                                } else if (enuminteractionresult instanceof InteractionResult.Success && (enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult).swingSource() == InteractionResult.SwingSource.SERVER) {
                                    this.player.swing(enumhand, true);
                                }
                            }
                        } else {
                            MutableComponent ichatbasecomponent1 = Component.translatable("build.tooHigh", i).withStyle(ChatFormatting.RED);
                            this.player.sendSystemMessage(ichatbasecomponent1, true);
                        }
                        this.send(new ClientboundBlockUpdatePacket(worldserver, blockposition));
                        this.send(new ClientboundBlockUpdatePacket(worldserver, blockposition.relative(enumdirection)));
                    } else {
                        LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().name(), vec3d, blockposition});
                    }
                }
            }
        }
    }

    @Override
    public void handleUseItem(ServerboundUseItemPacket packetplayinblockplace) {
        PacketUtils.ensureRunningOnSameThread(packetplayinblockplace, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            this.ackBlockChangesUpTo(packetplayinblockplace.getSequence());
            ServerLevel worldserver = this.player.level();
            InteractionHand enumhand = packetplayinblockplace.getHand();
            ItemStack itemstack = this.player.getItemInHand(enumhand);
            this.player.resetLastActionTime();
            if (!itemstack.isEmpty() && itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                InteractionResult.Success enuminteractionresult_d;
                boolean cancelled;
                float f = Mth.wrapDegrees(packetplayinblockplace.getYRot());
                float f1 = Mth.wrapDegrees(packetplayinblockplace.getXRot());
                if (f1 != this.player.getXRot() || f != this.player.getYRot()) {
                    this.player.absSnapRotationTo(f, f1);
                }
                double d0 = this.player.getX();
                double d1 = this.player.getY() + (double)this.player.getEyeHeight();
                double d2 = this.player.getZ();
                Vec3 vec3d = new Vec3(d0, d1, d2);
                float f3 = Mth.cos(-f * ((float)Math.PI / 180) - (float)Math.PI);
                float f4 = Mth.sin(-f * ((float)Math.PI / 180) - (float)Math.PI);
                float f5 = -Mth.cos(-f1 * ((float)Math.PI / 180));
                float f6 = Mth.sin(-f1 * ((float)Math.PI / 180));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.player.blockInteractionRange();
                Vec3 vec3d1 = vec3d.add((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                BlockHitResult movingobjectposition = this.player.level().clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.player));
                if (movingobjectposition == null || ((HitResult)movingobjectposition).getType() != HitResult.Type.BLOCK) {
                    PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    PlayerInteractEvent event;
                    BlockHitResult movingobjectpositionblock = movingobjectposition;
                    cancelled = this.player.gameMode.firedInteract && this.player.gameMode.interactPosition.equals(movingobjectpositionblock.getBlockPos()) && this.player.gameMode.interactHand == enumhand && ItemStack.isSameItemSameComponents(this.player.gameMode.interactItemStack, itemstack) ? this.player.gameMode.interactResult : (event = CraftEventFactory.callPlayerInteractEvent((Player)this.player, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, true, enumhand, movingobjectpositionblock.getLocation())).useItemInHand() == Event.Result.DENY;
                    this.player.gameMode.firedInteract = false;
                }
                if (cancelled) {
                    this.player.getBukkitEntity().updateInventory();
                    return;
                }
                itemstack = this.player.getItemInHand(enumhand);
                if (itemstack.isEmpty()) {
                    return;
                }
                InteractionResult enuminteractionresult = this.player.gameMode.useItem(this.player, worldserver, itemstack, enumhand);
                if (enuminteractionresult instanceof InteractionResult.Success && (enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult).swingSource() == InteractionResult.SwingSource.SERVER) {
                    this.player.swing(enumhand, true);
                }
            }
        }
    }

    @Override
    public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket packetplayinspectate) {
        PacketUtils.ensureRunningOnSameThread(packetplayinspectate, this, this.player.level());
        if (this.player.isSpectator()) {
            for (ServerLevel worldserver : this.server.getAllLevels()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.getEntity(worldserver);
                if (entity == null) continue;
                this.player.teleportTo(worldserver, entity.getX(), entity.getY(), entity.getZ(), Set.of(), entity.getYRot(), entity.getXRot(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(ServerboundPaddleBoatPacket packetplayinboatmove) {
        PacketUtils.ensureRunningOnSameThread(packetplayinboatmove, this, this.player.level());
        net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractboat = (AbstractBoat)entity;
            abstractboat.setPaddleState(packetplayinboatmove.getLeft(), packetplayinboatmove.getRight());
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        LOGGER.info("{} lost connection: {}", (Object)this.player.getPlainTextName(), (Object)disconnectiondetails.reason().getString());
        this.removePlayerFromWorld();
        super.onDisconnect(disconnectiondetails);
    }

    private void removePlayerFromWorld() {
        this.chatMessageChain.close();
        this.player.disconnect();
        String quitMessage = this.server.getPlayerList().remove(this.player);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.server.getPlayerList().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(i, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(ServerboundSetCarriedItemPacket packetplayinhelditemslot) {
        PacketUtils.ensureRunningOnSameThread(packetplayinhelditemslot, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (packetplayinhelditemslot.getSlot() >= 0 && packetplayinhelditemslot.getSlot() < net.minecraft.world.entity.player.Inventory.getSelectionSize()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((org.bukkit.entity.Player)this.getCraftPlayer(), this.player.getInventory().getSelectedSlot(), packetplayinhelditemslot.getSlot());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.send(new ClientboundSetHeldSlotPacket(this.player.getInventory().getSelectedSlot()));
                this.player.resetLastActionTime();
                return;
            }
            if (this.player.getInventory().getSelectedSlot() != packetplayinhelditemslot.getSlot() && this.player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
                this.player.stopUsingItem();
            }
            this.player.getInventory().setSelectedSlot(packetplayinhelditemslot.getSlot());
            this.player.resetLastActionTime();
        } else {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getPlainTextName());
            this.disconnect(Component.literal("Invalid hotbar selection (Hacking?)"));
        }
    }

    @Override
    public void handleChat(ServerboundChatPacket packetplayinchat) {
        if (this.server.isStopped()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packetplayinchat.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packetplayinchat.message(), false, () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.getSignedMessage(packetplayinchat, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.DecodeException signedmessagechain_a) {
                    this.handleMessageDecodeFailure(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.filterTextPacket(playerchatmessage.signedContent()).thenApplyAsync(Function.identity(), (Executor)this.server.chatExecutor);
                Component ichatbasecomponent = this.server.getChatDecorator().decorate(this.player, playerchatmessage.decoratedContent());
                this.chatMessageChain.append(completablefuture, filteredtext -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.withUnsignedContent(ichatbasecomponent).filter(filteredtext.mask());
                    this.broadcastChatMessage(playerchatmessage1);
                });
            }, false);
        }
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        this.tryHandleChat(serverboundchatcommandpacket.command(), true, () -> {
            if (this.player.hasDisconnected()) {
                return;
            }
            this.performUnsignedChatCommand(serverboundchatcommandpacket.command());
            this.detectRateSpam();
        }, true);
    }

    private void performUnsignedChatCommand(String s) {
        String command = "/" + s;
        LOGGER.info(this.player.getScoreboardName() + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        s = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseresults = this.parseCommand(s);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments(parseresults)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().name(), (Object)s);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
        } else {
            this.server.getCommands().performCommand(parseresults, s);
        }
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket) {
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(serverboundchatcommandsignedpacket.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(serverboundchatcommandsignedpacket.command(), true, () -> {
                if (this.player.hasDisconnected()) {
                    return;
                }
                this.performSignedChatCommand(serverboundchatcommandsignedpacket, (LastSeenMessages)optional.get());
                this.detectRateSpam();
            }, true);
        }
    }

    private void performSignedChatCommand(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + serverboundchatcommandsignedpacket.command();
        LOGGER.info(this.player.getScoreboardName() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseresults = this.parseCommand((String)command);
        try {
            map = serverboundchatcommandsignedpacket.command().equals(command) ? this.collectSignedArguments(serverboundchatcommandsignedpacket, SignableCommand.of(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.DecodeException signedmessagechain_a) {
            this.handleMessageDecodeFailure(signedmessagechain_a);
            return;
        }
        CommandSigningContext.SignedArguments commandsigningcontext = new CommandSigningContext.SignedArguments(map);
        parseresults = Commands.mapSource(parseresults, commandlistenerwrapper -> commandlistenerwrapper.withSigningContext(commandsigningcontext, this.chatMessageChain));
        this.server.getCommands().performCommand(parseresults, (String)command);
    }

    private void handleMessageDecodeFailure(SignedMessageChain.DecodeException signedmessagechain_a) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().name(), (Object)signedmessagechain_a.getComponent().getString());
        this.player.sendSystemMessage(signedmessagechain_a.getComponent().copy().withStyle(ChatFormatting.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, SignableCommand<S> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.DecodeException {
        List<ArgumentSignatures.Entry> list = serverboundchatcommandsignedpacket.argumentSignatures().entries();
        List<SignableCommand.Argument<S>> list1 = signablecommand.arguments();
        if (list.isEmpty()) {
            return this.collectUnsignedArguments(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.Entry entry : list) {
            SignableCommand.Argument<S> signablecommand_a = signablecommand.getArgument(entry.name());
            if (signablecommand_a == null) {
                this.signedMessageDecoder.setChainBroken();
                throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(serverboundchatcommandsignedpacket.command(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.value(), serverboundchatcommandsignedpacket.timeStamp(), serverboundchatcommandsignedpacket.salt(), lastseenmessages);
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(entry.signature(), signedmessagebody));
        }
        for (SignableCommand.Argument argument : list1) {
            if (map.containsKey(argument.name())) continue;
            throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(serverboundchatcommandsignedpacket.command(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.Argument<S>> list) throws SignedMessageChain.DecodeException {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.Argument<S> signablecommand_a : list) {
            SignedMessageBody signedmessagebody = SignedMessageBody.unsigned(signablecommand_a.value());
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.DecodeException createSignedArgumentMismatchException(String s, List<ArgumentSignatures.Entry> list, List<SignableCommand.Argument<S>> list1) {
        String s1 = list.stream().map(ArgumentSignatures.Entry::name).collect(Collectors.joining(", "));
        String s2 = list1.stream().map(SignableCommand.Argument::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{s, s1, s2});
        return new SignedMessageChain.DecodeException(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandSourceStack> parseCommand(String s) {
        CommandDispatcher<CommandSourceStack> commanddispatcher = this.server.getCommands().getDispatcher();
        return commanddispatcher.parse(s, this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String s, boolean flag, Runnable runnable, boolean sync) {
        if (ServerGamePacketListenerImpl.isChatMessageIllegal(s)) {
            this.disconnect(Component.translatable("multiplayer.disconnect.illegal_characters"));
        } else if (this.player.isRemoved() || !flag && this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED), false));
        } else {
            this.player.resetLastActionTime();
            if (sync) {
                this.server.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.Update lastseenmessages_b) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional;
            try {
                LastSeenMessages lastseenmessages = this.lastSeenMessages.applyUpdate(lastseenmessages_b);
                optional = Optional.of(lastseenmessages);
            }
            catch (LastSeenMessagesValidator.ValidationException lastseenmessagesvalidator_a) {
                LOGGER.error("Failed to validate message acknowledgements from {}: {}", (Object)this.player.getPlainTextName(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.disconnect(CHAT_VALIDATION_FAILED);
                return Optional.empty();
            }
            return optional;
        }
    }

    private static boolean isChatMessageIllegal(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isAllowedChatCharacter(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s, final PlayerChatMessage original, boolean async) {
        if (s.isEmpty() || this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.create(original);
        if (!async && s.startsWith("/")) {
            this.handleCommand(s);
        } else if (this.player.getChatVisibility() != ChatVisiblity.SYSTEM) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (org.bukkit.entity.Player)player, s, (Set)new LazyPlayerSet(this.server));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((org.bukkit.entity.Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                ServerGamePacketListenerImpl.this.server.getPlayerList().broadcastChatMessage(original, ServerGamePacketListenerImpl.this.player, ChatType.bind(ChatType.CHAT, ServerGamePacketListenerImpl.this.player));
                                return null;
                            }
                            for (ServerPlayer recipient : ServerGamePacketListenerImpl.this.server.getPlayerList().players) {
                                recipient.getBukkitEntity().sendMessage(ServerGamePacketListenerImpl.this.player.getUUID(), message);
                            }
                        } else {
                            for (org.bukkit.entity.Player player : queueEvent.getRecipients()) {
                                player.sendMessage(ServerGamePacketListenerImpl.this.player.getUUID(), message);
                            }
                        }
                        ServerGamePacketListenerImpl.this.server.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.server.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception processing chat event", e.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.server.getPlayerList().broadcastChatMessage(original, this.player, ChatType.bind(ChatType.CHAT, this.player));
                        return;
                    }
                    for (ServerPlayer recipient : this.server.getPlayerList().players) {
                        recipient.getBukkitEntity().sendMessage(this.player.getUUID(), s);
                    }
                } else {
                    for (org.bukkit.entity.Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.player.getUUID(), s);
                    }
                }
                this.server.console.sendMessage(s);
            }
        }
    }

    private void handleCommand(String s) {
        LOGGER.info(this.player.getScoreboardName() + " issued server command: " + s);
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)player, s, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(ServerGamePacketListenerImpl.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    private PlayerChatMessage getSignedMessage(ServerboundChatPacket packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.DecodeException {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.message(), packetplayinchat.timeStamp(), packetplayinchat.salt(), lastseenmessages);
        return this.signedMessageDecoder.unpack(packetplayinchat.signature(), signedmessagebody);
    }

    private void broadcastChatMessage(PlayerChatMessage playerchatmessage) {
        String s = playerchatmessage.signedContent();
        if (s.isEmpty()) {
            LOGGER.warn(this.player.getScoreboardName() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s;
            this.server.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    ServerGamePacketListenerImpl.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.player.getChatVisibility() == ChatVisiblity.SYSTEM) {
            this.send(new ClientboundSystemChatPacket(Component.translatable("chat.cannotSend").withStyle(ChatFormatting.RED), false));
        } else {
            this.chat(s, playerchatmessage, true);
        }
        this.detectRateSpam();
    }

    private void detectRateSpam() {
        if (!(this.chatSpamThrottler.isIncrementAndUnderThreshold() || this.server.getPlayerList().isOp(this.player.nameAndId()) || this.server.isSingleplayerOwner(this.player.nameAndId()))) {
            this.disconnect(Component.translatable("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.lastSeenMessages.applyOffset(serverboundchatackpacket.offset());
            }
            catch (LastSeenMessagesValidator.ValidationException lastseenmessagesvalidator_a) {
                LOGGER.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.player.getPlainTextName(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(ServerboundSwingPacket packetplayinarmanimation) {
        Block block;
        PacketUtils.ensureRunningOnSameThread(packetplayinarmanimation, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        float f1 = this.player.getXRot();
        float f2 = this.player.getYRot();
        double d0 = this.player.getX();
        double d1 = this.player.getY() + (double)this.player.getEyeHeight();
        double d2 = this.player.getZ();
        Location origin = new Location((World)this.player.level().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.player.blockInteractionRange(), this.player.entityInteractionRange());
        RayTraceResult result = this.player.level().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.player.getBukkitEntity() && this.player.getBukkitEntity().canSee((Entity)entity) && !handle.isSpectator() && handle.isPickable() && !handle.isPassengerOfSameVehicle(this.player);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
        } else if (this.player.gameMode.getGameModeForPlayer() == GameType.ADVENTURE && (block = result.getHitBlock()) != null) {
            Vector hitPosition = result.getHitPosition().subtract(block.getLocation().toVector());
            CraftEventFactory.callPlayerInteractEvent((Player)this.player, Action.LEFT_CLICK_BLOCK, block, result.getHitBlockFace(), this.player.getInventory().getSelectedItem(), true, InteractionHand.MAIN_HAND, hitPosition);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packetplayinarmanimation.getHand() == InteractionHand.MAIN_HAND ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.player.swing(packetplayinarmanimation.getHand());
    }

    @Override
    public void handlePlayerCommand(ServerboundPlayerCommandPacket packetplayinentityaction) {
        PacketUtils.ensureRunningOnSameThread(packetplayinentityaction, this, this.player.level());
        if (this.player.hasClientLoaded()) {
            if (this.player.isRemoved()) {
                return;
            }
            switch (packetplayinentityaction.getAction()) {
                case START_SPRINTING: 
                case STOP_SPRINTING: {
                    PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packetplayinentityaction.getAction() == ServerboundPlayerCommandPacket.Action.START_SPRINTING);
                    this.cserver.getPluginManager().callEvent((Event)e2);
                    if (!e2.isCancelled()) break;
                    return;
                }
            }
            this.player.resetLastActionTime();
            switch (packetplayinentityaction.getAction()) {
                case START_SPRINTING: {
                    this.player.setSprinting(true);
                    break;
                }
                case STOP_SPRINTING: {
                    this.player.setSprinting(false);
                    break;
                }
                case STOP_SLEEPING: {
                    if (!this.player.isSleeping()) break;
                    this.player.stopSleepInBed(false, true);
                    this.awaitingPositionFromClient = this.player.position();
                    break;
                }
                case START_RIDING_JUMP: {
                    net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                    if (!(entity instanceof PlayerRideableJumping)) break;
                    PlayerRideableJumping ijumpable = (PlayerRideableJumping)((Object)entity);
                    int i = packetplayinentityaction.getData();
                    if (!ijumpable.canJump() || i <= 0) break;
                    ijumpable.handleStartJump(i);
                    break;
                }
                case STOP_RIDING_JUMP: {
                    net.minecraft.world.entity.Entity entity1 = this.player.getControlledVehicle();
                    if (!(entity1 instanceof PlayerRideableJumping)) break;
                    PlayerRideableJumping ijumpable1 = (PlayerRideableJumping)((Object)entity1);
                    ijumpable1.handleStopJump();
                    break;
                }
                case OPEN_INVENTORY: {
                    net.minecraft.world.entity.Entity entity2 = this.player.getVehicle();
                    if (!(entity2 instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity2);
                    hascustominventoryscreen.openCustomInventoryScreen(this.player);
                    break;
                }
                case START_FALL_FLYING: {
                    if (this.player.tryToStartFallFlying()) break;
                    this.player.stopFallFlying();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlayerChatMessage(PlayerChatMessage playerchatmessage, ChatType.Bound chatmessagetype_a) {
        if (!this.getCraftPlayer().canSeePlayer(playerchatmessage.link().sender())) {
            this.sendDisguisedChatMessage(playerchatmessage.decoratedContent(), chatmessagetype_a);
            return;
        }
        this.send(new ClientboundPlayerChatPacket(this.nextChatIndex++, playerchatmessage.link().sender(), playerchatmessage.link().index(), playerchatmessage.signature(), playerchatmessage.signedBody().pack(this.messageSignatureCache), playerchatmessage.unsignedContent(), playerchatmessage.filterMask(), chatmessagetype_a));
        MessageSignature messagesignature = playerchatmessage.signature();
        if (messagesignature != null) {
            int i;
            this.messageSignatureCache.push(playerchatmessage.signedBody(), playerchatmessage.signature());
            LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
            synchronized (lastSeenMessagesValidator) {
                this.lastSeenMessages.addPending(messagesignature);
                i = this.lastSeenMessages.trackedMessagesCount();
            }
            if (i > 4096) {
                this.disconnect(Component.translatable("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void sendDisguisedChatMessage(Component ichatbasecomponent, ChatType.Bound chatmessagetype_a) {
        this.send(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.connection.send(new ClientboundPongResponsePacket(serverboundpingrequestpacket.getTime()));
    }

    @Override
    public void handleInteract(ServerboundInteractPacket packetplayinuseentity) {
        PacketUtils.ensureRunningOnSameThread(packetplayinuseentity, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        if (this.player.hasClientLoaded()) {
            final ServerLevel worldserver = this.player.level();
            final net.minecraft.world.entity.Entity entity = packetplayinuseentity.getTarget(worldserver);
            this.player.resetLastActionTime();
            this.player.setShiftKeyDown(packetplayinuseentity.isUsingSecondaryAction());
            if (entity != null) {
                if (!worldserver.getWorldBorder().isWithinBounds(entity.blockPosition())) {
                    return;
                }
                AABB axisalignedbb = entity.getBoundingBox();
                if (this.player.canInteractWithEntity(axisalignedbb, 3.0)) {
                    packetplayinuseentity.dispatch(new ServerboundInteractPacket.Handler(){

                        private void performInteraction(InteractionHand enumhand, EntityInteraction playerconnection_a, PlayerInteractEntityEvent event) {
                            ItemStack itemstack = ServerGamePacketListenerImpl.this.player.getItemInHand(enumhand);
                            if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                                ItemStack itemstack1 = itemstack.copy();
                                ItemStack itemInHand = ServerGamePacketListenerImpl.this.player.getItemInHand(enumhand);
                                boolean triggerLeashUpdate = itemInHand != null && itemInHand.getItem() == Items.LEAD && entity instanceof Mob;
                                Item origItem = ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem() == null ? null : ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem().getItem();
                                ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                                if (entity instanceof Bucketable && entity instanceof LivingEntity && origItem != null && origItem.asItem() == Items.WATER_BUCKET && (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem().getItem() != origItem)) {
                                    entity.getBukkitEntity().update(ServerGamePacketListenerImpl.this.player);
                                    ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                }
                                if (triggerLeashUpdate && (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem().getItem() != origItem)) {
                                    ServerGamePacketListenerImpl.this.send(new ClientboundSetEntityLinkPacket(entity, ((Mob)entity).getLeashHolder()));
                                }
                                if (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelectedItem().getItem() != origItem) {
                                    entity.refreshEntityData(ServerGamePacketListenerImpl.this.player);
                                    if (entity instanceof Allay) {
                                        ServerGamePacketListenerImpl.this.send(new ClientboundSetEquipmentPacket(entity.getId(), Arrays.stream(net.minecraft.world.entity.EquipmentSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((LivingEntity)entity).getItemBySlot((net.minecraft.world.entity.EquipmentSlot)slot).copy())).collect(Collectors.toList())));
                                        ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                InteractionResult enuminteractionresult = playerconnection_a.run(ServerGamePacketListenerImpl.this.player, entity, enumhand);
                                if (!itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                                    ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                }
                                if (enuminteractionresult instanceof InteractionResult.Success) {
                                    InteractionResult.Success enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult;
                                    ItemStack itemstack2 = enuminteractionresult_d.wasItemInteraction() ? itemstack1 : ItemStack.EMPTY;
                                    CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(ServerGamePacketListenerImpl.this.player, itemstack2, entity);
                                    if (enuminteractionresult_d.swingSource() == InteractionResult.SwingSource.SERVER) {
                                        ServerGamePacketListenerImpl.this.player.swing(enumhand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void onInteraction(InteractionHand enumhand) {
                            this.performInteraction(enumhand, Player::interactOn, new PlayerInteractEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void onInteraction(InteractionHand enumhand, Vec3 vec3d) {
                            this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.interactAt(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.x, vec3d.y, vec3d.z), enumhand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void onAttack() {
                            AbstractArrow entityarrow;
                            if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity == ServerGamePacketListenerImpl.this.player && !ServerGamePacketListenerImpl.this.player.isSpectator() || entity instanceof AbstractArrow && !(entityarrow = (AbstractArrow)entity).isAttackable())) {
                                ItemStack itemstack = ServerGamePacketListenerImpl.this.player.getItemInHand(InteractionHand.MAIN_HAND);
                                if (!itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                                    return;
                                }
                                ServerGamePacketListenerImpl.this.player.attack(entity);
                                if (!itemstack.isEmpty() && itemstack.getCount() <= -1) {
                                    ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                }
                                return;
                            }
                            ServerGamePacketListenerImpl.this.disconnect(Component.translatable("multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.player.getPlainTextName());
                        }
                    });
                }
            }
        }
    }

    @Override
    public void handleClientCommand(ServerboundClientCommandPacket packetplayinclientcommand) {
        PacketUtils.ensureRunningOnSameThread(packetplayinclientcommand, this, this.player.level());
        this.player.resetLastActionTime();
        ServerboundClientCommandPacket.Action packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.getAction();
        switch (packetplayinclientcommand_enumclientcommand) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true, Entity.RemovalReason.CHANGED_DIMENSION, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.resetPosition();
                    CriteriaTriggers.CHANGED_DIMENSION.trigger(this.player, net.minecraft.world.level.Level.END, net.minecraft.world.level.Level.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.DEATH);
                this.resetPosition();
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(GameType.SPECTATOR);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.player.level());
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(ServerboundContainerClosePacket packetplayinclosewindow) {
        PacketUtils.ensureRunningOnSameThread(packetplayinclosewindow, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.player);
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(ServerboundContainerClickPacket packetplayinwindowclick) {
        PacketUtils.ensureRunningOnSameThread(packetplayinwindowclick, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packetplayinwindowclick.containerId() && this.player.containerMenu.stillValid(this.player)) {
            boolean cancelled = this.player.isSpectator();
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                short i = packetplayinwindowclick.slotNum();
                if (!this.player.containerMenu.isValidSlotIndex(i)) {
                    LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getPlainTextName(), (int)i, this.player.containerMenu.slots.size()});
                } else {
                    boolean flag = packetplayinwindowclick.stateId() != this.player.containerMenu.getStateId();
                    this.player.containerMenu.suppressRemoteUpdates();
                    if (packetplayinwindowclick.slotNum() < -1 && packetplayinwindowclick.slotNum() != -999) {
                        return;
                    }
                    InventoryView inventory = this.player.containerMenu.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)packetplayinwindowclick.slotNum());
                    org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.EMPTY;
                    switch (packetplayinwindowclick.clickType()) {
                        case PICKUP: {
                            if (packetplayinwindowclick.buttonNum() == 0) {
                                click = org.bukkit.event.inventory.ClickType.LEFT;
                            } else if (packetplayinwindowclick.buttonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.buttonNum() != 0 && packetplayinwindowclick.buttonNum() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.slotNum() == -999) {
                                if (this.player.containerMenu.getCarried().isEmpty()) break;
                                action = packetplayinwindowclick.buttonNum() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.slotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.getItem();
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            if (clickedItem.isEmpty()) {
                                if (cursor.isEmpty()) break;
                                action = packetplayinwindowclick.buttonNum() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.mayPickup(this.player)) break;
                            if (cursor.isEmpty()) {
                                action = packetplayinwindowclick.buttonNum() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.mayPlace(cursor)) {
                                if (ItemStack.isSameItemSameComponents(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.buttonNum() == 0 ? cursor.getCount() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.getMaxStackSize() - clickedItem.getCount());
                                    if ((toPlace = Math.min(toPlace, slot.container.getMaxStackSize() - clickedItem.getCount())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.getCount()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.getCount() > slot.getMaxStackSize()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.isSameItemSameComponents(cursor, clickedItem) || clickedItem.getCount() < 0 || clickedItem.getCount() + cursor.getCount() > cursor.getMaxStackSize()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case QUICK_MOVE: {
                            if (packetplayinwindowclick.buttonNum() == 0) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.buttonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.buttonNum() != 0 && packetplayinwindowclick.buttonNum() != 1) break;
                            if (packetplayinwindowclick.slotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                            if (slot != null && slot.mayPickup(this.player) && slot.hasItem()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case SWAP: {
                            if ((packetplayinwindowclick.buttonNum() < 0 || packetplayinwindowclick.buttonNum() >= 9) && packetplayinwindowclick.buttonNum() != 40) break;
                            click = packetplayinwindowclick.buttonNum() == 40 ? org.bukkit.event.inventory.ClickType.SWAP_OFFHAND : org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                            if (clickedSlot.mayPickup(this.player)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.player.getInventory().getItem(packetplayinwindowclick.buttonNum());
                                boolean bl = canCleanSwap = hotbar.isEmpty() || clickedSlot.container == this.player.getInventory() && clickedSlot.mayPlace(hotbar);
                                if (clickedSlot.hasItem()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.hasItem() && !hotbar.isEmpty() && clickedSlot.mayPlace(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case CLONE: {
                            Slot slot;
                            if (packetplayinwindowclick.buttonNum() == 2) {
                                click = org.bukkit.event.inventory.ClickType.MIDDLE;
                                if (packetplayinwindowclick.slotNum() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                                if (slot != null && slot.hasItem() && this.player.getAbilities().instabuild && this.player.containerMenu.getCarried().isEmpty()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case THROW: {
                            Slot slot;
                            if (packetplayinwindowclick.slotNum() >= 0) {
                                if (packetplayinwindowclick.buttonNum() == 0) {
                                    click = org.bukkit.event.inventory.ClickType.DROP;
                                    slot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                                    if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.buttonNum() != 1) break;
                                click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                                slot = this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum());
                                if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.LEFT;
                            if (packetplayinwindowclick.buttonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case PICKUP_ALL: {
                            click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.slotNum() < 0 || this.player.containerMenu.getCarried().isEmpty()) break;
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.clickType() == ClickType.QUICK_CRAFT || this.player.containerMenu.quickcraftStatus != 0) {
                        this.player.containerMenu.clicked(packetplayinwindowclick.slotNum(), packetplayinwindowclick.buttonNum(), packetplayinwindowclick.clickType(), this.player);
                    } else if (packetplayinwindowclick.clickType() != ClickType.QUICK_CRAFT) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.slotNum(), click, action, (int)packetplayinwindowclick.buttonNum()) : new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.slotNum(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.slotNum() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.slotNum(), click, action, (int)packetplayinwindowclick.buttonNum()) : new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.slotNum(), click, action);
                        }
                        if (packetplayinwindowclick.slotNum() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.slotNum(), click, action, (int)packetplayinwindowclick.buttonNum()) : new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.slotNum(), click, action);
                        }
                        event.setCancelled(cancelled);
                        AbstractContainerMenu oldContainer = this.player.containerMenu;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.player.containerMenu != oldContainer) {
                            return;
                        }
                        block8 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.player.containerMenu.clicked(i, packetplayinwindowclick.buttonNum(), packetplayinwindowclick.clickType(), this.player);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.player.containerMenu.sendAllDataToRemote();
                                        break block8;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packetplayinwindowclick.slotNum(), this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum()).getItem()));
                                        break block8;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packetplayinwindowclick.slotNum(), this.player.containerMenu.getSlot(packetplayinwindowclick.slotNum()).getItem()));
                                        break block8;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        break block8;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.player.containerMenu.sendAllDataToRemote();
                        }
                    }
                    for (Int2ObjectMap.Entry int2objectmap_entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.changedSlots())) {
                        this.player.containerMenu.setRemoteSlotUnsafe(int2objectmap_entry.getIntKey(), (HashedStack)int2objectmap_entry.getValue());
                    }
                    this.player.containerMenu.setRemoteCarried(packetplayinwindowclick.carriedItem());
                    this.player.containerMenu.resumeRemoteUpdates();
                    if (flag) {
                        this.player.containerMenu.broadcastFullState();
                    } else {
                        this.player.containerMenu.broadcastChanges();
                    }
                }
            }
        }
    }

    @Override
    public void handlePlaceRecipe(ServerboundPlaceRecipePacket packetplayinautorecipe) {
        PacketUtils.ensureRunningOnSameThread(packetplayinautorecipe, this, this.player.level());
        this.player.resetLastActionTime();
        if (!this.player.isSpectator() && this.player.containerMenu.containerId == packetplayinautorecipe.containerId()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                RecipeManager.ServerDisplayInfo craftingmanager_d = this.server.getRecipeManager().getRecipeFromDisplay(packetplayinautorecipe.recipe());
                if (craftingmanager_d != null) {
                    AbstractContainerMenu container;
                    RecipeHolder recipeholder = craftingmanager_d.parent();
                    if (this.player.getRecipeBook().contains(recipeholder.id()) && (container = this.player.containerMenu) instanceof RecipeBookMenu) {
                        RecipeBookMenu containerrecipebook = (RecipeBookMenu)container;
                        if (recipeholder.value().placementInfo().isImpossibleToPlace()) {
                            LOGGER.debug("Player {} tried to place impossible recipe {}", (Object)this.player, (Object)recipeholder.id().location());
                            return;
                        }
                        Recipe recipe = recipeholder.toBukkitRecipe();
                        if (recipe == null) {
                            return;
                        }
                        PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.player, recipe, packetplayinautorecipe.useMaxItems());
                        recipeholder = this.server.getRecipeManager().byKey(CraftRecipe.toMinecraft(((Keyed)event.getRecipe()).getKey())).orElse(null);
                        if (recipeholder == null) {
                            return;
                        }
                        RecipeBookMenu.PostPlaceAction containerrecipebook_a = containerrecipebook.handlePlacement(event.isShiftClick(), this.player.isCreative(), recipeholder, this.player.level(), this.player.getInventory());
                        if (containerrecipebook_a == RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE) {
                            this.send(new ClientboundPlaceGhostRecipePacket(this.player.containerMenu.containerId, craftingmanager_d.display().display()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleContainerButtonClick(ServerboundContainerButtonClickPacket packetplayinenchantitem) {
        PacketUtils.ensureRunningOnSameThread(packetplayinenchantitem, this, this.player.level());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packetplayinenchantitem.containerId() && !this.player.isSpectator()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                boolean flag = this.player.containerMenu.clickMenuButton(this.player, packetplayinenchantitem.buttonId());
                if (flag) {
                    this.player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    @Override
    public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket packetplayinsetcreativeslot) {
        PacketUtils.ensureRunningOnSameThread(packetplayinsetcreativeslot, this, this.player.level());
        if (this.player.hasInfiniteMaterials()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.slotNum() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.itemStack();
            if (!itemstack.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            boolean flag1 = packetplayinsetcreativeslot.slotNum() >= 1 && packetplayinsetcreativeslot.slotNum() <= 45;
            boolean bl = flag2 = itemstack.isEmpty() || itemstack.getCount() <= itemstack.getMaxStackSize();
            if (flag || flag1 && !ItemStack.matches(this.player.inventoryMenu.getSlot(packetplayinsetcreativeslot.slotNum()).getItem(), packetplayinsetcreativeslot.itemStack())) {
                CraftInventoryView inventory = this.player.inventoryMenu.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.itemStack());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.slotNum() < 36) {
                    type = packetplayinsetcreativeslot.slotNum() >= 5 && packetplayinsetcreativeslot.slotNum() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packetplayinsetcreativeslot.slotNum(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.slotNum() >= 0) {
                            this.player.inventoryMenu.sendAllDataToRemote();
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.player.inventoryMenu.getSlot(packetplayinsetcreativeslot.slotNum()).setByPlayer(itemstack);
                this.player.inventoryMenu.setRemoteSlot(packetplayinsetcreativeslot.slotNum(), itemstack);
                this.player.inventoryMenu.broadcastChanges();
            } else if (flag && flag2) {
                if (this.dropSpamThrottler.isUnderThreshold()) {
                    this.dropSpamThrottler.increment();
                    this.player.drop(itemstack, true);
                } else {
                    LOGGER.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.player.getPlainTextName());
                }
            }
        }
    }

    @Override
    public void handleSignUpdate(ServerboundSignUpdatePacket packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.getLines()).map(ChatFormatting::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(list).thenAcceptAsync(list1 -> this.updateSignText(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.server);
    }

    private void updateSignText(ServerboundSignUpdatePacket packetplayinupdatesign, List<FilteredText> list) {
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        ServerLevel worldserver = this.player.level();
        BlockPos blockposition = packetplayinupdatesign.getPos();
        if (worldserver.hasChunkAt(blockposition)) {
            BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
            if (!(tileentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            tileentitysign.updateSignText(this.player, packetplayinupdatesign.isFrontText(), list);
        }
    }

    @Override
    public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket packetplayinabilities) {
        PacketUtils.ensureRunningOnSameThread(packetplayinabilities, this, this.player.level());
        if (this.player.getAbilities().mayfly && this.player.getAbilities().flying != packetplayinabilities.isFlying()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), packetplayinabilities.isFlying());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.player.getAbilities().flying = packetplayinabilities.isFlying();
            } else {
                this.player.onUpdateAbilities();
            }
        }
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundclientinformationpacket, this, this.player.level());
        boolean flag = this.player.isModelPartShown(PlayerModelPart.HAT);
        this.player.updateOptions(serverboundclientinformationpacket.information());
        if (this.player.isModelPartShown(PlayerModelPart.HAT) != flag) {
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_HAT, this.player));
        }
    }

    @Override
    public void handleChangeDifficulty(ServerboundChangeDifficultyPacket packetplayindifficultychange) {
        PacketUtils.ensureRunningOnSameThread(packetplayindifficultychange, this, this.player.level());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            LOGGER.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.player.getGameProfile().name(), (Object)packetplayindifficultychange.difficulty().getDisplayName());
        } else {
            this.server.setDifficulty(packetplayindifficultychange.difficulty(), false);
        }
    }

    @Override
    public void handleChangeGameMode(ServerboundChangeGameModePacket serverboundchangegamemodepacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundchangegamemodepacket, this, this.player.level());
        if (!this.player.hasPermissions(2)) {
            LOGGER.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.player.getGameProfile().name(), (Object)serverboundchangegamemodepacket.mode().getShortDisplayName().getString());
        } else {
            GameModeCommand.setGameMode(this.player, serverboundchangegamemodepacket.mode());
        }
    }

    @Override
    public void handleLockDifficulty(ServerboundLockDifficultyPacket packetplayindifficultylock) {
        PacketUtils.ensureRunningOnSameThread(packetplayindifficultylock, this, this.player.level());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            this.server.setDifficultyLocked(packetplayindifficultylock.isLocked());
        }
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundchatsessionupdatepacket, this, this.player.level());
        RemoteChatSession.Data remotechatsession_a = serverboundchatsessionupdatepacket.chatSession();
        ProfilePublicKey.Data profilepublickey_a = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.Data profilepublickey_a1 = remotechatsession_a.profilePublicKey();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.expiresAt().isBefore(profilepublickey_a.expiresAt())) {
                this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.server.services().profileKeySignatureValidator();
                    if (signaturevalidator == null) {
                        LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().name());
                        return;
                    }
                    this.resetPlayerChatState(remotechatsession_a.validate(this.player.getGameProfile(), signaturevalidator));
                }
                catch (ProfilePublicKey.ValidationException profilepublickey_b) {
                    LOGGER.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.disconnect(profilepublickey_b.getComponent());
                }
            }
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket serverboundconfigurationacknowledgedpacket) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation()), this.player));
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket serverboundchunkbatchreceivedpacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundchunkbatchreceivedpacket, this, this.player.level());
        this.chunkSender.onChunkBatchReceivedByClient(serverboundchunkbatchreceivedpacket.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSubscriptionRequest(ServerboundDebugSubscriptionRequestPacket serverbounddebugsubscriptionrequestpacket) {
        PacketUtils.ensureRunningOnSameThread(serverbounddebugsubscriptionrequestpacket, this, this.player.level());
        this.player.requestDebugSubscriptions(serverbounddebugsubscriptionrequestpacket.subscriptions());
    }

    private void resetPlayerChatState(RemoteChatSession remotechatsession) {
        this.chatSession = remotechatsession;
        this.signedMessageDecoder = remotechatsession.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> {
            this.player.setChatSession(remotechatsession);
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT), List.of(this.player)));
        });
    }

    @Override
    public void handleClientTickEnd(ServerboundClientTickEndPacket serverboundclienttickendpacket) {
        PacketUtils.ensureRunningOnSameThread(serverboundclienttickendpacket, this, this.player.level());
        if (!this.receivedMovementThisTick) {
            this.player.setKnownMovement(Vec3.ZERO);
        }
        this.receivedMovementThisTick = false;
    }

    private void handlePlayerKnownMovement(Vec3 vec3d) {
        if (vec3d.lengthSqr() > (double)1.0E-5f) {
            this.player.resetLastActionTime();
        }
        this.player.setKnownMovement(vec3d);
        this.receivedMovementThisTick = true;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.player.hasInfiniteMaterials();
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }

    @FunctionalInterface
    private static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, net.minecraft.world.entity.Entity var2, InteractionHand var3);
    }
}

