/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.StringUtil;
import org.slf4j.Logger;

public class CachedUserNameToIdResolver
implements UserNameToIdResolver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private boolean resolveOfflineUsers = true;
    private final Map<String, GameProfileInfo> profilesByName = new ConcurrentHashMap<String, GameProfileInfo>();
    private final Map<UUID, GameProfileInfo> profilesByUUID = new ConcurrentHashMap<UUID, GameProfileInfo>();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();

    public CachedUserNameToIdResolver(GameProfileRepository gameprofilerepository, File file) {
        this.profileRepository = gameprofilerepository;
        this.file = file;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo cachedusernametoidresolver_a) {
        NameAndId nameandid = cachedusernametoidresolver_a.nameAndId();
        cachedusernametoidresolver_a.setLastAccess(this.getNextOperation());
        this.profilesByName.put(nameandid.name().toLowerCase(Locale.ROOT), cachedusernametoidresolver_a);
        this.profilesByUUID.put(nameandid.id(), cachedusernametoidresolver_a);
    }

    private Optional<NameAndId> lookupGameProfile(GameProfileRepository gameprofilerepository, String s) {
        if (!StringUtil.isValidPlayerName(s)) {
            return this.createUnknownProfile(s);
        }
        Optional<NameAndId> optional = gameprofilerepository.findProfileByName(s).map(NameAndId::new);
        return optional.isEmpty() ? this.createUnknownProfile(s) : optional;
    }

    private Optional<NameAndId> createUnknownProfile(String s) {
        return this.resolveOfflineUsers ? Optional.of(NameAndId.createOffline(s)) : Optional.empty();
    }

    @Override
    public void resolveOfflineUsers(boolean flag) {
        this.resolveOfflineUsers = flag;
    }

    @Override
    public void add(NameAndId nameandid) {
        this.addInternal(nameandid);
    }

    private GameProfileInfo addInternal(NameAndId nameandid) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        GameProfileInfo cachedusernametoidresolver_a = new GameProfileInfo(nameandid, date);
        this.safeAdd(cachedusernametoidresolver_a);
        this.save();
        return cachedusernametoidresolver_a;
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    @Override
    public Optional<NameAndId> get(String s) {
        Optional<NameAndId> optional;
        String s1 = s.toLowerCase(Locale.ROOT);
        GameProfileInfo cachedusernametoidresolver_a = this.profilesByName.get(s1);
        boolean flag = false;
        if (cachedusernametoidresolver_a != null && new Date().getTime() >= cachedusernametoidresolver_a.expirationDate.getTime()) {
            this.profilesByUUID.remove(cachedusernametoidresolver_a.nameAndId().id());
            this.profilesByName.remove(cachedusernametoidresolver_a.nameAndId().name().toLowerCase(Locale.ROOT));
            flag = true;
            cachedusernametoidresolver_a = null;
        }
        if (cachedusernametoidresolver_a != null) {
            cachedusernametoidresolver_a.setLastAccess(this.getNextOperation());
            optional = Optional.of(cachedusernametoidresolver_a.nameAndId());
        } else {
            Optional<NameAndId> optional1 = this.lookupGameProfile(this.profileRepository, s);
            if (optional1.isPresent()) {
                optional = Optional.of(this.addInternal(optional1.get()).nameAndId());
                flag = false;
            } else {
                optional = Optional.empty();
            }
        }
        if (flag) {
            this.save();
        }
        return optional;
    }

    @Override
    public Optional<NameAndId> get(UUID uuid) {
        GameProfileInfo cachedusernametoidresolver_a = this.profilesByUUID.get(uuid);
        if (cachedusernametoidresolver_a == null) {
            return Optional.empty();
        }
        cachedusernametoidresolver_a.setLastAccess(this.getNextOperation());
        return Optional.of(cachedusernametoidresolver_a.nameAndId());
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<GameProfileInfo> load() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader2222 = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonarray = (JsonArray)this.gson.fromJson((Reader)reader2222, JsonArray.class);
            if (jsonarray == null) {
                ArrayList arrayList = list;
                return arrayList;
            }
            DateFormat dateformat = CachedUserNameToIdResolver.createDateFormat();
            jsonarray.forEach(jsonelement -> {
                Optional<GameProfileInfo> optional = CachedUserNameToIdResolver.readGameProfile(jsonelement, dateformat);
                Objects.requireNonNull(list);
                optional.ifPresent(list::add);
            });
            return list;
        }
        catch (FileNotFoundException reader2222) {
            return list;
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)ioexception);
        }
        return list;
    }

    @Override
    public void save() {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = CachedUserNameToIdResolver.createDateFormat();
        this.getTopMRUProfiles(1000).forEach(cachedusernametoidresolver_a -> jsonarray.add(CachedUserNameToIdResolver.writeGameProfile(cachedusernametoidresolver_a, dateformat)));
        String s = this.gson.toJson((JsonElement)jsonarray);
        try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            writer.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int i) {
        return ImmutableList.copyOf(this.profilesByUUID.values()).stream().sorted(Comparator.comparing(GameProfileInfo::lastAccess).reversed()).limit(i);
    }

    private static JsonElement writeGameProfile(GameProfileInfo cachedusernametoidresolver_a, DateFormat dateformat) {
        JsonObject jsonobject = new JsonObject();
        cachedusernametoidresolver_a.nameAndId().appendTo(jsonobject);
        jsonobject.addProperty("expiresOn", dateformat.format(cachedusernametoidresolver_a.expirationDate()));
        return jsonobject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement jsonelement, DateFormat dateformat) {
        JsonElement jsonelement1;
        JsonObject jsonobject;
        NameAndId nameandid;
        if (jsonelement.isJsonObject() && (nameandid = NameAndId.fromJson(jsonobject = jsonelement.getAsJsonObject())) != null && (jsonelement1 = jsonobject.get("expiresOn")) != null) {
            String s = jsonelement1.getAsString();
            try {
                Date date = dateformat.parse(s);
                return Optional.of(new GameProfileInfo(nameandid, date));
            }
            catch (ParseException parseexception) {
                LOGGER.warn("Failed to parse date {}", (Object)s, (Object)parseexception);
            }
        }
        return Optional.empty();
    }

    private static class GameProfileInfo {
        private final NameAndId nameAndId;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(NameAndId nameandid, Date date) {
            this.nameAndId = nameandid;
            this.expirationDate = date;
        }

        public NameAndId nameAndId() {
            return this.nameAndId;
        }

        public Date expirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long i) {
            this.lastAccess = i;
        }

        public long lastAccess() {
            return this.lastAccess;
        }
    }
}

