/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.rcon.thread.GenericThread;
import net.minecraft.server.rcon.thread.RconClient;
import org.slf4j.Logger;

public class RconThread
extends GenericThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerSocket socket;
    private final String rconPassword;
    private final List<RconClient> clients = Lists.newArrayList();
    private final ServerInterface serverInterface;

    private RconThread(ServerInterface var0, ServerSocket var1, String var2) {
        super("RCON Listener");
        this.serverInterface = var0;
        this.socket = var1;
        this.rconPassword = var2;
    }

    private void clearClients() {
        this.clients.removeIf(var0 -> !var0.isRunning());
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                try {
                    Socket var0 = this.socket.accept();
                    RconClient var1 = new RconClient(this.serverInterface, this.rconPassword, var0);
                    var1.start();
                    this.clients.add(var1);
                    this.clearClients();
                }
                catch (SocketTimeoutException var0) {
                    this.clearClients();
                }
                catch (IOException var0) {
                    if (!this.running) continue;
                    LOGGER.info("IO exception: ", (Throwable)var0);
                }
            }
        }
        finally {
            this.closeSocket(this.socket);
        }
    }

    @Nullable
    public static RconThread create(ServerInterface var0) {
        int var3;
        DedicatedServerProperties var1 = var0.getProperties();
        String var2 = var0.getServerIp();
        if (var2.isEmpty()) {
            var2 = "0.0.0.0";
        }
        if (0 >= (var3 = var1.rconPort) || 65535 < var3) {
            LOGGER.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)var3);
            return null;
        }
        String var4 = var1.rconPassword;
        if (var4.isEmpty()) {
            LOGGER.warn("No rcon password set in server.properties, rcon disabled!");
            return null;
        }
        try {
            ServerSocket var5 = new ServerSocket(var3, 0, InetAddress.getByName(var2));
            var5.setSoTimeout(500);
            RconThread var6 = new RconThread(var0, var5, var4);
            if (!var6.start()) {
                return null;
            }
            LOGGER.info("RCON running on {}:{}", (Object)var2, (Object)var3);
            return var6;
        }
        catch (IOException var5) {
            LOGGER.warn("Unable to initialise RCON on {}:{}", new Object[]{var2, var3, var5});
            return null;
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket(this.socket);
        super.stop();
        for (RconClient var1 : this.clients) {
            if (!var1.isRunning()) continue;
            var1.stop();
        }
        this.clients.clear();
    }

    private void closeSocket(ServerSocket var0) {
        LOGGER.debug("closeSocket: {}", (Object)var0);
        try {
            var0.close();
        }
        catch (IOException var1) {
            LOGGER.warn("Failed to close socket", (Throwable)var1);
        }
    }
}

