/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class Stat<T>
extends ObjectiveCriteria {
    public static final StreamCodec<RegistryFriendlyByteBuf, Stat<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.STAT_TYPE).dispatch(Stat::getType, StatType::streamCodec);
    private final StatFormatter formatter;
    private final T value;
    private final StatType<T> type;

    protected Stat(StatType<T> var0, T var1, StatFormatter var2) {
        super(Stat.buildName(var0, var1));
        this.type = var0;
        this.formatter = var2;
        this.value = var1;
    }

    public static <T> String buildName(StatType<T> var0, T var1) {
        return Stat.locationToKey(BuiltInRegistries.STAT_TYPE.getKey(var0)) + ":" + Stat.locationToKey(var0.getRegistry().getKey(var1));
    }

    private static <T> String locationToKey(@Nullable ResourceLocation var0) {
        return var0.toString().replace(':', '.');
    }

    public StatType<T> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public String format(int var0) {
        return this.formatter.format(var0);
    }

    public boolean equals(Object var0) {
        return this == var0 || var0 instanceof Stat && Objects.equals(this.getName(), ((Stat)var0).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Stat{name=" + this.getName() + ", formatter=" + String.valueOf(this.formatter) + "}";
    }
}

