/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.function.Consumer;

public class StaticCache2D<T> {
    private final int minX;
    private final int minZ;
    private final int sizeX;
    private final int sizeZ;
    private final Object[] cache;

    public static <T> StaticCache2D<T> create(int var0, int var1, int var2, Initializer<T> var3) {
        int var4 = var0 - var2;
        int var5 = var1 - var2;
        int var6 = 2 * var2 + 1;
        return new StaticCache2D<T>(var4, var5, var6, var6, var3);
    }

    private StaticCache2D(int var0, int var1, int var2, int var3, Initializer<T> var4) {
        this.minX = var0;
        this.minZ = var1;
        this.sizeX = var2;
        this.sizeZ = var3;
        this.cache = new Object[this.sizeX * this.sizeZ];
        for (int var5 = var0; var5 < var0 + var2; ++var5) {
            for (int var6 = var1; var6 < var1 + var3; ++var6) {
                this.cache[this.getIndex((int)var5, (int)var6)] = var4.get(var5, var6);
            }
        }
    }

    public void forEach(Consumer<T> var0) {
        for (Object var4 : this.cache) {
            var0.accept(var4);
        }
    }

    public T get(int var0, int var1) {
        if (!this.contains(var0, var1)) {
            throw new IllegalArgumentException("Requested out of range value (" + var0 + "," + var1 + ") from " + String.valueOf(this));
        }
        return (T)this.cache[this.getIndex(var0, var1)];
    }

    public boolean contains(int var0, int var1) {
        int var2 = var0 - this.minX;
        int var3 = var1 - this.minZ;
        return var2 >= 0 && var2 < this.sizeX && var3 >= 0 && var3 < this.sizeZ;
    }

    public String toString() {
        return String.format(Locale.ROOT, "StaticCache2D[%d, %d, %d, %d]", this.minX, this.minZ, this.minX + this.sizeX, this.minZ + this.sizeZ);
    }

    private int getIndex(int var0, int var1) {
        int var2 = var0 - this.minX;
        int var3 = var1 - this.minZ;
        return var2 * this.sizeZ + var3;
    }

    @FunctionalInterface
    public static interface Initializer<T> {
        public T get(int var1, int var2);
    }
}

