/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StrictJsonParser {
    public static JsonElement parse(Reader var0) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader var1 = new JsonReader(var0);
            var1.setStrictness(Strictness.STRICT);
            JsonElement var2 = JsonParser.parseReader((JsonReader)var1);
            if (!var2.isJsonNull() && var1.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return var2;
        }
        catch (MalformedJsonException | NumberFormatException var1) {
            throw new JsonSyntaxException(var1);
        }
        catch (IOException var1) {
            throw new JsonIOException((Throwable)var1);
        }
    }

    public static JsonElement parse(String var0) throws JsonSyntaxException {
        return StrictJsonParser.parse(new StringReader(var0));
    }
}

