/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.datafix.fixes.References;

public enum DataFixTypes {
    LEVEL(References.LEVEL),
    LEVEL_SUMMARY(References.LIGHTWEIGHT_LEVEL),
    PLAYER(References.PLAYER),
    CHUNK(References.CHUNK),
    HOTBAR(References.HOTBAR),
    OPTIONS(References.OPTIONS),
    STRUCTURE(References.STRUCTURE),
    STATS(References.STATS),
    SAVED_DATA_COMMAND_STORAGE(References.SAVED_DATA_COMMAND_STORAGE),
    SAVED_DATA_FORCED_CHUNKS(References.SAVED_DATA_TICKETS),
    SAVED_DATA_MAP_DATA(References.SAVED_DATA_MAP_DATA),
    SAVED_DATA_MAP_INDEX(References.SAVED_DATA_MAP_INDEX),
    SAVED_DATA_RAIDS(References.SAVED_DATA_RAIDS),
    SAVED_DATA_RANDOM_SEQUENCES(References.SAVED_DATA_RANDOM_SEQUENCES),
    SAVED_DATA_SCOREBOARD(References.SAVED_DATA_SCOREBOARD),
    SAVED_DATA_STRUCTURE_FEATURE_INDICES(References.SAVED_DATA_STRUCTURE_FEATURE_INDICES),
    SAVED_DATA_WORLD_BORDER(References.SAVED_DATA_WORLD_BORDER),
    ADVANCEMENTS(References.ADVANCEMENTS),
    POI_CHUNK(References.POI_CHUNK),
    WORLD_GEN_SETTINGS(References.WORLD_GEN_SETTINGS),
    ENTITY_CHUNK(References.ENTITY_CHUNK);

    public static final Set<DSL.TypeReference> TYPES_FOR_LEVEL_LIST;
    private final DSL.TypeReference type;

    private DataFixTypes(DSL.TypeReference var2) {
        this.type = var2;
    }

    static int currentVersion() {
        return SharedConstants.getCurrentVersion().dataVersion().version();
    }

    public <A> Codec<A> wrapCodec(final Codec<A> var0, final DataFixer var1, final int var2) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A var02, DynamicOps<T> var12, T var22) {
                return var0.encode(var02, var12, var22).flatMap(var1 -> var12.mergeToMap(var1, var12.createString("DataVersion"), var12.createInt(DataFixTypes.currentVersion())));
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var02, T var12) {
                int var22 = var02.get(var12, "DataVersion").flatMap(arg_0 -> var02.getNumberValue(arg_0)).map(Number::intValue).result().orElse(var2);
                Dynamic var3 = new Dynamic(var02, var02.remove(var12, "DataVersion"));
                Dynamic var4 = DataFixTypes.this.updateToCurrentVersion(var1, var3, var22);
                return var0.decode(var4);
            }
        };
    }

    public <T> Dynamic<T> update(DataFixer var0, Dynamic<T> var1, int var2, int var3) {
        return var0.update(this.type, var1, var2, var3);
    }

    public <T> Dynamic<T> updateToCurrentVersion(DataFixer var0, Dynamic<T> var1, int var2) {
        return this.update(var0, var1, var2, DataFixTypes.currentVersion());
    }

    public CompoundTag update(DataFixer var0, CompoundTag var1, int var2, int var3) {
        return (CompoundTag)this.update(var0, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)var1), var2, var3).getValue();
    }

    public CompoundTag updateToCurrentVersion(DataFixer var0, CompoundTag var1, int var2) {
        return this.update(var0, var1, var2, DataFixTypes.currentVersion());
    }

    static {
        TYPES_FOR_LEVEL_LIST = Set.of(DataFixTypes.LEVEL_SUMMARY.type);
    }
}

