/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;

public class LevelFlatGeneratorInfoFix
extends DataFix {
    private static final String GENERATOR_OPTIONS = "generatorOptions";
    @VisibleForTesting
    static final String DEFAULT = "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
    private static final Splitter SPLITTER = Splitter.on((char)';').limit(5);
    private static final Splitter LAYER_SPLITTER = Splitter.on((char)',');
    private static final Splitter OLD_AMOUNT_SPLITTER = Splitter.on((char)'x').limit(2);
    private static final Splitter AMOUNT_SPLITTER = Splitter.on((char)'*').limit(2);
    private static final Splitter BLOCK_SPLITTER = Splitter.on((char)':').limit(3);

    public LevelFlatGeneratorInfoFix(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelFlatGeneratorInfoFix", this.getInputSchema().getType(References.LEVEL), var0 -> var0.update(DSL.remainderFinder(), this::fix));
    }

    private Dynamic<?> fix(Dynamic<?> var02) {
        if (var02.get("generatorName").asString("").equalsIgnoreCase("flat")) {
            return var02.update(GENERATOR_OPTIONS, var0 -> (Dynamic)DataFixUtils.orElse((Optional)var0.asString().map(this::fixString).map(arg_0 -> ((Dynamic)var0).createString(arg_0)).result(), (Object)var0));
        }
        return var02;
    }

    @VisibleForTesting
    String fixString(String var0) {
        String var4;
        int var3;
        if (var0.isEmpty()) {
            return DEFAULT;
        }
        Iterator var1 = SPLITTER.split((CharSequence)var0).iterator();
        String var22 = (String)var1.next();
        if (var1.hasNext()) {
            var3 = NumberUtils.toInt((String)var22, (int)0);
            var4 = (String)var1.next();
        } else {
            var3 = 0;
            var4 = var22;
        }
        if (var3 < 0 || var3 > 3) {
            return DEFAULT;
        }
        StringBuilder var5 = new StringBuilder();
        Splitter var6 = var3 < 3 ? OLD_AMOUNT_SPLITTER : AMOUNT_SPLITTER;
        var5.append(StreamSupport.stream(LAYER_SPLITTER.split((CharSequence)var4).spliterator(), false).map(var2 -> {
            String var4;
            int var3;
            List var5 = var6.splitToList((CharSequence)var2);
            if (var5.size() == 2) {
                var3 = NumberUtils.toInt((String)((String)var5.get(0)));
                var4 = (String)var5.get(1);
            } else {
                var3 = 1;
                var4 = (String)var5.get(0);
            }
            List var6 = BLOCK_SPLITTER.splitToList((CharSequence)var4);
            int var7 = ((String)var6.get(0)).equals("minecraft") ? 1 : 0;
            String var8 = (String)var6.get(var7);
            int var9 = var3 == 3 ? EntityBlockStateFix.getBlockId("minecraft:" + var8) : NumberUtils.toInt((String)var8, (int)0);
            int var10 = var7 + 1;
            int var11 = var6.size() > var10 ? NumberUtils.toInt((String)((String)var6.get(var10)), (int)0) : 0;
            return (String)(var3 == 1 ? "" : var3 + "*") + BlockStateData.getTag(var9 << 4 | var11).get("Name").asString("");
        }).collect(Collectors.joining(",")));
        while (var1.hasNext()) {
            var5.append(';').append((String)var1.next());
        }
        return var5.toString();
    }
}

