/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class DebugSubscription<T> {
    public static final int DOES_NOT_EXPIRE = 0;
    @Nullable
    final StreamCodec<? super RegistryFriendlyByteBuf, T> valueStreamCodec;
    private final int expireAfterTicks;

    public DebugSubscription(@Nullable StreamCodec<? super RegistryFriendlyByteBuf, T> var0, int var1) {
        this.valueStreamCodec = var0;
        this.expireAfterTicks = var1;
    }

    public DebugSubscription(@Nullable StreamCodec<? super RegistryFriendlyByteBuf, T> var0) {
        this(var0, 0);
    }

    public Update<T> packUpdate(@Nullable T var0) {
        return new Update<T>(this, Optional.ofNullable(var0));
    }

    public Update<T> emptyUpdate() {
        return new Update(this, Optional.empty());
    }

    public Event<T> packEvent(T var0) {
        return new Event<T>(this, var0);
    }

    public String toString() {
        return Util.getRegisteredName(BuiltInRegistries.DEBUG_SUBSCRIPTION, this);
    }

    @Nullable
    public StreamCodec<? super RegistryFriendlyByteBuf, T> valueStreamCodec() {
        return this.valueStreamCodec;
    }

    public int expireAfterTicks() {
        return this.expireAfterTicks;
    }

    public record Update<T>(DebugSubscription<T> subscription, Optional<T> value) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Update<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.DEBUG_SUBSCRIPTION).dispatch(Update::subscription, Update::streamCodec);

        private static <T> StreamCodec<? super RegistryFriendlyByteBuf, Update<T>> streamCodec(DebugSubscription<T> var0) {
            return ByteBufCodecs.optional(Objects.requireNonNull(var0.valueStreamCodec)).map(var1 -> new Update(var0, var1), Update::value);
        }
    }

    public record Event<T>(DebugSubscription<T> subscription, T value) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Event<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.DEBUG_SUBSCRIPTION).dispatch(Event::subscription, Event::streamCodec);

        private static <T> StreamCodec<? super RegistryFriendlyByteBuf, Event<T>> streamCodec(DebugSubscription<T> var0) {
            return Objects.requireNonNull(var0.valueStreamCodec).map(var1 -> new Event<Object>(var0, var1), Event::value);
        }
    }
}

