/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S, T> Term<S> marker(Atom<T> var0, T var1) {
        return new Marker(var0, var1);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... var0) {
        return new Sequence<S>(var0);
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... var0) {
        return new Alternative<S>(var0);
    }

    public static <S> Term<S> optional(Term<S> var0) {
        return new Maybe<S>(var0);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> var0, Atom<List<T>> var1) {
        return Term.repeated(var0, var1, 0);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> var0, Atom<List<T>> var1, int var2) {
        return new Repeated<S, T>(var0, var1, var2);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> var0, Atom<List<T>> var1, Term<S> var2) {
        return Term.repeatedWithTrailingSeparator(var0, var1, var2, 0);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> var0, Atom<List<T>> var1, Term<S> var2, int var3) {
        return new RepeatedWithSeparator<S, T>(var0, var1, var2, var3, true);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> var0, Atom<List<T>> var1, Term<S> var2) {
        return Term.repeatedWithoutTrailingSeparator(var0, var1, var2, 0);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> var0, Atom<List<T>> var1, Term<S> var2, int var3) {
        return new RepeatedWithSeparator<S, T>(var0, var1, var2, var3, false);
    }

    public static <S> Term<S> positiveLookahead(Term<S> var0) {
        return new LookAhead<S>(var0, true);
    }

    public static <S> Term<S> negativeLookahead(Term<S> var0) {
        return new LookAhead<S>(var0, false);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
                var2.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public static <S> Term<S> fail(final Object var0) {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> var02, Scope var1, Control var2) {
                var02.errorCollector().store(var02.mark(), var0);
                return false;
            }

            public String toString() {
                return "fail";
            }
        };
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            var1.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(Term<S>[] elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            for (Term<S> var7 : this.elements) {
                if (var7.parse(var0, var1, var2)) continue;
                var0.restore(var3);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(Term<S>[] elements) implements Term<S>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            Control var3 = var0.acquireControl();
            try {
                int var4 = var0.mark();
                var1.splitFrame();
                for (Term<S> var8 : this.elements) {
                    if (var8.parse(var0, var1, var3)) {
                        var1.mergeFrame();
                        boolean bl = true;
                        return bl;
                    }
                    var1.clearFrameValues();
                    var0.restore(var4);
                    if (var3.hasCut()) break;
                }
                var1.popFrame();
                boolean bl = false;
                return bl;
            }
            finally {
                var0.releaseControl();
            }
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            if (!this.term.parse(var0, var1, var2)) {
                var0.restore(var3);
            }
            return true;
        }
    }

    public record Repeated<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, int minRepetitions) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var5;
            int var3 = var0.mark();
            ArrayList<T> var4 = new ArrayList<T>(this.minRepetitions);
            while (true) {
                var5 = var0.mark();
                T var6 = var0.parse(this.element);
                if (var6 == null) break;
                var4.add(var6);
            }
            var0.restore(var5);
            if (var4.size() < this.minRepetitions) {
                var0.restore(var3);
                return false;
            }
            var1.put(this.listName, var4);
            return true;
        }
    }

    public record RepeatedWithSeparator<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator, int minRepetitions, boolean allowTrailingSeparator) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            ArrayList<T> var4 = new ArrayList<T>(this.minRepetitions);
            boolean var5 = true;
            while (true) {
                int var6 = var0.mark();
                if (!var5 && !this.separator.parse(var0, var1, var2)) {
                    var0.restore(var6);
                    break;
                }
                int var7 = var0.mark();
                T var8 = var0.parse(this.element);
                if (var8 == null) {
                    if (var5) {
                        var0.restore(var7);
                        break;
                    }
                    if (this.allowTrailingSeparator) {
                        var0.restore(var7);
                        break;
                    }
                    var0.restore(var3);
                    return false;
                }
                var4.add(var8);
                var5 = false;
            }
            if (var4.size() < this.minRepetitions) {
                var0.restore(var3);
                return false;
            }
            var1.put(this.listName, var4);
            return true;
        }
    }

    public record LookAhead<S>(Term<S> term, boolean positive) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            boolean var4 = this.term.parse(var0.silent(), var1, var2);
            var0.restore(var3);
            return this.positive == var4;
        }
    }
}

