/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.profiling;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import net.minecraft.SystemReport;
import net.minecraft.util.profiling.ProfileCollector;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.ProfilerSamplerAdapter;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class ServerMetricsSamplersProvider
implements MetricsSamplerProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<MetricSampler> samplers = new ObjectOpenHashSet();
    private final ProfilerSamplerAdapter samplerFactory = new ProfilerSamplerAdapter();

    public ServerMetricsSamplersProvider(LongSupplier var0, boolean var1) {
        this.samplers.add(ServerMetricsSamplersProvider.tickTimeSampler(var0));
        if (var1) {
            this.samplers.addAll(ServerMetricsSamplersProvider.runtimeIndependentSamplers());
        }
    }

    public static Set<MetricSampler> runtimeIndependentSamplers() {
        ImmutableSet.Builder var0 = ImmutableSet.builder();
        try {
            CpuStats var12 = new CpuStats();
            IntStream.range(0, var12.nrOfCpus).mapToObj(var1 -> MetricSampler.create("cpu#" + var1, MetricCategory.CPU, () -> var12.loadForCpu(var1))).forEach(arg_0 -> ((ImmutableSet.Builder)var0).add(arg_0));
        }
        catch (Throwable var13) {
            LOGGER.warn("Failed to query cpu, no cpu stats will be recorded", var13);
        }
        var0.add((Object)MetricSampler.create("heap MiB", MetricCategory.JVM, () -> SystemReport.sizeInMiB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        var0.addAll(MetricsRegistry.INSTANCE.getRegisteredSamplers());
        return var0.build();
    }

    @Override
    public Set<MetricSampler> samplers(Supplier<ProfileCollector> var0) {
        this.samplers.addAll(this.samplerFactory.newSamplersFoundInProfiler(var0));
        return this.samplers;
    }

    public static MetricSampler tickTimeSampler(final LongSupplier var02) {
        Stopwatch var1 = Stopwatch.createUnstarted((Ticker)new Ticker(){

            public long read() {
                return var02.getAsLong();
            }
        });
        ToDoubleFunction<Stopwatch> var2 = var0 -> {
            if (var0.isRunning()) {
                var0.stop();
            }
            long var1 = var0.elapsed(TimeUnit.NANOSECONDS);
            var0.reset();
            return var1;
        };
        MetricSampler.ValueIncreasedByPercentage var3 = new MetricSampler.ValueIncreasedByPercentage(2.0f);
        return MetricSampler.builder("ticktime", MetricCategory.TICK_LOOP, var2, var1).withBeforeTick(Stopwatch::start).withThresholdAlert(var3).build();
    }

    static class CpuStats {
        private final SystemInfo systemInfo = new SystemInfo();
        private final CentralProcessor processor = this.systemInfo.getHardware().getProcessor();
        public final int nrOfCpus = this.processor.getLogicalProcessorCount();
        private long[][] previousCpuLoadTick = this.processor.getProcessorCpuLoadTicks();
        private double[] currentLoad = this.processor.getProcessorCpuLoadBetweenTicks(this.previousCpuLoadTick);
        private long lastPollMs;

        CpuStats() {
        }

        public double loadForCpu(int var0) {
            long var1 = System.currentTimeMillis();
            if (this.lastPollMs == 0L || this.lastPollMs + 501L < var1) {
                this.currentLoad = this.processor.getProcessorCpuLoadBetweenTicks(this.previousCpuLoadTick);
                this.previousCpuLoadTick = this.processor.getProcessorCpuLoadTicks();
                this.lastPollMs = var1;
            }
            return this.currentLoad[var0] * 100.0;
        }
    }
}

