/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.BlockState;

public class DamageSources {
    private final Registry<DamageType> damageTypes;
    private final DamageSource inFire;
    private final DamageSource campfire;
    private final DamageSource lightningBolt;
    private final DamageSource onFire;
    private final DamageSource lava;
    private final DamageSource hotFloor;
    private final DamageSource inWall;
    private final DamageSource cramming;
    private final DamageSource drown;
    private final DamageSource starve;
    private final DamageSource cactus;
    private final DamageSource fall;
    private final DamageSource enderPearl;
    private final DamageSource flyIntoWall;
    private final DamageSource fellOutOfWorld;
    private final DamageSource generic;
    private final DamageSource magic;
    private final DamageSource wither;
    private final DamageSource dragonBreath;
    private final DamageSource dryOut;
    private final DamageSource sweetBerryBush;
    private final DamageSource freeze;
    private final DamageSource stalagmite;
    private final DamageSource outsideBorder;
    private final DamageSource genericKill;
    private final DamageSource melting;
    private final DamageSource poison;

    public DamageSources(RegistryAccess iregistrycustom) {
        this.damageTypes = iregistrycustom.lookupOrThrow(Registries.DAMAGE_TYPE);
        this.melting = this.source(DamageTypes.ON_FIRE).melting();
        this.poison = this.source(DamageTypes.MAGIC).poison();
        this.inFire = this.source(DamageTypes.IN_FIRE);
        this.campfire = this.source(DamageTypes.CAMPFIRE);
        this.lightningBolt = this.source(DamageTypes.LIGHTNING_BOLT);
        this.onFire = this.source(DamageTypes.ON_FIRE);
        this.lava = this.source(DamageTypes.LAVA);
        this.hotFloor = this.source(DamageTypes.HOT_FLOOR);
        this.inWall = this.source(DamageTypes.IN_WALL);
        this.cramming = this.source(DamageTypes.CRAMMING);
        this.drown = this.source(DamageTypes.DROWN);
        this.starve = this.source(DamageTypes.STARVE);
        this.cactus = this.source(DamageTypes.CACTUS);
        this.fall = this.source(DamageTypes.FALL);
        this.enderPearl = this.source(DamageTypes.ENDER_PEARL);
        this.flyIntoWall = this.source(DamageTypes.FLY_INTO_WALL);
        this.fellOutOfWorld = this.source(DamageTypes.FELL_OUT_OF_WORLD);
        this.generic = this.source(DamageTypes.GENERIC);
        this.magic = this.source(DamageTypes.MAGIC);
        this.wither = this.source(DamageTypes.WITHER);
        this.dragonBreath = this.source(DamageTypes.DRAGON_BREATH);
        this.dryOut = this.source(DamageTypes.DRY_OUT);
        this.sweetBerryBush = this.source(DamageTypes.SWEET_BERRY_BUSH);
        this.freeze = this.source(DamageTypes.FREEZE);
        this.stalagmite = this.source(DamageTypes.STALAGMITE);
        this.outsideBorder = this.source(DamageTypes.OUTSIDE_BORDER);
        this.genericKill = this.source(DamageTypes.GENERIC_KILL);
    }

    private DamageSource source(ResourceKey<DamageType> resourcekey) {
        return new DamageSource(this.damageTypes.getOrThrow(resourcekey));
    }

    private DamageSource source(ResourceKey<DamageType> resourcekey, @Nullable Entity entity) {
        return new DamageSource((Holder<DamageType>)this.damageTypes.getOrThrow(resourcekey), entity);
    }

    private DamageSource source(ResourceKey<DamageType> resourcekey, @Nullable Entity entity, @Nullable Entity entity1) {
        return new DamageSource(this.damageTypes.getOrThrow(resourcekey), entity, entity1);
    }

    public DamageSource melting() {
        return this.melting;
    }

    public DamageSource poison() {
        return this.poison;
    }

    public DamageSource inFire() {
        return this.inFire;
    }

    public DamageSource campfire() {
        return this.campfire;
    }

    public DamageSource lightningBolt() {
        return this.lightningBolt;
    }

    public DamageSource onFire() {
        return this.onFire;
    }

    public DamageSource lava() {
        return this.lava;
    }

    public DamageSource hotFloor() {
        return this.hotFloor;
    }

    public DamageSource inWall() {
        return this.inWall;
    }

    public DamageSource cramming() {
        return this.cramming;
    }

    public DamageSource drown() {
        return this.drown;
    }

    public DamageSource starve() {
        return this.starve;
    }

    public DamageSource cactus() {
        return this.cactus;
    }

    public DamageSource fall() {
        return this.fall;
    }

    public DamageSource enderPearl() {
        return this.enderPearl;
    }

    public DamageSource flyIntoWall() {
        return this.flyIntoWall;
    }

    public DamageSource fellOutOfWorld() {
        return this.fellOutOfWorld;
    }

    public DamageSource generic() {
        return this.generic;
    }

    public DamageSource magic() {
        return this.magic;
    }

    public DamageSource wither() {
        return this.wither;
    }

    public DamageSource dragonBreath() {
        return this.dragonBreath;
    }

    public DamageSource dryOut() {
        return this.dryOut;
    }

    public DamageSource sweetBerryBush() {
        return this.sweetBerryBush;
    }

    public DamageSource freeze() {
        return this.freeze;
    }

    public DamageSource stalagmite() {
        return this.stalagmite;
    }

    public DamageSource fallingBlock(Entity entity) {
        return this.source(DamageTypes.FALLING_BLOCK, entity);
    }

    public DamageSource anvil(Entity entity) {
        return this.source(DamageTypes.FALLING_ANVIL, entity);
    }

    public DamageSource fallingStalactite(Entity entity) {
        return this.source(DamageTypes.FALLING_STALACTITE, entity);
    }

    public DamageSource sting(LivingEntity entityliving) {
        return this.source(DamageTypes.STING, entityliving);
    }

    public DamageSource mobAttack(LivingEntity entityliving) {
        return this.source(DamageTypes.MOB_ATTACK, entityliving);
    }

    public DamageSource noAggroMobAttack(LivingEntity entityliving) {
        return this.source(DamageTypes.MOB_ATTACK_NO_AGGRO, entityliving);
    }

    public DamageSource playerAttack(Player entityhuman) {
        return this.source(DamageTypes.PLAYER_ATTACK, entityhuman);
    }

    public DamageSource arrow(AbstractArrow entityarrow, @Nullable Entity entity) {
        return this.source(DamageTypes.ARROW, entityarrow, entity);
    }

    public DamageSource trident(Entity entity, @Nullable Entity entity1) {
        return this.source(DamageTypes.TRIDENT, entity, entity1);
    }

    public DamageSource mobProjectile(Entity entity, @Nullable LivingEntity entityliving) {
        return this.source(DamageTypes.MOB_PROJECTILE, entity, entityliving);
    }

    public DamageSource spit(Entity entity, @Nullable LivingEntity entityliving) {
        return this.source(DamageTypes.SPIT, entity, entityliving);
    }

    public DamageSource windCharge(Entity entity, @Nullable LivingEntity entityliving) {
        return this.source(DamageTypes.WIND_CHARGE, entity, entityliving);
    }

    public DamageSource fireworks(FireworkRocketEntity entityfireworks, @Nullable Entity entity) {
        return this.source(DamageTypes.FIREWORKS, entityfireworks, entity);
    }

    public DamageSource fireball(Fireball entityfireballfireball, @Nullable Entity entity) {
        return entity == null ? this.source(DamageTypes.UNATTRIBUTED_FIREBALL, entityfireballfireball) : this.source(DamageTypes.FIREBALL, entityfireballfireball, entity);
    }

    public DamageSource witherSkull(WitherSkull entitywitherskull, Entity entity) {
        return this.source(DamageTypes.WITHER_SKULL, entitywitherskull, entity);
    }

    public DamageSource thrown(Entity entity, @Nullable Entity entity1) {
        return this.source(DamageTypes.THROWN, entity, entity1);
    }

    public DamageSource indirectMagic(Entity entity, @Nullable Entity entity1) {
        return this.source(DamageTypes.INDIRECT_MAGIC, entity, entity1);
    }

    public DamageSource thorns(Entity entity) {
        return this.source(DamageTypes.THORNS, entity);
    }

    public DamageSource explosion(@Nullable Explosion explosion) {
        return explosion != null ? this.explosion(explosion.getDirectSourceEntity(), explosion.getIndirectSourceEntity()) : this.explosion(null, null);
    }

    public DamageSource explosion(@Nullable Entity entity, @Nullable Entity entity1) {
        return this.explosion(entity, entity1, entity1 != null && entity != null ? DamageTypes.PLAYER_EXPLOSION : DamageTypes.EXPLOSION);
    }

    public DamageSource explosion(@Nullable Entity entity, @Nullable Entity entity1, ResourceKey<DamageType> resourceKey) {
        return this.source(resourceKey, entity, entity1);
    }

    public DamageSource sonicBoom(Entity entity) {
        return this.source(DamageTypes.SONIC_BOOM, entity);
    }

    public DamageSource badRespawnPointExplosion(Vec3 vec3d) {
        return this.badRespawnPointExplosion(vec3d, null);
    }

    public DamageSource badRespawnPointExplosion(Vec3 vec3d, BlockState blockState) {
        return new DamageSource((Holder<DamageType>)this.damageTypes.getOrThrow(DamageTypes.BAD_RESPAWN_POINT), vec3d).directBlockState(blockState);
    }

    public DamageSource outOfBorder() {
        return this.outsideBorder;
    }

    public DamageSource genericKill() {
        return this.genericKill;
    }

    public DamageSource mace(Entity entity) {
        return this.source(DamageTypes.MACE_SMASH, entity);
    }
}

