/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.Level;

class WindChargedMobEffect
extends MobEffect {
    protected WindChargedMobEffect(MobEffectCategory var0, int var1) {
        super(var0, var1, ParticleTypes.SMALL_GUST);
    }

    @Override
    public void onMobRemoved(ServerLevel var0, LivingEntity var1, int var2, Entity.RemovalReason var3) {
        if (var3 == Entity.RemovalReason.KILLED) {
            double var4 = var1.getX();
            double var6 = var1.getY() + (double)(var1.getBbHeight() / 2.0f);
            double var8 = var1.getZ();
            float var10 = 3.0f + var1.getRandom().nextFloat() * 2.0f;
            var0.explode(var1, null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, var4, var6, var8, var10, false, Level.ExplosionInteraction.TRIGGER, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, WeightedList.of(), SoundEvents.BREEZE_WIND_CHARGE_BURST);
        }
    }
}

