/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class LightningBolt
extends Entity {
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    public int life = 2;
    public long seed;
    public int flashes;
    public boolean visualOnly;
    @Nullable
    private ServerPlayer cause;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    private int blocksSetOnFire;

    public LightningBolt(EntityType<? extends LightningBolt> entitytypes, Level world) {
        super(entitytypes, world);
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    public void setVisualOnly(boolean flag) {
        this.visualOnly = flag;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.WEATHER;
    }

    @Nullable
    public ServerPlayer getCause() {
        return this.cause;
    }

    public void setCause(@Nullable ServerPlayer entityplayer) {
        this.cause = entityplayer;
    }

    private void powerLightningRod() {
        BlockPos blockposition = this.getStrikePosition();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof LightningRodBlock) {
            LightningRodBlock lightningrodblock = (LightningRodBlock)block;
            lightningrodblock.onLightningStrike(iblockdata, this.level(), blockposition);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.life == 2) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                Difficulty enumdifficulty = this.level().getDifficulty();
                if (enumdifficulty == Difficulty.NORMAL || enumdifficulty == Difficulty.HARD) {
                    this.spawnFire(4);
                }
                this.powerLightningRod();
                LightningBolt.clearCopperOnLightningStrike(this.level(), this.getStrikePosition());
                this.gameEvent(GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.level() instanceof ServerLevel) {
                    List<Entity> list = this.level().getEntities(this, new AABB(this.getX() - 15.0, this.getY() - 15.0, this.getZ() - 15.0, this.getX() + 15.0, this.getY() + 6.0 + 15.0, this.getZ() + 15.0), entity -> entity.isAlive() && !this.hitEntities.contains(entity));
                    for (ServerPlayer entityplayer : ((ServerLevel)this.level()).getPlayers(entityplayer1 -> entityplayer1.distanceTo(this) < 256.0f)) {
                        CriteriaTriggers.LIGHTNING_STRIKE.trigger(entityplayer, this, list);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                this.spawnFire(0);
            }
        }
        if (this.life >= 0 && !this.visualOnly) {
            if (!(this.level() instanceof ServerLevel)) {
                this.level().setSkyFlashTime(2);
            } else if (!this.visualOnly) {
                List<Entity> list1 = this.level().getEntities(this, new AABB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 6.0 + 3.0, this.getZ() + 3.0), Entity::isAlive);
                for (Entity entity2 : list1) {
                    entity2.thunderHit((ServerLevel)this.level(), this);
                }
                this.hitEntities.addAll(list1);
                if (this.cause != null) {
                    CriteriaTriggers.CHANNELED_LIGHTNING.trigger(this.cause, list1);
                }
            }
        }
    }

    private BlockPos getStrikePosition() {
        Vec3 vec3d = this.position();
        return BlockPos.containing(vec3d.x, vec3d.y - 1.0E-6, vec3d.z);
    }

    private void spawnFire(int i) {
        ServerLevel worldserver;
        Level world;
        if (!this.visualOnly && (world = this.level()) instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            BlockPos blockposition = this.blockPosition();
            BlockState iblockdata = BaseFireBlock.getState(this.level(), blockposition);
            if (this.level().getBlockState(blockposition).isAir() && iblockdata.canSurvive(this.level(), blockposition) && !this.visualOnly && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                this.level().setBlockAndUpdate(blockposition, iblockdata);
                ++this.blocksSetOnFire;
            }
            for (int j = 0; j < i; ++j) {
                BlockPos blockposition1 = blockposition.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
                iblockdata = BaseFireBlock.getState(this.level(), blockposition1);
                if (!this.level().getBlockState(blockposition1).isAir() || !iblockdata.canSurvive(this.level(), blockposition1) || this.visualOnly || CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition1, this).isCancelled()) continue;
                this.level().setBlockAndUpdate(blockposition1, iblockdata);
                ++this.blocksSetOnFire;
            }
            return;
        }
    }

    private static void clearCopperOnLightningStrike(Level world, BlockPos blockposition) {
        BlockState iblockdata = world.getBlockState(blockposition);
        if (iblockdata.getBlock() instanceof WeatheringCopper) {
            world.setBlockAndUpdate(blockposition, WeatheringCopper.getFirst(world.getBlockState(blockposition)));
            BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
            int i = world.random.nextInt(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = world.random.nextInt(8) + 1;
                LightningBolt.randomWalkCleaningCopper(world, blockposition, blockposition_mutableblockposition, k);
            }
        }
    }

    private static void randomWalkCleaningCopper(Level world, BlockPos blockposition, BlockPos.MutableBlockPos blockposition_mutableblockposition, int i) {
        Optional<BlockPos> optional;
        blockposition_mutableblockposition.set(blockposition);
        for (int j = 0; j < i && !(optional = LightningBolt.randomStepCleaningCopper(world, blockposition_mutableblockposition)).isEmpty(); ++j) {
            blockposition_mutableblockposition.set(optional.get());
        }
    }

    private static Optional<BlockPos> randomStepCleaningCopper(Level world, BlockPos blockposition) {
        for (BlockPos blockposition1 : BlockPos.randomInCube(world.random, 10, blockposition, 1)) {
            BlockState iblockdata = world.getBlockState(blockposition1);
            if (!(iblockdata.getBlock() instanceof WeatheringCopper)) continue;
            WeatheringCopper.getPrevious(iblockdata).ifPresent(iblockdata1 -> world.setBlockAndUpdate(blockposition1, (BlockState)iblockdata1));
            world.levelEvent(3002, blockposition1, -1);
            return Optional.of(blockposition1);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = 64.0 * LightningBolt.getViewScale();
        return d0 < d1 * d1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
    }

    public int getBlocksSetOnFire() {
        return this.blocksSetOnFire;
    }

    public Stream<Entity> getHitEntities() {
        return this.hitEntities.stream().filter(Entity::isAlive);
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return false;
    }
}

