/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class GiveGiftToHero
extends Behavior<Villager> {
    private static final int THROW_GIFT_AT_DISTANCE = 5;
    private static final int MIN_TIME_BETWEEN_GIFTS = 600;
    private static final int MAX_TIME_BETWEEN_GIFTS = 6600;
    private static final int TIME_TO_DELAY_FOR_HEAD_TO_FINISH_TURNING = 20;
    private static final Map<ResourceKey<VillagerProfession>, ResourceKey<LootTable>> GIFTS = ImmutableMap.builder().put(VillagerProfession.ARMORER, BuiltInLootTables.ARMORER_GIFT).put(VillagerProfession.BUTCHER, BuiltInLootTables.BUTCHER_GIFT).put(VillagerProfession.CARTOGRAPHER, BuiltInLootTables.CARTOGRAPHER_GIFT).put(VillagerProfession.CLERIC, BuiltInLootTables.CLERIC_GIFT).put(VillagerProfession.FARMER, BuiltInLootTables.FARMER_GIFT).put(VillagerProfession.FISHERMAN, BuiltInLootTables.FISHERMAN_GIFT).put(VillagerProfession.FLETCHER, BuiltInLootTables.FLETCHER_GIFT).put(VillagerProfession.LEATHERWORKER, BuiltInLootTables.LEATHERWORKER_GIFT).put(VillagerProfession.LIBRARIAN, BuiltInLootTables.LIBRARIAN_GIFT).put(VillagerProfession.MASON, BuiltInLootTables.MASON_GIFT).put(VillagerProfession.SHEPHERD, BuiltInLootTables.SHEPHERD_GIFT).put(VillagerProfession.TOOLSMITH, BuiltInLootTables.TOOLSMITH_GIFT).put(VillagerProfession.WEAPONSMITH, BuiltInLootTables.WEAPONSMITH_GIFT).build();
    private static final float SPEED_MODIFIER = 0.5f;
    private int timeUntilNextGift = 600;
    private boolean giftGivenDuringThisRun;
    private long timeSinceStart;

    public GiveGiftToHero(int var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        if (!this.isHeroVisible(var1)) {
            return false;
        }
        if (this.timeUntilNextGift > 0) {
            --this.timeUntilNextGift;
            return false;
        }
        return true;
    }

    @Override
    protected void start(ServerLevel var0, Villager var1, long var2) {
        this.giftGivenDuringThisRun = false;
        this.timeSinceStart = var2;
        Player var4 = this.getNearestTargetableHero(var1).get();
        var1.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, var4);
        BehaviorUtils.lookAtEntity(var1, var4);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.isHeroVisible(var1) && !this.giftGivenDuringThisRun;
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        Player var4 = this.getNearestTargetableHero(var1).get();
        BehaviorUtils.lookAtEntity(var1, var4);
        if (this.isWithinThrowingDistance(var1, var4)) {
            if (var2 - this.timeSinceStart > 20L) {
                this.throwGift(var0, var1, var4);
                this.giftGivenDuringThisRun = true;
            }
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)var1, var4, 0.5f, 5);
        }
    }

    @Override
    protected void stop(ServerLevel var0, Villager var1, long var2) {
        this.timeUntilNextGift = GiveGiftToHero.calculateTimeUntilNextGift(var0);
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    private void throwGift(ServerLevel var0, Villager var1, LivingEntity var22) {
        var1.dropFromGiftLootTable(var0, GiveGiftToHero.getLootTableToThrow(var1), (var2, var3) -> BehaviorUtils.throwItem(var1, var3, var22.position()));
    }

    private static ResourceKey<LootTable> getLootTableToThrow(Villager var0) {
        if (var0.isBaby()) {
            return BuiltInLootTables.BABY_VILLAGER_GIFT;
        }
        Optional<ResourceKey<VillagerProfession>> var1 = var0.getVillagerData().profession().unwrapKey();
        if (var1.isEmpty()) {
            return BuiltInLootTables.UNEMPLOYED_GIFT;
        }
        return GIFTS.getOrDefault(var1.get(), BuiltInLootTables.UNEMPLOYED_GIFT);
    }

    private boolean isHeroVisible(Villager var0) {
        return this.getNearestTargetableHero(var0).isPresent();
    }

    private Optional<Player> getNearestTargetableHero(Villager var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(this::isHero);
    }

    private boolean isHero(Player var0) {
        return var0.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }

    private boolean isWithinThrowingDistance(Villager var0, Player var1) {
        BlockPos var2 = var1.blockPosition();
        BlockPos var3 = var0.blockPosition();
        return var3.closerThan(var2, 5.0);
    }

    private static int calculateTimeUntilNextGift(ServerLevel var0) {
        return 600 + var0.random.nextInt(6001);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

