/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class PlayTagWithOtherKids {
    private static final int MAX_FLEE_XZ_DIST = 20;
    private static final int MAX_FLEE_Y_DIST = 8;
    private static final float FLEE_SPEED_MODIFIER = 0.6f;
    private static final float CHASE_SPEED_MODIFIER = 0.6f;
    private static final int MAX_CHASERS_PER_TARGET = 5;
    private static final int AVERAGE_WAIT_TIME_BETWEEN_RUNS = 10;

    public static BehaviorControl<PathfinderMob> create() {
        return BehaviorBuilder.create(var0 -> var0.group(var0.present(MemoryModuleType.VISIBLE_VILLAGER_BABIES), var0.absent(MemoryModuleType.WALK_TARGET), var0.registered(MemoryModuleType.LOOK_TARGET), var0.registered(MemoryModuleType.INTERACTION_TARGET)).apply((Applicative)var0, (var1, var2, var3, var4) -> (var5, var6, var7) -> {
            if (var5.getRandom().nextInt(10) != 0) {
                return false;
            }
            List var9 = (List)var0.get(var1);
            Optional<LivingEntity> var10 = var9.stream().filter(var1 -> PlayTagWithOtherKids.isFriendChasingMe(var6, var1)).findAny();
            if (var10.isPresent()) {
                for (int var11 = 0; var11 < 10; ++var11) {
                    Vec3 var122 = LandRandomPos.getPos(var6, 20, 8);
                    if (var122 == null || !var5.isVillage(BlockPos.containing(var122))) continue;
                    var2.set(new WalkTarget(var122, 0.6f, 0));
                    break;
                }
                return true;
            }
            Optional<LivingEntity> var11 = PlayTagWithOtherKids.findSomeoneBeingChased(var9);
            if (var11.isPresent()) {
                PlayTagWithOtherKids.chaseKid(var4, var3, var2, var11.get());
                return true;
            }
            var9.stream().findAny().ifPresent(var3 -> PlayTagWithOtherKids.chaseKid(var4, var3, var2, var3));
            return true;
        }));
    }

    private static void chaseKid(MemoryAccessor<?, LivingEntity> var0, MemoryAccessor<?, PositionTracker> var1, MemoryAccessor<?, WalkTarget> var2, LivingEntity var3) {
        var0.set(var3);
        var1.set(new EntityTracker(var3, true));
        var2.set(new WalkTarget(new EntityTracker(var3, false), 0.6f, 1));
    }

    private static Optional<LivingEntity> findSomeoneBeingChased(List<LivingEntity> var02) {
        Map<LivingEntity, Integer> var1 = PlayTagWithOtherKids.checkHowManyChasersEachFriendHas(var02);
        return var1.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).filter(var0 -> (Integer)var0.getValue() > 0 && (Integer)var0.getValue() <= 5).map(Map.Entry::getKey).findFirst();
    }

    private static Map<LivingEntity, Integer> checkHowManyChasersEachFriendHas(List<LivingEntity> var0) {
        HashMap var1 = Maps.newHashMap();
        var0.stream().filter(PlayTagWithOtherKids::isChasingSomeone).forEach(var12 -> var1.compute(PlayTagWithOtherKids.whoAreYouChasing(var12), (var0, var1) -> var1 == null ? 1 : var1 + 1));
        return var1;
    }

    private static LivingEntity whoAreYouChasing(LivingEntity var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
    }

    private static boolean isChasingSomeone(LivingEntity var0) {
        return var0.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    private static boolean isFriendChasingMe(LivingEntity var0, LivingEntity var12) {
        return var12.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).filter(var1 -> var1 == var0).isPresent();
    }
}

