/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StartAttacking {
    public static <E extends Mob> BehaviorControl<E> create(TargetFinder<E> behaviorattacktargetset_b) {
        return StartAttacking.create((worldserver, entityinsentient) -> true, behaviorattacktargetset_b);
    }

    public static <E extends Mob> BehaviorControl<E> create(StartAttackingCondition<E> behaviorattacktargetset_a, TargetFinder<E> behaviorattacktargetset_b) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.absent(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i) -> {
            if (!behaviorattacktargetset_a.test(worldserver, entityinsentient)) {
                return false;
            }
            Optional<LivingEntity> optional = behaviorattacktargetset_b.get(worldserver, entityinsentient);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity entityliving = optional.get();
            if (!entityinsentient.canAttack(entityliving)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, entityliving, entityliving instanceof ServerPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryaccessor.erase();
                return true;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryaccessor.set(entityliving);
            memoryaccessor1.erase();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface StartAttackingCondition<E> {
        public boolean test(ServerLevel var1, E var2);
    }

    @FunctionalInterface
    public static interface TargetFinder<E> {
        public Optional<? extends LivingEntity> get(ServerLevel var1, E var2);
    }
}

