/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int checkInterval;
    protected BlockPos pos;

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> entitytypes, Level world) {
        super(entitytypes, world);
    }

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> entitytypes, Level world, BlockPos blockposition) {
        this(entitytypes, world);
        this.pos = blockposition;
    }

    protected abstract void recalculateBoundingBox();

    @Override
    public void tick() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.checkBelowWorld();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    BlockState material = this.level().getBlockState(this.blockPosition());
                    HangingBreakEvent.RemoveCause cause = !material.isAir() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.isRemoved() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.dropItem(worldserver, null);
                }
            }
        }
    }

    public abstract boolean survives();

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            return !this.level().mayInteract(entityhuman, this.pos) ? true : this.hurtOrSimulate(this.damageSources().playerAttack(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean hurtClient(DamageSource damagesource) {
        return !this.isInvulnerableToBase(damagesource);
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableToBase(damagesource)) {
            return false;
        }
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && damagesource.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.isRemoved()) {
            Entity damager;
            Entity entity = damager = damagesource.isDirect() ? damagesource.getDirectEntity() : damagesource.getEntity();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damagesource.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damagesource.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.isRemoved() || event.isCancelled()) {
                return true;
            }
            this.kill(worldserver);
            this.markHurt();
            this.dropItem(worldserver, damagesource.getEntity());
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        Entity entity = explosion.getDirectSourceEntity();
        return entity != null && entity.isInWater() ? true : (explosion.shouldAffectBlocklikeEntities() ? super.ignoreExplosion(explosion) : true);
    }

    @Override
    public void move(MoverType enummovetype, Vec3 vec3d) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!this.isRemoved() && vec3d.lengthSqr() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.isRemoved() || event.isCancelled()) {
                    return;
                }
                this.kill(worldserver);
                this.dropItem(worldserver, null);
            }
        }
    }

    @Override
    public void push(double d0, double d1, double d2) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput, boolean includeAll) {
        if (includeAll) {
            this.addAdditionalSaveData(valueoutput);
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.store("block_pos", BlockPos.CODEC, this.getPos());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        BlockPos blockposition = valueinput.read("block_pos", BlockPos.CODEC).orElse(null);
        if (blockposition != null && blockposition.closerThan(this.blockPosition(), 16.0)) {
            this.pos = blockposition;
        } else {
            LOGGER.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        }
    }

    public abstract void dropItem(ServerLevel var1, @Nullable Entity var2);

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double d0, double d1, double d2) {
        this.pos = BlockPos.containing(d0, d1, d2);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void thunderHit(ServerLevel worldserver, LightningBolt entitylightning) {
    }

    @Override
    public void refreshDimensions() {
    }
}

