/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public interface InventoryCarrier {
    public static final String TAG_INVENTORY = "Inventory";

    public SimpleContainer getInventory();

    public static void pickUpItem(ServerLevel worldserver, Mob entityinsentient, InventoryCarrier inventorycarrier, ItemEntity entityitem) {
        ItemStack itemstack = entityitem.getItem();
        if (entityinsentient.wantsToPickUp(worldserver, itemstack)) {
            SimpleContainer inventorysubcontainer = inventorycarrier.getInventory();
            boolean flag = inventorysubcontainer.canAddItem(itemstack);
            if (!flag) {
                return;
            }
            ItemStack remaining = new SimpleContainer(inventorysubcontainer).addItem(itemstack);
            if (CraftEventFactory.callEntityPickupItemEvent(entityinsentient, entityitem, remaining.getCount(), false).isCancelled()) {
                return;
            }
            entityinsentient.onItemPickup(entityitem);
            int i = itemstack.getCount();
            ItemStack itemstack1 = inventorysubcontainer.addItem(itemstack);
            entityinsentient.take(entityitem, i - itemstack1.getCount());
            if (itemstack1.isEmpty()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                itemstack.setCount(itemstack1.getCount());
            }
        }
    }

    default public void readInventoryFromTag(ValueInput valueinput) {
        valueinput.list(TAG_INVENTORY, ItemStack.CODEC).ifPresent(valueinput_a -> this.getInventory().fromItemList((ValueInput.TypedInputList<ItemStack>)valueinput_a));
    }

    default public void writeInventoryToTag(ValueOutput valueoutput) {
        this.getInventory().storeAsItemList(valueoutput.list(TAG_INVENTORY, ItemStack.CODEC));
    }
}

