/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftItem;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class AbstractArrow
extends Projectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final int SHAKE_TIME = 7;
    private static final float WATER_INERTIA = 0.6f;
    private static final float INERTIA = 0.99f;
    private static final short DEFAULT_LIFE = 0;
    private static final byte DEFAULT_SHAKE = 0;
    private static final boolean DEFAULT_IN_GROUND = false;
    private static final boolean DEFAULT_CRIT = false;
    private static final byte DEFAULT_PIERCE_LEVEL = 0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> IN_GROUND = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BOOLEAN);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private BlockState lastState;
    protected int inGroundTime;
    public Pickup pickup = Pickup.DISALLOWED;
    public int shakeTime = 0;
    public int life = 0;
    public double baseDamage = 2.0;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    public ItemStack pickupItemStack = this.getDefaultPickupItem();
    @Nullable
    public ItemStack firedFromWeapon = null;

    protected AbstractArrow(EntityType<? extends AbstractArrow> entitytypes, Level world) {
        super((EntityType<? extends Projectile>)entitytypes, world);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> entitytypes, double d0, double d1, double d2, Level world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, d0, d1, d2, world, itemstack, itemstack1, null);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> entitytypes, double d0, double d1, double d2, Level world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable LivingEntity ownerEntity) {
        this(entitytypes, world);
        this.setOwner(ownerEntity);
        this.pickupItemStack = itemstack.copy();
        this.applyComponentsFromItemStack(itemstack);
        Unit unit = itemstack.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if (unit != null) {
            this.pickup = Pickup.CREATIVE_ONLY;
        }
        this.setPos(d0, d1, d2);
        if (itemstack1 != null && world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (itemstack1.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = itemstack1.copy();
            int i = EnchantmentHelper.getPiercingCount(worldserver, itemstack1, this.pickupItemStack);
            if (i > 0) {
                this.setPierceLevel((byte)i);
            }
        }
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> entitytypes, LivingEntity entityliving, Level world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, entityliving.getX(), entityliving.getEyeY() - (double)0.1f, entityliving.getZ(), world, itemstack, itemstack1, entityliving);
    }

    public void setSoundEvent(SoundEvent soundeffect) {
        this.soundEvent = soundeffect;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * AbstractArrow.getViewScale()) * d1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(ID_FLAGS, (byte)0);
        datawatcher_a.define(PIERCE_LEVEL, (byte)0);
        datawatcher_a.define(IN_GROUND, false);
    }

    @Override
    public void shoot(double d0, double d1, double d2, float f, float f1) {
        super.shoot(d0, d1, d2, f, f1);
        this.life = 0;
    }

    @Override
    public void lerpMotion(Vec3 vec3d) {
        super.lerpMotion(vec3d);
        this.life = 0;
        if (this.isInGround() && vec3d.lengthSqr() > 0.0) {
            this.setInGround(false);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (!this.firstTick && this.shakeTime <= 0 && datawatcherobject.equals(IN_GROUND) && this.isInGround()) {
            this.shakeTime = 7;
        }
    }

    @Override
    public void tick() {
        VoxelShape voxelshape;
        boolean flag = !this.isNoPhysics();
        Vec3 vec3d = this.getDeltaMovement();
        BlockPos blockposition = this.blockPosition();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (!iblockdata.isAir() && flag && !(voxelshape = iblockdata.getCollisionShape(this.level(), blockposition)).isEmpty()) {
            Vec3 vec3d1 = this.position();
            for (AABB axisalignedbb : voxelshape.toAabbs()) {
                if (!axisalignedbb.move(blockposition).contains(vec3d1)) continue;
                this.setDeltaMovement(Vec3.ZERO);
                this.setInGround(true);
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        if (this.isInGround() && flag) {
            if (!this.level().isClientSide()) {
                if (this.lastState != iblockdata && this.shouldFall()) {
                    this.startFalling();
                } else {
                    this.tickDespawn();
                }
            }
            ++this.inGroundTime;
            if (this.isAlive()) {
                this.applyEffectsFromBlocks();
            }
            if (!this.level().isClientSide()) {
                this.setSharedFlagOnFire(this.getRemainingFireTicks() > 0);
            }
        } else {
            this.inGroundTime = 0;
            Vec3 vec3d2 = this.position();
            if (this.isInWater()) {
                this.applyInertia(this.getWaterInertia());
                this.addBubbleParticles(vec3d2);
            }
            if (this.isCritArrow()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle(ParticleTypes.CRIT, vec3d2.x + vec3d.x * (double)i / 4.0, vec3d2.y + vec3d.y * (double)i / 4.0, vec3d2.z + vec3d.z * (double)i / 4.0, -vec3d.x, -vec3d.y + 0.2, -vec3d.z);
                }
            }
            float f = !flag ? (float)(Mth.atan2(-vec3d.x, -vec3d.z) * 57.2957763671875) : (float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875);
            float f1 = (float)(Mth.atan2(vec3d.y, vec3d.horizontalDistance()) * 57.2957763671875);
            this.setXRot(AbstractArrow.lerpRotation(this.getXRot(), f1));
            this.setYRot(AbstractArrow.lerpRotation(this.getYRot(), f));
            this.checkLeftOwner();
            if (flag) {
                BlockHitResult movingobjectpositionblock = this.level().clipIncludingBorder(new ClipContext(vec3d2, vec3d2.add(vec3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
                this.stepMoveAndHit(movingobjectpositionblock);
            } else {
                this.setPos(vec3d2.add(vec3d));
                this.applyEffectsFromBlocks();
            }
            if (!this.isInWater()) {
                this.applyInertia(0.99f);
            }
            if (flag && !this.isInGround()) {
                this.applyGravity();
            }
            super.tick();
        }
    }

    private void stepMoveAndHit(BlockHitResult movingobjectpositionblock) {
        while (this.isAlive()) {
            Vec3 vec3d = this.position();
            EntityHitResult movingobjectpositionentity = this.findHitEntity(vec3d, movingobjectpositionblock.getLocation());
            Vec3 vec3d1 = ((HitResult)Objects.requireNonNullElse(movingobjectpositionentity, movingobjectpositionblock)).getLocation();
            this.setPos(vec3d1);
            this.applyEffectsFromBlocks(vec3d, vec3d1);
            if (this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
                this.handlePortal();
            }
            if (movingobjectpositionentity == null) {
                if (!this.isAlive() || movingobjectpositionblock.getType() == HitResult.Type.MISS) break;
                this.preHitTargetOrDeflectSelf(movingobjectpositionblock);
                this.hasImpulse = true;
                break;
            }
            if (!this.isAlive() || this.noPhysics) continue;
            ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(movingobjectpositionentity);
            this.hasImpulse = true;
            if (this.getPierceLevel() > 0 && projectiledeflection == ProjectileDeflection.NONE) continue;
        }
    }

    private void applyInertia(float f) {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.scale(f));
    }

    private void addBubbleParticles(Vec3 vec3d) {
        Vec3 vec3d1 = this.getDeltaMovement();
        for (int i = 0; i < 4; ++i) {
            float f = 0.25f;
            this.level().addParticle(ParticleTypes.BUBBLE, vec3d.x - vec3d1.x * 0.25, vec3d.y - vec3d1.y * 0.25, vec3d.z - vec3d1.z * 0.25, vec3d1.x, vec3d1.y, vec3d1.z);
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.setInGround(false);
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    public boolean isInGround() {
        return this.entityData.get(IN_GROUND);
    }

    protected void setInGround(boolean flag) {
        this.entityData.set(IN_GROUND, flag);
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.isInGround();
    }

    @Override
    public void move(MoverType enummovetype, Vec3 vec3d) {
        super.move(enummovetype, vec3d);
        if (enummovetype != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onItemBreak(Item item) {
        this.firedFromWeapon = null;
    }

    @Override
    public void onAboveBubbleColumn(boolean flag, BlockPos blockposition) {
        if (!this.isInGround()) {
            super.onAboveBubbleColumn(flag, blockposition);
        }
    }

    @Override
    public void onInsideBubbleColumn(boolean flag) {
        if (!this.isInGround()) {
            super.onInsideBubbleColumn(flag);
        }
    }

    @Override
    public void push(double d0, double d1, double d2) {
        if (!this.isInGround()) {
            super.push(d0, d1, d2);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        Level world;
        super.onHitEntity(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.baseDamage;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow(this, entity1 != null ? entity1 : this);
        if (this.getWeaponItem() != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            d0 = EnchantmentHelper.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, (float)d0);
        }
        int i = Mth.ceil(Mth.clamp((double)f * d0, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity1;
            entityliving.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.hurtOrSimulate(damagesource, i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving1 = (LivingEntity)entity;
                if (!this.level().isClientSide() && this.getPierceLevel() <= 0) {
                    entityliving1.setArrowCount(entityliving1.getArrowCount() + 1);
                }
                this.doKnockback(entityliving1, damagesource);
                Level world1 = this.level();
                if (world1 instanceof ServerLevel) {
                    ServerLevel worldserver1 = (ServerLevel)world1;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource(worldserver1, entityliving1, damagesource, this.getWeaponItem());
                }
                this.doPostHurtEffects(entityliving1);
                if (entityliving1 instanceof Player && entity1 instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity1;
                    if (!this.isSilent() && entityliving1 != entityplayer) {
                        entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.PLAY_ARROW_HIT_SOUND, 0.0f));
                    }
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(entityliving1);
                }
                if (!this.level().isClientSide() && entity1 instanceof ServerPlayer) {
                    ServerPlayer entityplayer1 = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null) {
                        CriteriaTriggers.KILLED_BY_ARROW.trigger(entityplayer1, this.piercedAndKilledEntities, this.firedFromWeapon);
                    } else if (!entity.isAlive()) {
                        CriteriaTriggers.KILLED_BY_ARROW.trigger(entityplayer1, List.of(entity), this.firedFromWeapon);
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.setRemainingFireTicks(k);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.owner, false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            Level world2 = this.level();
            if (world2 instanceof ServerLevel) {
                ServerLevel worldserver2 = (ServerLevel)world2;
                if (this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                    if (this.pickup == Pickup.ALLOWED) {
                        this.spawnAtLocation(worldserver2, this.getPickupItem(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void doKnockback(LivingEntity entityliving, DamageSource damagesource) {
        float f;
        Level world;
        if (this.firedFromWeapon != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            f = EnchantmentHelper.modifyKnockback(worldserver, this.firedFromWeapon, entityliving, damagesource, 0.0f);
        } else {
            f = 0.0f;
        }
        double d0 = f;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entityliving.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3d.lengthSqr() > 0.0) {
                entityliving.push(vec3d.x, 0.1, vec3d.z);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        this.lastState = this.level().getBlockState(movingobjectpositionblock.getBlockPos());
        super.onHitBlock(movingobjectpositionblock);
        ItemStack itemstack = this.getWeaponItem();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(worldserver, movingobjectpositionblock, itemstack);
            }
        }
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d1 = new Vec3(Math.signum(vec3d.x), Math.signum(vec3d.y), Math.signum(vec3d.z));
        Vec3 vec3d2 = vec3d1.scale(0.05f);
        this.setPos(this.position().subtract(vec3d2));
        this.setDeltaMovement(Vec3.ZERO);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.setInGround(true);
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void hitBlockEnchantmentEffects(ServerLevel worldserver, BlockHitResult movingobjectpositionblock, ItemStack itemstack) {
        LivingEntity entityliving1;
        Vec3 vec3d = movingobjectpositionblock.getBlockPos().clampLocationWithin(movingobjectpositionblock.getLocation());
        Entity entity = this.getOwner();
        LivingEntity entityliving = entity instanceof LivingEntity ? (entityliving1 = (LivingEntity)entity) : null;
        EnchantmentHelper.onHitBlock(worldserver, itemstack, entityliving, this, null, vec3d, worldserver.getBlockState(movingobjectpositionblock.getBlockPos()), item -> {
            this.firedFromWeapon = null;
        });
    }

    @Override
    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity entityliving) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 vec3d, Vec3 vec3d1) {
        return ProjectileUtil.getEntityHitResult(this.level(), this, vec3d, vec3d1, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        Player entityhuman;
        Entity entity1;
        if (entity instanceof Player && (entity1 = this.getOwner()) instanceof Player && !(entityhuman = (Player)entity1).canHarmPlayer((Player)entity)) {
            return false;
        }
        return super.canHitEntity(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.getId()));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putShort("life", (short)this.life);
        valueoutput.storeNullable("inBlockState", BlockState.CODEC, this.lastState);
        valueoutput.putByte("shake", (byte)this.shakeTime);
        valueoutput.putBoolean("inGround", this.isInGround());
        valueoutput.store("pickup", Pickup.LEGACY_CODEC, this.pickup);
        valueoutput.putDouble("damage", this.baseDamage);
        valueoutput.putBoolean("crit", this.isCritArrow());
        valueoutput.putByte("PierceLevel", this.getPierceLevel());
        valueoutput.store("SoundEvent", BuiltInRegistries.SOUND_EVENT.byNameCodec(), this.soundEvent);
        valueoutput.store("item", ItemStack.CODEC, this.pickupItemStack);
        valueoutput.storeNullable("weapon", ItemStack.CODEC, this.firedFromWeapon);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.life = valueinput.getShortOr("life", (short)0);
        this.lastState = valueinput.read("inBlockState", BlockState.CODEC).orElse(null);
        this.shakeTime = valueinput.getByteOr("shake", (byte)0) & 0xFF;
        this.setInGround(valueinput.getBooleanOr("inGround", false));
        this.baseDamage = valueinput.getDoubleOr("damage", 2.0);
        this.pickup = valueinput.read("pickup", Pickup.LEGACY_CODEC).orElse(Pickup.DISALLOWED);
        this.setCritArrow(valueinput.getBooleanOr("crit", false));
        this.setPierceLevel(valueinput.getByteOr("PierceLevel", (byte)0));
        this.soundEvent = valueinput.read("SoundEvent", BuiltInRegistries.SOUND_EVENT.byNameCodec()).orElse(this.getDefaultHitGroundSoundEvent());
        this.setPickupItemStack(valueinput.read("item", ItemStack.CODEC).orElse(this.getDefaultPickupItem()));
        this.firedFromWeapon = valueinput.read("weapon", ItemStack.CODEC).orElse(null);
    }

    @Override
    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        Pickup entityarrow_pickupstatus = this.pickup;
        Entity entity2 = entity1;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, OminousItemSpawner.class}, (Object)entity2, n)) {
            case 0: {
                Player entityhuman = (Player)entity2;
                if (this.pickup != Pickup.DISALLOWED) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = Pickup.ALLOWED;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = Pickup.DISALLOWED;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.pickup;
                break;
            }
        }
        this.pickup = entityarrow_pickupstatus;
    }

    @Override
    public void playerTouch(Player entityhuman) {
        if (!this.level().isClientSide() && (this.isInGround() || this.isNoPhysics()) && this.shakeTime <= 0) {
            ItemStack itemstack = this.getPickupItem();
            if (this.pickup == Pickup.ALLOWED && !itemstack.isEmpty() && entityhuman.getInventory().canHold(itemstack) > 0) {
                ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)new CraftItem(this.level().getCraftServer(), item), (org.bukkit.entity.AbstractArrow)this.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.getItem();
            }
            if (this.pickup == Pickup.ALLOWED && entityhuman.getInventory().add(itemstack) || this.pickup == Pickup.CREATIVE_ONLY && entityhuman.getAbilities().instabuild) {
                entityhuman.take(this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean tryPickup(Player entityhuman) {
        return switch (this.pickup.ordinal()) {
            case 0 -> false;
            case 1 -> entityhuman.getInventory().add(this.getPickupItem());
            case 2 -> entityhuman.hasInfiniteMaterials();
            default -> throw new MatchException(null, null);
        };
    }

    protected ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double d0) {
        this.baseDamage = d0;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean flag) {
        this.setFlag(1, flag);
    }

    public void setPierceLevel(byte b0) {
        this.entityData.set(PIERCE_LEVEL, b0);
    }

    private void setFlag(int i, boolean flag) {
        byte b0 = this.entityData.get(ID_FLAGS);
        if (flag) {
            this.entityData.set(ID_FLAGS, (byte)(b0 | i));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(b0 & ~i));
        }
    }

    protected void setPickupItemStack(ItemStack itemstack) {
        this.pickupItemStack = !itemstack.isEmpty() ? itemstack : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte b0 = this.entityData.get(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setBaseDamageFromMob(float f) {
        this.setBaseDamage((double)(f * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean flag) {
        this.noPhysics = flag;
        this.setFlag(2, flag);
    }

    public boolean isNoPhysics() {
        return !this.level().isClientSide() ? this.noPhysics : (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isInGround();
    }

    @Override
    public SlotAccess getSlot(int i) {
        return i == 0 ? SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack) : super.getSlot(i);
    }

    @Override
    protected boolean shouldBounceOnWorldBorder() {
        return true;
    }

    public static enum Pickup {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;

        public static final Codec<Pickup> LEGACY_CODEC;

        public static Pickup byOrdinal(int i) {
            if (i < 0 || i > Pickup.values().length) {
                i = 0;
            }
            return Pickup.values()[i];
        }

        static {
            LEGACY_CODEC = Codec.BYTE.xmap(Pickup::byOrdinal, entityarrow_pickupstatus -> (byte)entityarrow_pickupstatus.ordinal());
        }
    }
}

