/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class FireworkRocketEntity
extends Projectile
implements ItemSupplier {
    public static final EntityDataAccessor<ItemStack> DATA_ID_FIREWORKS_ITEM = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<OptionalInt> DATA_ATTACHED_TO_TARGET = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    public static final EntityDataAccessor<Boolean> DATA_SHOT_AT_ANGLE = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.BOOLEAN);
    private static final int DEFAULT_LIFE = 0;
    private static final int DEFAULT_LIFE_TIME = 0;
    private static final boolean DEFAULT_SHOT_AT_ANGLE = false;
    public int life = 0;
    public int lifetime = 0;
    @Nullable
    public LivingEntity attachedToEntity;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> entitytypes, Level world) {
        super((EntityType<? extends Projectile>)entitytypes, world);
    }

    public FireworkRocketEntity(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityType<? extends Projectile>)EntityType.FIREWORK_ROCKET, world);
        this.life = 0;
        this.setPos(d0, d1, d2);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, itemstack.copy());
        int i = 1;
        Fireworks fireworks = itemstack.get(DataComponents.FIREWORKS);
        if (fireworks != null) {
            i += fireworks.flightDuration();
        }
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 10 * i + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public FireworkRocketEntity(Level world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.setOwner(entity);
    }

    public FireworkRocketEntity(Level world, ItemStack itemstack, LivingEntity entityliving) {
        this(world, entityliving, entityliving.getX(), entityliving.getY(), entityliving.getZ(), itemstack);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, OptionalInt.of(entityliving.getId()));
        this.attachedToEntity = entityliving;
    }

    public FireworkRocketEntity(Level world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.entityData.set(DATA_SHOT_AT_ANGLE, flag);
    }

    public FireworkRocketEntity(Level world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.setOwner(entity);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_ID_FIREWORKS_ITEM, FireworkRocketEntity.getDefaultItem());
        datawatcher_a.define(DATA_ATTACHED_TO_TARGET, OptionalInt.empty());
        datawatcher_a.define(DATA_SHOT_AT_ANGLE, false);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        return d0 < 4096.0 && !this.isAttachedToEntity();
    }

    @Override
    public boolean shouldRender(double d0, double d1, double d2) {
        return super.shouldRender(d0, d1, d2) && !this.isAttachedToEntity();
    }

    @Override
    public void tick() {
        Level world;
        HitResult movingobjectposition;
        super.tick();
        if (this.isAttachedToEntity()) {
            if (this.attachedToEntity == null) {
                this.entityData.get(DATA_ATTACHED_TO_TARGET).ifPresent(i -> {
                    Entity entity = this.level().getEntity(i);
                    if (entity instanceof LivingEntity) {
                        this.attachedToEntity = (LivingEntity)entity;
                    }
                });
            }
            if (this.attachedToEntity != null) {
                Vec3 vec3d;
                if (this.attachedToEntity.isFallFlying()) {
                    Vec3 vec3d1 = this.attachedToEntity.getLookAngle();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3 vec3d2 = this.attachedToEntity.getDeltaMovement();
                    this.attachedToEntity.setDeltaMovement(vec3d2.add(vec3d1.x * 0.1 + (vec3d1.x * 1.5 - vec3d2.x) * 0.5, vec3d1.y * 0.1 + (vec3d1.y * 1.5 - vec3d2.y) * 0.5, vec3d1.z * 0.1 + (vec3d1.z * 1.5 - vec3d2.z) * 0.5));
                    vec3d = this.attachedToEntity.getHandHoldingItemAngle(Items.FIREWORK_ROCKET);
                } else {
                    vec3d = Vec3.ZERO;
                }
                this.setPos(this.attachedToEntity.getX() + vec3d.x, this.attachedToEntity.getY() + vec3d.y, this.attachedToEntity.getZ() + vec3d.z);
                this.setDeltaMovement(this.attachedToEntity.getDeltaMovement());
            }
            movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        } else {
            if (!this.isShotAtAngle()) {
                double d2 = this.horizontalCollision ? 1.0 : 1.15;
                this.setDeltaMovement(this.getDeltaMovement().multiply(d2, 1.0, d2).add(0.0, 0.04, 0.0));
            }
            Vec3 vec3d3 = this.getDeltaMovement();
            movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
            this.move(MoverType.SELF, vec3d3);
            this.applyEffectsFromBlocks();
            this.setDeltaMovement(vec3d3);
        }
        if (!this.noPhysics && this.isAlive() && movingobjectposition.getType() != HitResult.Type.MISS) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level().isClientSide() && this.life % 2 < 2) {
            this.level().addParticle(ParticleTypes.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (this.life > this.lifetime && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.explode(worldserver);
            }
        }
    }

    private void explode(ServerLevel worldserver) {
        worldserver.broadcastEntityEvent(this, (byte)17);
        this.gameEvent(GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage(worldserver);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.explode(worldserver);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        BlockPos blockposition = new BlockPos(movingobjectpositionblock.getBlockPos());
        this.level().getBlockState(blockposition).entityInside(this.level(), blockposition, this, InsideBlockEffectApplier.NOOP);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.hasExplosion() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.explode(worldserver);
            }
        }
        super.onHitBlock(movingobjectpositionblock);
    }

    private boolean hasExplosion() {
        return !this.getExplosions().isEmpty();
    }

    private void dealExplosionDamage(ServerLevel worldserver) {
        float f = 0.0f;
        List<FireworkExplosion> list = this.getExplosions();
        if (!list.isEmpty()) {
            f = 5.0f + (float)(list.size() * 2);
        }
        if (f > 0.0f) {
            if (this.attachedToEntity != null) {
                this.attachedToEntity.hurtServer(worldserver, this.damageSources().fireworks(this, this.getOwner()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3 vec3d = this.position();
            for (LivingEntity entityliving : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(5.0))) {
                if (entityliving == this.attachedToEntity || !(this.distanceToSqr(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3 vec3d1 = new Vec3(entityliving.getX(), entityliving.getY(0.5 * (double)i), entityliving.getZ());
                    BlockHitResult movingobjectposition = this.level().clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
                    if (((HitResult)movingobjectposition).getType() != HitResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.distanceTo(entityliving)) / 5.0);
                entityliving.hurtServer(worldserver, this.damageSources().fireworks(this, this.getOwner()), f1);
            }
        }
    }

    private boolean isAttachedToEntity() {
        return this.entityData.get(DATA_ATTACHED_TO_TARGET).isPresent();
    }

    public boolean isShotAtAngle() {
        return this.entityData.get(DATA_SHOT_AT_ANGLE);
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 17 && this.level().isClientSide()) {
            Vec3 vec3d = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), vec3d.x, vec3d.y, vec3d.z, this.getExplosions());
        }
        super.handleEntityEvent(b0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putInt("Life", this.life);
        valueoutput.putInt("LifeTime", this.lifetime);
        valueoutput.store("FireworksItem", ItemStack.CODEC, this.getItem());
        valueoutput.putBoolean("ShotAtAngle", this.entityData.get(DATA_SHOT_AT_ANGLE));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.life = valueinput.getIntOr("Life", 0);
        this.lifetime = valueinput.getIntOr("LifeTime", 0);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, valueinput.read("FireworksItem", ItemStack.CODEC).orElse(FireworkRocketEntity.getDefaultItem()));
        this.entityData.set(DATA_SHOT_AT_ANGLE, valueinput.getBooleanOr("ShotAtAngle", false));
    }

    private List<FireworkExplosion> getExplosions() {
        ItemStack itemstack = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        Fireworks fireworks = itemstack.get(DataComponents.FIREWORKS);
        return fireworks != null ? fireworks.explosions() : List.of();
    }

    @Override
    public ItemStack getItem() {
        return this.entityData.get(DATA_ID_FIREWORKS_ITEM);
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity entityliving, DamageSource damagesource) {
        double d0 = entityliving.position().x - this.position().x;
        double d1 = entityliving.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

