/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class Raids
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    public static final Codec<Raids> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RaidWithId.CODEC.listOf().optionalFieldOf(RAID_FILE_ID, List.of()).forGetter(persistentraid -> persistentraid.raidMap.int2ObjectEntrySet().stream().map(RaidWithId::from).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(persistentraid -> persistentraid.nextId), (App)Codec.INT.fieldOf("tick").forGetter(persistentraid -> persistentraid.tick)).apply((Applicative)instance, Raids::new));
    public static final SavedDataType<Raids> TYPE = new SavedDataType<Raids>("raids", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public static final SavedDataType<Raids> TYPE_END = new SavedDataType<Raids>("raids_end", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public final Int2ObjectMap<Raid> raidMap = new Int2ObjectOpenHashMap();
    private int nextId = 1;
    private int tick;

    public static SavedDataType<Raids> getType(Holder<DimensionType> holder) {
        return holder.is(BuiltinDimensionTypes.END) ? TYPE_END : TYPE;
    }

    public Raids() {
        this.setDirty();
    }

    private Raids(List<RaidWithId> list, int i, int j) {
        for (RaidWithId persistentraid_a : list) {
            this.raidMap.put(persistentraid_a.id, (Object)persistentraid_a.raid);
        }
        this.nextId = i;
        this.tick = j;
    }

    @Nullable
    public Raid get(int i) {
        return (Raid)this.raidMap.get(i);
    }

    public OptionalInt getId(Raid raid) {
        for (Int2ObjectMap.Entry int2objectmap_entry : this.raidMap.int2ObjectEntrySet()) {
            if (int2objectmap_entry.getValue() != raid) continue;
            return OptionalInt.of(int2objectmap_entry.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void tick(ServerLevel worldserver) {
        ++this.tick;
        ObjectIterator iterator = this.raidMap.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = (Raid)iterator.next();
            if (worldserver.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.setDirty();
                continue;
            }
            raid.tick(worldserver);
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
    }

    public static boolean canJoinRaid(Raider entityraider) {
        return entityraider.isAlive() && entityraider.canJoinRaid() && entityraider.getNoActionTime() <= 2400;
    }

    @Nullable
    public Raid createOrExtendRaid(ServerPlayer entityplayer, BlockPos blockposition) {
        BlockPos blockposition2;
        if (entityplayer.isSpectator()) {
            return null;
        }
        ServerLevel worldserver = entityplayer.level();
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionType dimensionmanager = worldserver.dimensionType();
        if (!dimensionmanager.hasRaids()) {
            return null;
        }
        List<PoiRecord> list = worldserver.getPoiManager().getInRange(holder -> holder.is(PoiTypeTags.VILLAGE), blockposition, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int i = 0;
        Vec3 vec3d = Vec3.ZERO;
        for (PoiRecord villageplacerecord : list) {
            BlockPos blockposition1 = villageplacerecord.getPos();
            vec3d = vec3d.add(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
            ++i;
        }
        if (i > 0) {
            vec3d = vec3d.scale(1.0 / (double)i);
            blockposition2 = BlockPos.containing(vec3d);
        } else {
            blockposition2 = blockposition;
        }
        Raid raid = this.getOrCreateRaid(worldserver, blockposition2);
        if (!raid.isStarted() || raid.isInProgress() && raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            if (!CraftEventFactory.callRaidTriggerEvent(raid, worldserver, entityplayer)) {
                entityplayer.removeEffect(MobEffects.RAID_OMEN);
                return null;
            }
            if (!raid.isStarted() && !this.raidMap.containsValue((Object)raid)) {
                this.raidMap.put(this.getUniqueId(), (Object)raid);
            }
            raid.absorbRaidOmen(entityplayer);
        }
        this.setDirty();
        return raid;
    }

    private Raid getOrCreateRaid(ServerLevel worldserver, BlockPos blockposition) {
        Raid raid = worldserver.getRaidAt(blockposition);
        return raid != null ? raid : new Raid(blockposition, worldserver.getDifficulty());
    }

    public static Raids load(CompoundTag nbttagcompound) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbttagcompound).resultOrPartial().orElseGet(Raids::new);
    }

    private int getUniqueId() {
        return ++this.nextId;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPos blockposition, int i) {
        Raid raid = null;
        double d0 = i;
        for (Raid raid1 : this.raidMap.values()) {
            double d1 = raid1.getCenter().distSqr(blockposition);
            if (!raid1.isActive() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }

    @VisibleForDebug
    public List<BlockPos> getRaidCentersInChunk(ChunkPos chunkcoordintpair) {
        Stream<BlockPos> stream = this.raidMap.values().stream().map(Raid::getCenter);
        Objects.requireNonNull(chunkcoordintpair);
        return stream.filter(chunkcoordintpair::contains).toList();
    }

    private record RaidWithId(int id, Raid raid) {
        public static final Codec<RaidWithId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(RaidWithId::id), (App)Raid.MAP_CODEC.forGetter(RaidWithId::raid)).apply((Applicative)instance, RaidWithId::new));

        public static RaidWithId from(Int2ObjectMap.Entry<Raid> int2objectmap_entry) {
            return new RaidWithId(int2objectmap_entry.getIntKey(), (Raid)int2objectmap_entry.getValue());
        }
    }
}

