/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceFuelSlot;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftFurnaceView;
import org.bukkit.entity.HumanEntity;

public abstract class AbstractFurnaceMenu
extends RecipeBookMenu {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipePropertySet acceptedInputs;
    private final RecipeBookType recipeBookType;
    private CraftFurnaceView bukkitEntity = null;
    private Inventory player;

    @Override
    public CraftFurnaceView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryFurnace inventory = new CraftInventoryFurnace((AbstractFurnaceBlockEntity)this.container);
        this.bukkitEntity = new CraftFurnaceView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    protected AbstractFurnaceMenu(MenuType<?> containers, RecipeType<? extends AbstractCookingRecipe> recipes, ResourceKey<RecipePropertySet> resourcekey, RecipeBookType recipebooktype, int i, Inventory playerinventory) {
        this(containers, recipes, resourcekey, recipebooktype, i, playerinventory, new SimpleContainer(3), new SimpleContainerData(4));
    }

    protected AbstractFurnaceMenu(MenuType<?> containers, RecipeType<? extends AbstractCookingRecipe> recipes, ResourceKey<RecipePropertySet> resourcekey, RecipeBookType recipebooktype, int i, Inventory playerinventory, Container iinventory, ContainerData icontainerproperties) {
        super(containers, i);
        this.recipeType = recipes;
        this.recipeBookType = recipebooktype;
        AbstractFurnaceMenu.checkContainerSize(iinventory, 3);
        AbstractFurnaceMenu.checkContainerDataCount(icontainerproperties, 4);
        this.container = iinventory;
        this.data = icontainerproperties;
        this.level = playerinventory.player.level();
        this.acceptedInputs = this.level.recipeAccess().propertySet(resourcekey);
        this.addSlot(new Slot(iinventory, 0, 56, 17));
        this.addSlot(new FurnaceFuelSlot(this, iinventory, 1, 56, 53));
        this.addSlot(new FurnaceResultSlot(playerinventory.player, iinventory, 2, 116, 35));
        this.player = playerinventory;
        this.addStandardInventorySlots(playerinventory, 8, 84);
        this.addDataSlots(icontainerproperties);
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedItemContents stackeditemcontents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)((Object)this.container)).fillStackedContents(stackeditemcontents);
        }
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(2);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i != 1 && i != 0 ? (this.canSmelt(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (this.isFuel(itemstack1) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (i >= 3 && i < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i >= 30 && i < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmelt(ItemStack itemstack) {
        return this.acceptedInputs.test(itemstack);
    }

    protected boolean isFuel(ItemStack itemstack) {
        return this.level.fuelValues().isFuel(itemstack);
    }

    public float getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)i / (float)j, 0.0f, 1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)this.data.get(0) / (float)i, 0.0f, 1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    @Override
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean flag, boolean flag1, RecipeHolder<?> recipeholder, final ServerLevel worldserver, Inventory playerinventory) {
        final List<Slot> list = List.of(this.getSlot(0), this.getSlot(2));
        return ServerPlaceRecipe.placeRecipe(new ServerPlaceRecipe.CraftingMenuAccess<AbstractCookingRecipe>(){

            @Override
            public void fillCraftSlotsStackedContents(StackedItemContents stackeditemcontents) {
                AbstractFurnaceMenu.this.fillCraftSlotsStackedContents(stackeditemcontents);
            }

            @Override
            public void clearCraftingContent() {
                list.forEach(slot -> slot.set(ItemStack.EMPTY));
            }

            @Override
            public boolean recipeMatches(RecipeHolder<AbstractCookingRecipe> recipeholder1) {
                return recipeholder1.value().matches(new SingleRecipeInput(AbstractFurnaceMenu.this.container.getItem(0)), (Level)worldserver);
            }
        }, 1, 1, List.of(this.getSlot(0)), list, playerinventory, recipeholder, flag, flag1);
    }
}

