/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantingTableBlock;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftEnchantmentView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;

public class EnchantmentMenu
extends AbstractContainerMenu {
    static final ResourceLocation EMPTY_SLOT_LAPIS_LAZULI = ResourceLocation.withDefaultNamespace("container/slot/lapis_lazuli");
    private final Container enchantSlots;
    private final ContainerLevelAccess access;
    private final RandomSource random;
    private final DataSlot enchantmentSeed;
    public final int[] costs;
    public final int[] enchantClue;
    public final int[] levelClue;
    private CraftEnchantmentView bukkitEntity = null;
    private org.bukkit.entity.Player player;

    public EnchantmentMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public EnchantmentMenu(int i, Inventory playerinventory, final ContainerLevelAccess containeraccess) {
        super(MenuType.ENCHANTMENT, i);
        this.enchantSlots = new SimpleContainer(2){

            @Override
            public void setChanged() {
                super.setChanged();
                EnchantmentMenu.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.random = RandomSource.create();
        this.enchantmentSeed = DataSlot.standalone();
        this.costs = new int[3];
        this.enchantClue = new int[]{-1, -1, -1};
        this.levelClue = new int[]{-1, -1, -1};
        this.access = containeraccess;
        this.addSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack itemstack) {
                return itemstack.is(Items.LAPIS_LAZULI);
            }

            @Override
            public ResourceLocation getNoItemIcon() {
                return EMPTY_SLOT_LAPIS_LAZULI;
            }
        });
        this.addStandardInventorySlots(playerinventory, 8, 84);
        this.addDataSlot(DataSlot.shared(this.costs, 0));
        this.addDataSlot(DataSlot.shared(this.costs, 1));
        this.addDataSlot(DataSlot.shared(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(playerinventory.player.getEnchantmentSeed());
        this.addDataSlot(DataSlot.shared(this.enchantClue, 0));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 1));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 2));
        this.addDataSlot(DataSlot.shared(this.levelClue, 0));
        this.addDataSlot(DataSlot.shared(this.levelClue, 1));
        this.addDataSlot(DataSlot.shared(this.levelClue, 2));
        this.player = (org.bukkit.entity.Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(Container iinventory) {
        if (iinventory == this.enchantSlots) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(0);
            if (!itemstack.isEmpty()) {
                this.access.execute((world, blockposition) -> {
                    IdMap<Holder<Holder<Enchantment>>> registry = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    int i = 0;
                    for (BlockPos blockposition1 : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                        if (!EnchantingTableBlock.isValidBookShelf(world, blockposition, blockposition1)) continue;
                        ++i;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    for (int j = 0; j < 3; ++j) {
                        this.costs[j] = EnchantmentHelper.getEnchantmentCost(this.random, j, i, itemstack);
                        this.enchantClue[j] = -1;
                        this.levelClue[j] = -1;
                        if (this.costs[j] >= j + 1) continue;
                        this.costs[j] = 0;
                    }
                    for (int k = 0; k < 3; ++k) {
                        List<EnchantmentInstance> list;
                        if (this.costs[k] <= 0 || (list = this.getEnchantmentList(world.registryAccess(), itemstack, k, this.costs[k])) == null || list.isEmpty()) continue;
                        EnchantmentInstance weightedrandomenchant = list.get(this.random.nextInt(list.size()));
                        this.enchantClue[k] = registry.getId(weightedrandomenchant.enchantment());
                        this.levelClue[k] = weightedrandomenchant.level();
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (int j = 0; j < 3; ++j) {
                        org.bukkit.enchantments.Enchantment enchantment = this.enchantClue[j] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.byId(this.enchantClue[j])) : null;
                        offers[j] = enchantment != null ? new EnchantmentOffer(enchantment, this.levelClue[j], this.costs[j]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (EnchantmentView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)item, offers, i);
                    event.setCancelled(!itemstack.isEnchantable());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (int j = 0; j < 3; ++j) {
                            this.costs[j] = 0;
                            this.enchantClue[j] = -1;
                            this.levelClue[j] = -1;
                        }
                        return;
                    }
                    for (int j = 0; j < 3; ++j) {
                        EnchantmentOffer offer = event.getOffers()[j];
                        if (offer != null) {
                            this.costs[j] = offer.getCost();
                            this.enchantClue[j] = registry.getId(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.levelClue[j] = offer.getEnchantmentLevel();
                            continue;
                        }
                        this.costs[j] = 0;
                        this.enchantClue[j] = -1;
                        this.levelClue[j] = -1;
                    }
                    this.broadcastChanges();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                }
            }
        }
    }

    @Override
    public boolean clickMenuButton(Player entityhuman, int i) {
        if (i >= 0 && i < this.costs.length) {
            net.minecraft.world.item.ItemStack itemstack = this.enchantSlots.getItem(0);
            net.minecraft.world.item.ItemStack itemstack1 = this.enchantSlots.getItem(1);
            int j = i + 1;
            if ((itemstack1.isEmpty() || itemstack1.getCount() < j) && !entityhuman.hasInfiniteMaterials()) {
                return false;
            }
            if (this.costs[i] <= 0 || itemstack.isEmpty() || (entityhuman.experienceLevel < j || entityhuman.experienceLevel < this.costs[i]) && !entityhuman.hasInfiniteMaterials()) {
                return false;
            }
            this.access.execute((world, blockposition) -> {
                net.minecraft.world.item.ItemStack itemstack2 = itemstack;
                List<EnchantmentInstance> list = this.getEnchantmentList(world.registryAccess(), itemstack, i, this.costs[i]);
                IdMap registry = world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                for (EnchantmentInstance instance : list) {
                    enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.enchantment()), instance.level());
                }
                CraftItemStack item = CraftItemStack.asCraftMirror(itemstack2);
                org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(registry.byId(this.enchantClue[i]));
                int hintedEnchantmentLevel = this.levelClue[i];
                EnchantItemEvent event = new EnchantItemEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)item, this.costs[i], enchants, hintedEnchantment, hintedEnchantmentLevel, i);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                int level = event.getExpLevelCost();
                if (event.isCancelled() || level > entityhuman.experienceLevel && !entityhuman.getAbilities().instabuild || event.getEnchantsToAdd().isEmpty()) {
                    return;
                }
                if (itemstack.is(Items.BOOK)) {
                    itemstack2 = itemstack.transmuteCopy(Items.ENCHANTED_BOOK);
                    this.enchantSlots.setItem(0, itemstack2);
                }
                for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                    Holder<Enchantment> nms = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                    if (nms == null) continue;
                    EnchantmentInstance weightedrandomenchant = new EnchantmentInstance(nms, (Integer)entry.getValue());
                    itemstack2.enchant(weightedrandomenchant.enchantment(), weightedrandomenchant.level());
                }
                entityhuman.onEnchantmentPerformed(itemstack, j);
                itemstack1.consume(j, entityhuman);
                if (itemstack1.isEmpty()) {
                    this.enchantSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
                }
                entityhuman.awardStat(Stats.ENCHANT_ITEM);
                if (entityhuman instanceof ServerPlayer) {
                    CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)entityhuman, itemstack2, j);
                }
                this.enchantSlots.setChanged();
                this.enchantmentSeed.set(entityhuman.getEnchantmentSeed());
                this.slotsChanged(this.enchantSlots);
                world.playSound((Entity)null, (BlockPos)blockposition, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.1f + 0.9f);
            });
            return true;
        }
        String s = entityhuman.getPlainTextName();
        Util.logAndPauseIfInIde(s + " pressed invalid button id: " + i);
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(RegistryAccess iregistrycustom, net.minecraft.world.item.ItemStack itemstack, int i, int j) {
        this.random.setSeed(this.enchantmentSeed.get() + i);
        Optional optional = iregistrycustom.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(this.random, itemstack, j, ((HolderSet.Named)optional.get()).stream());
        if (itemstack.is(Items.BOOK) && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    public int getGoldCount() {
        net.minecraft.world.item.ItemStack itemstack = this.enchantSlots.getItem(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.enchantSlots));
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return EnchantmentMenu.stillValid(this.access, entityhuman, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public net.minecraft.world.item.ItemStack quickMoveStack(Player entityhuman, int i) {
        net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.item.ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            net.minecraft.world.item.ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (i == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (itemstack1.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.get(0)).hasItem() || !((Slot)this.slots.get(0)).mayPlace(itemstack1)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                net.minecraft.world.item.ItemStack itemstack2 = itemstack1.copyWithCount(1);
                itemstack1.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer(itemstack2);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public CraftEnchantmentView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.enchantSlots);
        this.bukkitEntity = new CraftEnchantmentView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }
}

