/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class BoneMealItem
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public BoneMealItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        return BoneMealItem.applyBonemeal(itemactioncontext);
    }

    public static InteractionResult applyBonemeal(UseOnContext itemactioncontext) {
        Level world = itemactioncontext.getLevel();
        BlockPos blockposition = itemactioncontext.getClickedPos();
        BlockPos blockposition1 = blockposition.relative(itemactioncontext.getClickedFace());
        if (BoneMealItem.growCrop(itemactioncontext.getItemInHand(), world, blockposition)) {
            if (!world.isClientSide()) {
                if (itemactioncontext.getPlayer() != null) {
                    itemactioncontext.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                }
                world.levelEvent(1505, blockposition, 15);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState iblockdata = world.getBlockState(blockposition);
        boolean flag = iblockdata.isFaceSturdy(world, blockposition, itemactioncontext.getClickedFace());
        if (flag && BoneMealItem.growWaterPlant(itemactioncontext.getItemInHand(), world, blockposition1, itemactioncontext.getClickedFace())) {
            if (!world.isClientSide()) {
                if (itemactioncontext.getPlayer() != null) {
                    itemactioncontext.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                }
                world.levelEvent(1505, blockposition1, 15);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean growCrop(ItemStack itemstack, Level world, BlockPos blockposition) {
        BonemealableBlock iblockfragileplantelement;
        BlockState iblockdata = world.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof BonemealableBlock && (iblockfragileplantelement = (BonemealableBlock)((Object)block)).isValidBonemealTarget(world, blockposition, iblockdata)) {
            if (world instanceof ServerLevel) {
                if (iblockfragileplantelement.isBonemealSuccess(world, world.random, blockposition, iblockdata)) {
                    iblockfragileplantelement.performBonemeal((ServerLevel)world, world.random, blockposition, iblockdata);
                }
                itemstack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack itemstack, Level world, BlockPos blockposition, @Nullable Direction enumdirection) {
        if (world.getBlockState(blockposition).is(Blocks.WATER) && world.getFluidState(blockposition).getAmount() == 8) {
            if (!(world instanceof ServerLevel)) {
                return true;
            }
            RandomSource randomsource = world.getRandom();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockposition1 = blockposition;
                BlockState iblockdata = Blocks.SEAGRASS.defaultBlockState();
                for (int j = 0; j < i / 16; ++j) {
                    if (world.getBlockState(blockposition1 = blockposition1.offset(randomsource.nextInt(3) - 1, (randomsource.nextInt(3) - 1) * randomsource.nextInt(3) / 2, randomsource.nextInt(3) - 1)).isCollisionShapeFullBlock(world, blockposition1)) continue block0;
                }
                Holder<Biome> holder = world.getBiome(blockposition1);
                if (holder.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                    if (i == 0 && enumdirection != null && enumdirection.getAxis().isHorizontal()) {
                        iblockdata = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, world.random).map(holder1 -> ((Block)holder1.value()).defaultBlockState()).orElse(iblockdata);
                        if (iblockdata.hasProperty(BaseCoralWallFanBlock.FACING)) {
                            iblockdata = (BlockState)iblockdata.setValue(BaseCoralWallFanBlock.FACING, enumdirection);
                        }
                    } else if (randomsource.nextInt(4) == 0) {
                        iblockdata = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.UNDERWATER_BONEMEALS, world.random).map(holder1 -> ((Block)holder1.value()).defaultBlockState()).orElse(iblockdata);
                    }
                }
                if (iblockdata.is(BlockTags.WALL_CORALS, blockbase_blockdata -> blockbase_blockdata.hasProperty(BaseCoralWallFanBlock.FACING))) {
                    for (int k = 0; !iblockdata.canSurvive(world, blockposition1) && k < 4; ++k) {
                        iblockdata = (BlockState)iblockdata.setValue(BaseCoralWallFanBlock.FACING, Direction.Plane.HORIZONTAL.getRandomDirection(randomsource));
                    }
                }
                if (!iblockdata.canSurvive(world, blockposition1)) continue;
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                if (iblockdata1.is(Blocks.WATER) && world.getFluidState(blockposition1).getAmount() == 8) {
                    world.setBlock(blockposition1, iblockdata, 3);
                    continue;
                }
                if (!iblockdata1.is(Blocks.SEAGRASS) || !((BonemealableBlock)((Object)Blocks.SEAGRASS)).isValidBonemealTarget(world, blockposition1, iblockdata1) || randomsource.nextInt(10) != 0) continue;
                ((BonemealableBlock)((Object)Blocks.SEAGRASS)).performBonemeal((ServerLevel)world, randomsource, blockposition1, iblockdata1);
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(LevelAccessor generatoraccess, BlockPos blockposition, int i) {
        BlockState iblockdata = generatoraccess.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock iblockfragileplantelement = (BonemealableBlock)((Object)block);
            BlockPos blockposition1 = iblockfragileplantelement.getParticlePos(blockposition);
            switch (iblockfragileplantelement.getType()) {
                case NEIGHBOR_SPREADER: {
                    ParticleUtils.spawnParticles(generatoraccess, blockposition1, i * 3, 3.0, 1.0, false, ParticleTypes.HAPPY_VILLAGER);
                    break;
                }
                case GROWER: {
                    ParticleUtils.spawnParticleInBlock(generatoraccess, blockposition1, i, ParticleTypes.HAPPY_VILLAGER);
                }
            }
        } else if (iblockdata.is(Blocks.WATER)) {
            ParticleUtils.spawnParticles(generatoraccess, blockposition, i * 3, 3.0, 1.0, false, ParticleTypes.HAPPY_VILLAGER);
        }
    }
}

