/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityUnleashEvent;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        Level world = itemactioncontext.getLevel();
        Player entityhuman = itemactioncontext.getPlayer();
        if (entityhuman != null && entityhuman.isFallFlying()) {
            return InteractionResult.PASS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ItemStack itemstack = itemactioncontext.getItemInHand();
            Vec3 vec3d = itemactioncontext.getClickLocation();
            Direction enumdirection = itemactioncontext.getClickedFace();
            Projectile.spawnProjectile(new FireworkRocketEntity(world, itemactioncontext.getPlayer(), vec3d.x + (double)enumdirection.getStepX() * 0.15, vec3d.y + (double)enumdirection.getStepY() * 0.15, vec3d.z + (double)enumdirection.getStepZ() * 0.15, itemstack), worldserver, itemstack);
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        if (entityhuman.isFallFlying()) {
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (entityhuman.dropAllLeashConnections(null, EntityUnleashEvent.UnleashReason.FIREWORK)) {
                    world.playSound((Entity)null, entityhuman, SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                Projectile.spawnProjectile(new FireworkRocketEntity(world, itemstack, entityhuman), worldserver, itemstack);
                itemstack.consume(1, entityhuman);
                entityhuman.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Projectile asProjectile(Level world, Position iposition, ItemStack itemstack, Direction enumdirection) {
        return new FireworkRocketEntity(world, itemstack.copyWithCount(1), iposition.x(), iposition.y(), iposition.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityJustOutsideOfBlockPos(BlockSource sourceblock, Direction enumdirection) {
        return sourceblock.center().add((double)enumdirection.getStepX() * 0.5000099999997474, (double)enumdirection.getStepY() * 0.5000099999997474, (double)enumdirection.getStepZ() * 0.5000099999997474);
    }
}

