/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseCooldown;

public class ItemCooldowns {
    public final Map<ResourceLocation, CooldownInstance> cooldowns = Maps.newHashMap();
    public int tickCount;

    public boolean isOnCooldown(ItemStack var0) {
        return this.getCooldownPercent(var0, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(ItemStack var0, float var1) {
        ResourceLocation var2 = this.getCooldownGroup(var0);
        CooldownInstance var3 = this.cooldowns.get(var2);
        if (var3 != null) {
            float var4 = var3.endTime - var3.startTime;
            float var5 = (float)var3.endTime - ((float)this.tickCount + var1);
            return Mth.clamp(var5 / var4, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<ResourceLocation, CooldownInstance>> var0 = this.cooldowns.entrySet().iterator();
            while (var0.hasNext()) {
                Map.Entry<ResourceLocation, CooldownInstance> var1 = var0.next();
                if (var1.getValue().endTime > this.tickCount) continue;
                var0.remove();
                this.onCooldownEnded(var1.getKey());
            }
        }
    }

    public ResourceLocation getCooldownGroup(ItemStack var0) {
        UseCooldown var1 = var0.get(DataComponents.USE_COOLDOWN);
        ResourceLocation var2 = BuiltInRegistries.ITEM.getKey(var0.getItem());
        if (var1 == null) {
            return var2;
        }
        return var1.cooldownGroup().orElse(var2);
    }

    public void addCooldown(ItemStack var0, int var1) {
        this.addCooldown(this.getCooldownGroup(var0), var1);
    }

    public void addCooldown(ResourceLocation var0, int var1) {
        this.cooldowns.put(var0, new CooldownInstance(this.tickCount, this.tickCount + var1));
        this.onCooldownStarted(var0, var1);
    }

    public void removeCooldown(ResourceLocation var0) {
        this.cooldowns.remove(var0);
        this.onCooldownEnded(var0);
    }

    protected void onCooldownStarted(ResourceLocation var0, int var1) {
    }

    protected void onCooldownEnded(ResourceLocation var0) {
    }

    public static final class CooldownInstance
    extends Record {
        final int startTime;
        public final int endTime;

        CooldownInstance(int var0, int var1) {
            this.startTime = var0;
            this.endTime = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CooldownInstance.class, "startTime;endTime", "startTime", "endTime"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CooldownInstance.class, "startTime;endTime", "startTime", "endTime"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CooldownInstance.class, "startTime;endTime", "startTime", "endTime"}, this, var0);
        }

        public int startTime() {
            return this.startTime;
        }

        public int endTime() {
            return this.endTime;
        }
    }
}

