/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class ShieldDecorationRecipe
extends CustomRecipe {
    public ShieldDecorationRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (var0.ingredientCount() != 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof BannerItem) {
                if (var3) {
                    return false;
                }
                var3 = true;
                continue;
            }
            if (var5.is(Items.SHIELD)) {
                if (var2) {
                    return false;
                }
                BannerPatternLayers var6 = var5.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY);
                if (!var6.layers().isEmpty()) {
                    return false;
                }
                var2 = true;
                continue;
            }
            return false;
        }
        return var2 && var3;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        ItemStack var2 = ItemStack.EMPTY;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof BannerItem) {
                var2 = var5;
                continue;
            }
            if (!var5.is(Items.SHIELD)) continue;
            var3 = var5.copy();
        }
        if (var3.isEmpty()) {
            return var3;
        }
        var3.set(DataComponents.BANNER_PATTERNS, var2.get(DataComponents.BANNER_PATTERNS));
        var3.set(DataComponents.BASE_COLOR, ((BannerItem)var2.getItem()).getColor());
        return var3;
    }

    @Override
    public RecipeSerializer<ShieldDecorationRecipe> getSerializer() {
        return RecipeSerializer.SHIELD_DECORATION;
    }
}

