/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftTransmuteRecipe;
import org.bukkit.inventory.Recipe;

public class TransmuteRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final Ingredient input;
    final Ingredient material;
    final TransmuteResult result;
    @Nullable
    private PlacementInfo placementInfo;

    public TransmuteRecipe(String s, CraftingBookCategory craftingbookcategory, Ingredient recipeitemstack, Ingredient recipeitemstack1, TransmuteResult transmuteresult) {
        this.group = s;
        this.category = craftingbookcategory;
        this.input = recipeitemstack;
        this.material = recipeitemstack1;
        this.result = transmuteresult;
    }

    @Override
    public boolean matches(CraftingInput craftinginput, Level world) {
        if (craftinginput.ingredientCount() != 2) {
            return false;
        }
        boolean flag = false;
        boolean flag1 = false;
        for (int i = 0; i < craftinginput.size(); ++i) {
            ItemStack itemstack = craftinginput.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (!flag && this.input.test(itemstack)) {
                if (this.result.isResultUnchanged(itemstack)) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (flag1 || !this.material.test(itemstack)) {
                return false;
            }
            flag1 = true;
        }
        return flag && flag1;
    }

    @Override
    public ItemStack assemble(CraftingInput craftinginput, HolderLookup.Provider holderlookup_a) {
        for (int i = 0; i < craftinginput.size(); ++i) {
            ItemStack itemstack = craftinginput.getItem(i);
            if (itemstack.isEmpty() || !this.input.test(itemstack)) continue;
            return this.result.apply(itemstack);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(List.of(this.input.display(), this.material.display()), this.result.display(), new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        return new CraftTransmuteRecipe(id, CraftRecipe.toBukkit(this.result), CraftRecipe.toBukkit(this.input), CraftRecipe.toBukkit(this.material));
    }

    @Override
    public RecipeSerializer<TransmuteRecipe> getSerializer() {
        return RecipeSerializer.TRANSMUTE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.input, this.material));
        }
        return this.placementInfo;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    public static class Serializer
    implements RecipeSerializer<TransmuteRecipe> {
        private static final MapCodec<TransmuteRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(transmuterecipe -> transmuterecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(transmuterecipe -> transmuterecipe.category), (App)Ingredient.CODEC.fieldOf("input").forGetter(transmuterecipe -> transmuterecipe.input), (App)Ingredient.CODEC.fieldOf("material").forGetter(transmuterecipe -> transmuterecipe.material), (App)TransmuteResult.CODEC.fieldOf("result").forGetter(transmuterecipe -> transmuterecipe.result)).apply((Applicative)instance, TransmuteRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, transmuterecipe -> transmuterecipe.group, CraftingBookCategory.STREAM_CODEC, transmuterecipe -> transmuterecipe.category, Ingredient.CONTENTS_STREAM_CODEC, transmuterecipe -> transmuterecipe.input, Ingredient.CONTENTS_STREAM_CODEC, transmuterecipe -> transmuterecipe.material, TransmuteResult.STREAM_CODEC, transmuterecipe -> transmuterecipe.result, TransmuteRecipe::new);

        @Override
        public MapCodec<TransmuteRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

