/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    public int spawnDelay = 20;
    public WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    public SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;

    public void setEntityId(EntityType<?> entitytypes, @Nullable Level world, RandomSource randomsource, BlockPos blockposition) {
        this.getOrCreateNextSpawnData(world, randomsource, blockposition).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entitytypes).toString());
        this.spawnPotentials = WeightedList.of();
    }

    private boolean isNearPlayer(Level world, BlockPos blockposition) {
        return world.hasNearbyAlivePlayer((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level world, BlockPos blockposition) {
        if (!this.isNearPlayer(world, blockposition)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = world.getRandom();
            double d0 = (double)blockposition.getX() + randomsource.nextDouble();
            double d1 = (double)blockposition.getY() + randomsource.nextDouble();
            double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle(ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel worldserver, BlockPos blockposition) {
        if (this.isNearPlayer(worldserver, blockposition) && worldserver.getServer().isSpawnerBlockEnabled()) {
            if (this.spawnDelay == -1) {
                this.delay(worldserver, blockposition);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = worldserver.getRandom();
                SpawnData mobspawnerdata = this.getOrCreateNextSpawnData(worldserver, randomsource, blockposition);
                for (int i = 0; i < this.spawnCount; ++i) {
                    try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this::toString, LOGGER);){
                        ValueInput valueinput = TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)worldserver.registryAccess(), mobspawnerdata.getEntityToSpawn());
                        Optional<EntityType<?>> optional = EntityType.by(valueinput);
                        if (optional.isEmpty()) {
                            this.delay(worldserver, blockposition);
                            return;
                        }
                        Vec3 vec3d = valueinput.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)blockposition.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5, blockposition.getY() + randomsource.nextInt(3) - 1, (double)blockposition.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5));
                        if (!worldserver.noCollision(optional.get().getSpawnAABB(vec3d.x, vec3d.y, vec3d.z))) continue;
                        BlockPos blockposition1 = BlockPos.containing(vec3d);
                        if (mobspawnerdata.getCustomSpawnRules().isPresent()) {
                            SpawnData.CustomSpawnRules mobspawnerdata_a;
                            if (!optional.get().getCategory().isFriendly() && worldserver.getDifficulty() == Difficulty.PEACEFUL || !(mobspawnerdata_a = mobspawnerdata.getCustomSpawnRules().get()).isValidPosition(blockposition1, worldserver)) continue;
                        } else if (!SpawnPlacements.checkSpawnRules(optional.get(), worldserver, EntitySpawnReason.SPAWNER, blockposition1, worldserver.getRandom())) continue;
                        Entity entity = EntityType.loadEntityRecursive(valueinput, (Level)worldserver, EntitySpawnReason.SPAWNER, entity1 -> {
                            entity1.snapTo(vec3d.x, vec3d.y, vec3d.z, entity1.getYRot(), entity1.getXRot());
                            return entity1;
                        });
                        if (entity == null) {
                            this.delay(worldserver, blockposition);
                            return;
                        }
                        int j = worldserver.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB(blockposition.getX(), blockposition.getY(), blockposition.getZ(), blockposition.getX() + 1, blockposition.getY() + 1, blockposition.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                        if (j >= this.maxNearbyEntities) {
                            this.delay(worldserver, blockposition);
                            return;
                        }
                        entity.snapTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            boolean flag1;
                            Mob entityinsentient = (Mob)entity;
                            if (mobspawnerdata.getCustomSpawnRules().isEmpty() && !entityinsentient.checkSpawnRules(worldserver, EntitySpawnReason.SPAWNER) || !entityinsentient.checkSpawnObstruction(worldserver)) continue;
                            boolean bl = flag1 = mobspawnerdata.getEntityToSpawn().size() == 1 && mobspawnerdata.getEntityToSpawn().getString("id").isPresent();
                            if (flag1) {
                                ((Mob)entity).finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entity.blockPosition()), EntitySpawnReason.SPAWNER, null);
                            }
                            Optional<EquipmentTable> optional1 = mobspawnerdata.getEquipment();
                            Objects.requireNonNull(entityinsentient);
                            optional1.ifPresent(entityinsentient::equip);
                        }
                        if (CraftEventFactory.callSpawnerSpawnEvent(entity, blockposition).isCancelled()) continue;
                        if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                            this.delay(worldserver, blockposition);
                            return;
                        }
                        worldserver.levelEvent(2004, blockposition, 0);
                        worldserver.gameEvent(entity, GameEvent.ENTITY_PLACE, blockposition1);
                        if (entity instanceof Mob) {
                            ((Mob)entity).spawnAnim();
                        }
                        flag = true;
                        continue;
                    }
                }
                if (flag) {
                    this.delay(worldserver, blockposition);
                }
            }
        }
    }

    private void delay(Level world, BlockPos blockposition) {
        RandomSource randomsource = world.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(mobspawnerdata -> this.setNextSpawnData(world, blockposition, (SpawnData)mobspawnerdata));
        this.broadcastEvent(world, blockposition, 1);
    }

    public void load(@Nullable Level world, BlockPos blockposition, ValueInput valueinput) {
        this.spawnDelay = valueinput.getShortOr("Delay", (short)20);
        valueinput.read(SPAWN_DATA_TAG, SpawnData.CODEC).ifPresent(mobspawnerdata -> this.setNextSpawnData(world, blockposition, (SpawnData)mobspawnerdata));
        this.spawnPotentials = valueinput.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        this.minSpawnDelay = valueinput.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = valueinput.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = valueinput.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = valueinput.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = valueinput.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = valueinput.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public void save(ValueOutput valueoutput) {
        valueoutput.putShort("Delay", (short)this.spawnDelay);
        valueoutput.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        valueoutput.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        valueoutput.putShort("SpawnCount", (short)this.spawnCount);
        valueoutput.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        valueoutput.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        valueoutput.putShort("SpawnRange", (short)this.spawnRange);
        valueoutput.storeNullable(SPAWN_DATA_TAG, SpawnData.CODEC, this.nextSpawnData);
        valueoutput.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level world, BlockPos blockposition) {
        if (this.displayEntity == null) {
            CompoundTag nbttagcompound = this.getOrCreateNextSpawnData(world, world.getRandom(), blockposition).getEntityToSpawn();
            if (nbttagcompound.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive(nbttagcompound, world, EntitySpawnReason.SPAWNER, Function.identity());
            if (nbttagcompound.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level world, int i) {
        if (i == 1) {
            if (world.isClientSide()) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level world, BlockPos blockposition, SpawnData mobspawnerdata) {
        this.nextSpawnData = mobspawnerdata;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level world, RandomSource randomsource, BlockPos blockposition) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(world, blockposition, this.spawnPotentials.getRandom(randomsource).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

