/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseRailBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_FLAT = Block.column(16.0, 0.0, 2.0);
    private static final VoxelShape SHAPE_SLOPE = Block.column(16.0, 0.0, 8.0);
    private final boolean isStraight;

    public static boolean isRail(Level var0, BlockPos var1) {
        return BaseRailBlock.isRail(var0.getBlockState(var1));
    }

    public static boolean isRail(BlockState var0) {
        return var0.is(BlockTags.RAILS) && var0.getBlock() instanceof BaseRailBlock;
    }

    protected BaseRailBlock(boolean var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.isStraight = var0;
    }

    protected abstract MapCodec<? extends BaseRailBlock> codec();

    public boolean isStraight() {
        return this.isStraight;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return var0.getValue(this.getShapeProperty()).isSlope() ? SHAPE_SLOPE : SHAPE_FLAT;
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return BaseRailBlock.canSupportRigidBlock(var1, var2.below());
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.updateState(var0, var1, var2, var4);
    }

    protected BlockState updateState(BlockState var0, Level var1, BlockPos var2, boolean var3) {
        var0 = this.updateDir(var1, var2, var0, true);
        if (this.isStraight) {
            var1.neighborChanged(var0, var2, this, null, var3);
        }
        return var0;
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide() || !var1.getBlockState(var2).is(this)) {
            return;
        }
        RailShape var6 = var0.getValue(this.getShapeProperty());
        if (BaseRailBlock.shouldBeRemoved(var2, var1, var6)) {
            BaseRailBlock.dropResources(var0, var1, var2);
            var1.removeBlock(var2, var5);
        } else {
            this.updateState(var0, var1, var2, var3);
        }
    }

    private static boolean shouldBeRemoved(BlockPos var0, Level var1, RailShape var2) {
        if (!BaseRailBlock.canSupportRigidBlock(var1, var0.below())) {
            return true;
        }
        switch (var2) {
            case ASCENDING_EAST: {
                return !BaseRailBlock.canSupportRigidBlock(var1, var0.east());
            }
            case ASCENDING_WEST: {
                return !BaseRailBlock.canSupportRigidBlock(var1, var0.west());
            }
            case ASCENDING_NORTH: {
                return !BaseRailBlock.canSupportRigidBlock(var1, var0.north());
            }
            case ASCENDING_SOUTH: {
                return !BaseRailBlock.canSupportRigidBlock(var1, var0.south());
            }
        }
        return false;
    }

    protected void updateState(BlockState var0, Level var1, BlockPos var2, Block var3) {
    }

    protected BlockState updateDir(Level var0, BlockPos var1, BlockState var2, boolean var3) {
        if (var0.isClientSide()) {
            return var2;
        }
        RailShape var4 = var2.getValue(this.getShapeProperty());
        return new RailState(var0, var1, var2).place(var0.hasNeighborSignal(var1), var3, var4).getState();
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        if (var3) {
            return;
        }
        if (var0.getValue(this.getShapeProperty()).isSlope()) {
            var1.updateNeighborsAt(var2.above(), this);
        }
        if (this.isStraight) {
            var1.updateNeighborsAt(var2, this);
            var1.updateNeighborsAt(var2.below(), this);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        FluidState var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == Fluids.WATER;
        BlockState var3 = super.defaultBlockState();
        Direction var4 = var0.getHorizontalDirection();
        boolean var5 = var4 == Direction.EAST || var4 == Direction.WEST;
        return (BlockState)((BlockState)var3.setValue(this.getShapeProperty(), var5 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH)).setValue(WATERLOGGED, var2);
    }

    public abstract Property<RailShape> getShapeProperty();

    protected RailShape rotate(RailShape var0, Rotation var1) {
        return switch (var1) {
            case Rotation.CLOCKWISE_180 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield RailShape.NORTH_SOUTH;
                    }
                    case EAST_WEST: {
                        yield RailShape.EAST_WEST;
                    }
                    case ASCENDING_EAST: {
                        yield RailShape.ASCENDING_WEST;
                    }
                    case ASCENDING_WEST: {
                        yield RailShape.ASCENDING_EAST;
                    }
                    case ASCENDING_NORTH: {
                        yield RailShape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_SOUTH: {
                        yield RailShape.ASCENDING_NORTH;
                    }
                    case SOUTH_EAST: {
                        yield RailShape.NORTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield RailShape.NORTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield RailShape.SOUTH_EAST;
                    }
                    case NORTH_EAST: 
                }
                yield RailShape.SOUTH_WEST;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield RailShape.EAST_WEST;
                    }
                    case EAST_WEST: {
                        yield RailShape.NORTH_SOUTH;
                    }
                    case ASCENDING_EAST: {
                        yield RailShape.ASCENDING_NORTH;
                    }
                    case ASCENDING_WEST: {
                        yield RailShape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_NORTH: {
                        yield RailShape.ASCENDING_WEST;
                    }
                    case ASCENDING_SOUTH: {
                        yield RailShape.ASCENDING_EAST;
                    }
                    case SOUTH_EAST: {
                        yield RailShape.NORTH_EAST;
                    }
                    case SOUTH_WEST: {
                        yield RailShape.SOUTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield RailShape.SOUTH_WEST;
                    }
                    case NORTH_EAST: 
                }
                yield RailShape.NORTH_WEST;
            }
            case Rotation.CLOCKWISE_90 -> {
                switch (var0) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORTH_SOUTH: {
                        yield RailShape.EAST_WEST;
                    }
                    case EAST_WEST: {
                        yield RailShape.NORTH_SOUTH;
                    }
                    case ASCENDING_EAST: {
                        yield RailShape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_WEST: {
                        yield RailShape.ASCENDING_NORTH;
                    }
                    case ASCENDING_NORTH: {
                        yield RailShape.ASCENDING_EAST;
                    }
                    case ASCENDING_SOUTH: {
                        yield RailShape.ASCENDING_WEST;
                    }
                    case SOUTH_EAST: {
                        yield RailShape.SOUTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield RailShape.NORTH_WEST;
                    }
                    case NORTH_WEST: {
                        yield RailShape.NORTH_EAST;
                    }
                    case NORTH_EAST: 
                }
                yield RailShape.SOUTH_EAST;
            }
            default -> var0;
        };
    }

    protected RailShape mirror(RailShape var0, Mirror var1) {
        return switch (var1) {
            case Mirror.LEFT_RIGHT -> {
                switch (var0) {
                    case ASCENDING_NORTH: {
                        yield RailShape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_SOUTH: {
                        yield RailShape.ASCENDING_NORTH;
                    }
                    case SOUTH_EAST: {
                        yield RailShape.NORTH_EAST;
                    }
                    case SOUTH_WEST: {
                        yield RailShape.NORTH_WEST;
                    }
                    case NORTH_WEST: {
                        yield RailShape.SOUTH_WEST;
                    }
                    case NORTH_EAST: {
                        yield RailShape.SOUTH_EAST;
                    }
                }
                yield var0;
            }
            case Mirror.FRONT_BACK -> {
                switch (var0) {
                    case ASCENDING_EAST: {
                        yield RailShape.ASCENDING_WEST;
                    }
                    case ASCENDING_WEST: {
                        yield RailShape.ASCENDING_EAST;
                    }
                    case SOUTH_EAST: {
                        yield RailShape.SOUTH_WEST;
                    }
                    case SOUTH_WEST: {
                        yield RailShape.SOUTH_EAST;
                    }
                    case NORTH_WEST: {
                        yield RailShape.NORTH_EAST;
                    }
                    case NORTH_EAST: {
                        yield RailShape.NORTH_WEST;
                    }
                }
                yield var0;
            }
            default -> var0;
        };
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }
}

