/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class CropBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<CropBlock> CODEC = CropBlock.simpleCodec(CropBlock::new);
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    private static final VoxelShape[] SHAPES = Block.boxes(7, i -> Block.column(16.0, 0.0, 2 + i * 2));

    public MapCodec<? extends CropBlock> codec() {
        return CODEC;
    }

    protected CropBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(this.getAgeProperty(), 0));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES[this.getAge(iblockdata)];
    }

    @Override
    protected boolean mayPlaceOn(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockdata.is(Blocks.FARMLAND);
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(BlockState iblockdata) {
        return iblockdata.getValue(this.getAgeProperty());
    }

    public BlockState getStateForAge(int i) {
        return (BlockState)this.defaultBlockState().setValue(this.getAgeProperty(), i);
    }

    public final boolean isMaxAge(BlockState iblockdata) {
        return this.getAge(iblockdata) >= this.getMaxAge();
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return !this.isMaxAge(iblockdata);
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        float f;
        int i;
        if (worldserver.getRawBrightness(blockposition, 0) >= 9 && (i = this.getAge(iblockdata)) < this.getMaxAge() && randomsource.nextInt((int)(25.0f / (f = CropBlock.getGrowthSpeed(this, worldserver, blockposition))) + 1) == 0) {
            CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, this.getStateForAge(i + 1), 2);
        }
    }

    public void growCrops(Level world, BlockPos blockposition, BlockState iblockdata) {
        int i = Math.min(this.getMaxAge(), this.getAge(iblockdata) + this.getBonemealAgeIncrease(world));
        CraftEventFactory.handleBlockGrowEvent(world, blockposition, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level world) {
        return Mth.nextInt(world.random, 2, 5);
    }

    protected static float getGrowthSpeed(Block block, BlockGetter iblockaccess, BlockPos blockposition) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockposition1 = blockposition.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState iblockdata = iblockaccess.getBlockState(blockposition1.offset(i, 0, j));
                if (iblockdata.is(Blocks.FARMLAND)) {
                    f1 = 1.0f;
                    if (iblockdata.getValue(FarmBlock.MOISTURE) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockposition2 = blockposition.north();
        BlockPos blockposition3 = blockposition.south();
        BlockPos blockposition4 = blockposition.west();
        BlockPos blockposition5 = blockposition.east();
        boolean flag = iblockaccess.getBlockState(blockposition4).is(block) || iblockaccess.getBlockState(blockposition5).is(block);
        boolean bl = flag1 = iblockaccess.getBlockState(blockposition2).is(block) || iblockaccess.getBlockState(blockposition3).is(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = iblockaccess.getBlockState(blockposition4.north()).is(block) || iblockaccess.getBlockState(blockposition5.north()).is(block) || iblockaccess.getBlockState(blockposition5.south()).is(block) || iblockaccess.getBlockState(blockposition4.south()).is(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return CropBlock.hasSufficientLight(iworldreader, blockposition) && super.canSurvive(iblockdata, iworldreader, blockposition);
    }

    protected static boolean hasSufficientLight(LevelReader iworldreader, BlockPos blockposition) {
        return iworldreader.getRawBrightness(blockposition, 0) >= 8;
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (entity instanceof Ravager && CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.AIR.defaultBlockState(), !worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
                worldserver.destroyBlock(blockposition, true, entity);
            }
        }
        super.entityInside(iblockdata, world, blockposition, entity, insideblockeffectapplier);
    }

    protected ItemLike getBaseSeedId() {
        return Items.WHEAT_SEEDS;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return new ItemStack(this.getBaseSeedId());
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return !this.isMaxAge(iblockdata);
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        this.growCrops(worldserver, blockposition, iblockdata);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }
}

